/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowSet;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceFactory;

public class ReferenceContainer<ReferenceType extends Reference>
extends RowSet {
    private static final long serialVersionUID = -540567425172727979L;
    private byte[] termHash;
    protected ReferenceFactory<ReferenceType> factory;
    public static int maxReferences = 0;
    public static final Method containerMergeMethod;

    public ReferenceContainer(ReferenceFactory<ReferenceType> factory, byte[] termHash, RowSet collection) {
        super(collection);
        assert (termHash == null || termHash[2] != 64 && termHash.length == this.rowdef.primaryKeyLength);
        this.factory = factory;
        this.termHash = termHash;
    }

    public ReferenceContainer(ReferenceFactory<ReferenceType> factory, byte[] termHash) {
        super(factory.getRow());
        assert (termHash == null || termHash[2] != 64 && termHash.length == this.rowdef.primaryKeyLength);
        this.termHash = termHash;
        this.factory = factory;
        this.lastTimeWrote = 0L;
    }

    public ReferenceContainer(ReferenceFactory<ReferenceType> factory, byte[] termHash, int objectCount) throws SpaceExceededException {
        super(factory.getRow(), objectCount);
        assert (termHash == null || termHash[2] != 64 && termHash.length == this.rowdef.primaryKeyLength);
        this.termHash = termHash;
        this.factory = factory;
        this.lastTimeWrote = 0L;
    }

    public ReferenceContainer<ReferenceType> topLevelClone() throws SpaceExceededException {
        ReferenceContainer<ReferenceType> newContainer = new ReferenceContainer<ReferenceType>(this.factory, this.termHash, this.size());
        newContainer.addAllUnique(this);
        return newContainer;
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> emptyContainer(ReferenceFactory<ReferenceType> factory, byte[] termHash) {
        assert (termHash == null || termHash[2] != 64 && termHash.length == factory.getRow().primaryKeyLength);
        return new ReferenceContainer<ReferenceType>(factory, termHash);
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> emptyContainer(ReferenceFactory<ReferenceType> factory, byte[] termHash, int elementCount) throws SpaceExceededException {
        assert (termHash == null || termHash[2] != 64 && termHash.length == factory.getRow().primaryKeyLength);
        return new ReferenceContainer<ReferenceType>(factory, termHash, elementCount);
    }

    public void setWordHash(byte[] newTermHash) {
        assert (this.termHash == null || this.termHash[2] != 64 && this.termHash.length == this.rowdef.primaryKeyLength);
        this.termHash = newTermHash;
    }

    public long updated() {
        return super.lastWrote();
    }

    public byte[] getTermHash() {
        return this.termHash;
    }

    public void add(Reference entry2) throws SpaceExceededException {
        assert (entry2.toKelondroEntry().objectsize() == this.rowdef.objectsize);
        this.addUnique(entry2.toKelondroEntry());
    }

    public ReferenceContainer<ReferenceType> merge(ReferenceContainer<ReferenceType> c) throws SpaceExceededException {
        return new ReferenceContainer<ReferenceType>(this.factory, this.termHash, super.merge(c));
    }

    public Reference replace(Reference entry2) throws SpaceExceededException {
        assert (entry2.toKelondroEntry().objectsize() == this.rowdef.objectsize);
        Row.Entry r = super.replace(entry2.toKelondroEntry());
        if (r == null) {
            return null;
        }
        return this.factory.produceSlow(r);
    }

    public void put(Reference entry2) throws SpaceExceededException {
        assert (entry2.toKelondroEntry().objectsize() == this.rowdef.objectsize);
        super.put(entry2.toKelondroEntry());
    }

    public boolean putRecent(Reference entry2) throws SpaceExceededException {
        assert (entry2.toKelondroEntry().objectsize() == this.rowdef.objectsize);
        Row.Entry oldEntryRow = this.replace(entry2.toKelondroEntry());
        if (oldEntryRow == null) {
            return true;
        }
        ReferenceType oldEntry = this.factory.produceSlow(oldEntryRow);
        if (entry2.isOlder((Reference)oldEntry)) {
            this.replace(oldEntry.toKelondroEntry());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int putAllRecent(ReferenceContainer<ReferenceType> c) throws SpaceExceededException {
        if (c == null) {
            return 0;
        }
        int x = 0;
        ReferenceContainer<ReferenceType> referenceContainer = c;
        synchronized (referenceContainer) {
            Iterator<ReferenceType> i = c.entries();
            while (i.hasNext()) {
                try {
                    if (!this.putRecent((Reference)i.next())) continue;
                    ++x;
                }
                catch (ConcurrentModificationException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        this.lastTimeWrote = Math.max(this.lastTimeWrote, c.updated());
        return x;
    }

    public ReferenceType getReference(byte[] urlHash) {
        Row.Entry entry2 = super.get(urlHash, false);
        if (entry2 == null) {
            return null;
        }
        return this.factory.produceSlow(entry2);
    }

    public ReferenceType removeReference(byte[] urlHash) {
        Row.Entry entry2 = super.remove(urlHash);
        if (entry2 == null) {
            return null;
        }
        return this.factory.produceSlow(entry2);
    }

    public int removeEntries(HandleSet urlHashes) {
        int count = 0;
        Iterator<byte[]> i = urlHashes.iterator();
        while (i.hasNext()) {
            count += this.delete(i.next()) ? 1 : 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shrinkReferences() {
        int oldsize = this.size();
        int diff = oldsize - maxReferences;
        if (maxReferences <= 0 || diff <= 0) {
            return 0;
        }
        ReferenceContainer referenceContainer = this;
        synchronized (referenceContainer) {
            int[] indexes = this.oldPostions(diff);
            Arrays.sort(indexes);
            for (int i = indexes.length - 1; i >= 0 && indexes[i] >= 0; --i) {
                this.removeRow(indexes[i], false);
            }
            this.sort();
        }
        this.trim();
        return oldsize - this.size();
    }

    private int[] oldPostions(int count) {
        int[] indexes = new int[count];
        int i = 0;
        for (List<Integer> positions : this.positionsByLastMod()) {
            for (Integer pos : positions) {
                indexes[i++] = pos;
                if (i < count) continue;
                return indexes;
            }
        }
        return indexes;
    }

    private Collection<List<Integer>> positionsByLastMod() {
        TreeMap<Long, ArrayList<Integer>> tm = new TreeMap<Long, ArrayList<Integer>>();
        Iterator<ReferenceType> i = this.entries();
        int pos = 0;
        while (i.hasNext()) {
            Reference r = (Reference)i.next();
            if (r == null) continue;
            long mod = r.lastModified();
            ArrayList<Integer> positions = (ArrayList<Integer>)tm.get(mod);
            if (positions == null) {
                positions = new ArrayList<Integer>();
            }
            positions.add(pos++);
            tm.put(mod, positions);
        }
        return tm.values();
    }

    public Iterator<ReferenceType> entries() {
        return new entryIterator();
    }

    public static Object mergeUnique(Object a, Object b) throws SpaceExceededException {
        if (a instanceof ReferenceContainer) {
            ReferenceContainer c = (ReferenceContainer)a;
            c.addAllUnique((ReferenceContainer)b);
            return c;
        }
        throw new UnsupportedOperationException("Objects have wrong type: " + a.getClass().getName());
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> joinExcludeContainers(ReferenceFactory<ReferenceType> factory, Collection<ReferenceContainer<ReferenceType>> includeContainers, Collection<ReferenceContainer<ReferenceType>> excludeContainers, int maxDistance) throws SpaceExceededException {
        if (includeContainers == null) {
            return ReferenceContainer.emptyContainer(factory, null, 0);
        }
        ReferenceContainer<ReferenceType> rcLocal = ReferenceContainer.joinContainers(factory, includeContainers, maxDistance);
        if (rcLocal == null) {
            return ReferenceContainer.emptyContainer(factory, null, 0);
        }
        ReferenceContainer.excludeContainers(factory, rcLocal, excludeContainers);
        return rcLocal;
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> joinContainers(ReferenceFactory<ReferenceType> factory, Collection<ReferenceContainer<ReferenceType>> containers, int maxDistance) throws SpaceExceededException {
        TreeMap<Long, ReferenceContainer<ReferenceType>> map = new TreeMap<Long, ReferenceContainer<ReferenceType>>();
        Iterator<ReferenceContainer<ReferenceType>> i = containers.iterator();
        int count = 0;
        while (i.hasNext()) {
            ReferenceContainer<ReferenceType> singleContainer = i.next();
            if (singleContainer == null || singleContainer.isEmpty()) {
                return null;
            }
            map.put(Long.valueOf(singleContainer.size() * 1000 + count), singleContainer);
            ++count;
        }
        if (map.isEmpty()) {
            return null;
        }
        Long k = (Long)map.firstKey();
        ReferenceContainer<ReferenceType> searchResult = (ReferenceContainer<ReferenceType>)map.remove(k);
        while (!map.isEmpty() && !searchResult.isEmpty()) {
            k = (Long)map.firstKey();
            ReferenceContainer<ReferenceType> searchA = searchResult;
            ReferenceContainer searchB = (ReferenceContainer)map.remove(k);
            searchResult = ReferenceContainer.joinConstructive(factory, searchA, searchB, maxDistance);
            searchA = null;
            searchB = null;
        }
        if (searchResult.isEmpty()) {
            return null;
        }
        return searchResult;
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> excludeContainers(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> pivot, Collection<ReferenceContainer<ReferenceType>> containers) {
        if (containers == null || containers.isEmpty()) {
            return pivot;
        }
        Iterator<ReferenceContainer<ReferenceType>> i = containers.iterator();
        while (i.hasNext()) {
            if ((pivot = ReferenceContainer.excludeDestructive(factory, pivot, i.next())) != null && !pivot.isEmpty()) continue;
            return null;
        }
        return pivot;
    }

    private static int log2(int x) {
        int l = 0;
        while (x > 0) {
            x >>= 1;
            ++l;
        }
        return l;
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> joinConstructive(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> i1, ReferenceContainer<ReferenceType> i2, int maxDistance) throws SpaceExceededException {
        int stepsTest;
        int low;
        if (i1 == null || i2 == null) {
            return null;
        }
        if (i1.isEmpty() || i2.isEmpty()) {
            return null;
        }
        int high = i1.size() > i2.size() ? i1.size() : i2.size();
        int stepsEnum = 10 * (high + (low = i1.size() > i2.size() ? i2.size() : i1.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * ReferenceContainer.log2(high) * low)) {
            if (i1.size() < i2.size()) {
                return ReferenceContainer.joinConstructiveByTest(factory, i1, i2, maxDistance);
            }
            return ReferenceContainer.joinConstructiveByTest(factory, i2, i1, maxDistance);
        }
        return ReferenceContainer.joinConstructiveByEnumeration(factory, i1, i2, maxDistance);
    }

    private static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> joinConstructiveByTest(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> small, ReferenceContainer<ReferenceType> large, int maxDistance) throws SpaceExceededException {
        assert (small.rowdef.equals(large.rowdef)) : "small = " + small.rowdef.toString() + "; large = " + large.rowdef.toString();
        int keylength = small.rowdef.width(0);
        assert (keylength == large.rowdef.width(0));
        ReferenceContainer<ReferenceType> conj = new ReferenceContainer<ReferenceType>(factory, null, 0);
        Iterator<ReferenceType> se = small.entries();
        while (se.hasNext()) {
            Reference ie1 = (Reference)se.next();
            ReferenceType ie2 = large.getReference(ie1.urlhash());
            if (ie1 == null || ie2 == null) continue;
            assert (ie1.urlhash().length == keylength) : "ie0.urlHash() = " + ASCII.String(ie1.urlhash());
            assert (ie2.urlhash().length == keylength) : "ie1.urlHash() = " + ASCII.String(ie2.urlhash());
            ie1 = factory.produceFast(ie2, true);
            ie1.join((Reference)ie2);
            if (ie1.distance() > maxDistance) continue;
            conj.add(ie1);
        }
        return conj;
    }

    private static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> joinConstructiveByEnumeration(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> i1, ReferenceContainer<ReferenceType> i2, int maxDistance) throws SpaceExceededException {
        assert (i1.rowdef.equals(i2.rowdef)) : "i1 = " + i1.rowdef.toString() + "; i2 = " + i2.rowdef.toString();
        int keylength = i1.rowdef.width(0);
        assert (keylength == i2.rowdef.width(0));
        ReferenceContainer<ReferenceType> conj = new ReferenceContainer<ReferenceType>(factory, null, 0);
        if (!i1.rowdef.getOrdering().signature().equals(i2.rowdef.getOrdering().signature())) {
            return conj;
        }
        ByteOrder ordering = i1.rowdef.getOrdering();
        Iterator<ReferenceType> e1 = i1.entries();
        Iterator<ReferenceType> e2 = i2.entries();
        if (e1.hasNext() && e2.hasNext()) {
            Reference ie1 = (Reference)e1.next();
            Reference ie2 = (Reference)e2.next();
            while (true) {
                assert (ie1.urlhash().length == keylength) : "ie1.urlHash() = " + ASCII.String(ie1.urlhash());
                assert (ie2.urlhash().length == keylength) : "ie2.urlHash() = " + ASCII.String(ie2.urlhash());
                int c = ordering.compare(ie1.urlhash(), ie2.urlhash());
                if (c < 0) {
                    if (!e1.hasNext()) break;
                    ie1 = (Reference)e1.next();
                    continue;
                }
                if (c > 0) {
                    if (!e2.hasNext()) break;
                    ie2 = (Reference)e2.next();
                    continue;
                }
                ie1 = factory.produceFast(ie1, true);
                ie1.join(ie2);
                if (ie1.distance() <= maxDistance) {
                    conj.add(ie1);
                }
                if (!e1.hasNext()) break;
                ie1 = (Reference)e1.next();
                if (!e2.hasNext()) break;
                ie2 = (Reference)e2.next();
            }
        }
        return conj;
    }

    public static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> excludeDestructive(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> pivot, ReferenceContainer<ReferenceType> excl) {
        int stepsTest;
        int low;
        if (pivot == null) {
            return null;
        }
        if (excl == null) {
            return pivot;
        }
        if (pivot.isEmpty()) {
            return null;
        }
        if (excl.isEmpty()) {
            return pivot;
        }
        int high = pivot.size() > excl.size() ? pivot.size() : excl.size();
        int stepsEnum = 10 * (high + (low = pivot.size() > excl.size() ? excl.size() : pivot.size()) - 1);
        if (stepsEnum > (stepsTest = 12 * ReferenceContainer.log2(high) * low)) {
            return ReferenceContainer.excludeDestructiveByTest(pivot, excl);
        }
        return ReferenceContainer.excludeDestructiveByEnumeration(factory, pivot, excl);
    }

    private static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> excludeDestructiveByTest(ReferenceContainer<ReferenceType> pivot, ReferenceContainer<ReferenceType> excl) {
        Iterator<ReferenceType> se;
        assert (pivot.rowdef.equals(excl.rowdef)) : "small = " + pivot.rowdef.toString() + "; large = " + excl.rowdef.toString();
        int keylength = pivot.rowdef.width(0);
        assert (keylength == excl.rowdef.width(0));
        boolean iterate_pivot = pivot.size() < excl.size();
        Iterator<ReferenceType> iterator = se = iterate_pivot ? pivot.entries() : excl.entries();
        while (se.hasNext()) {
            Reference ie0 = (Reference)se.next();
            ReferenceType ie1 = excl.getReference(ie0.urlhash());
            if (ie0 == null || ie1 == null) continue;
            assert (ie0.urlhash().length == keylength) : "ie0.urlHash() = " + ASCII.String(ie0.urlhash());
            assert (ie1.urlhash().length == keylength) : "ie1.urlHash() = " + ASCII.String(ie1.urlhash());
            if (iterate_pivot) {
                se.remove();
            }
            pivot.delete(ie0.urlhash());
        }
        return pivot;
    }

    private static <ReferenceType extends Reference> ReferenceContainer<ReferenceType> excludeDestructiveByEnumeration(ReferenceFactory<ReferenceType> factory, ReferenceContainer<ReferenceType> pivot, ReferenceContainer<ReferenceType> excl) {
        assert (pivot.rowdef.equals(excl.rowdef)) : "i1 = " + pivot.rowdef.toString() + "; i2 = " + excl.rowdef.toString();
        int keylength = pivot.rowdef.width(0);
        assert (keylength == excl.rowdef.width(0));
        if (!pivot.rowdef.getOrdering().signature().equals(excl.rowdef.getOrdering().signature())) {
            return pivot;
        }
        Iterator<ReferenceType> e1 = pivot.entries();
        Iterator<ReferenceType> e2 = excl.entries();
        if (e1.hasNext() && e2.hasNext()) {
            Reference ie1 = (Reference)e1.next();
            Reference ie2 = (Reference)e2.next();
            while (true) {
                assert (ie1.urlhash().length == keylength) : "ie1.urlHash() = " + ASCII.String(ie1.urlhash());
                assert (ie2.urlhash().length == keylength) : "ie2.urlHash() = " + ASCII.String(ie2.urlhash());
                int c = pivot.rowdef.getOrdering().compare(ie1.urlhash(), ie2.urlhash());
                if (c < 0) {
                    if (!e1.hasNext()) break;
                    ie1 = (Reference)e1.next();
                    continue;
                }
                if (c > 0) {
                    if (!e2.hasNext()) break;
                    ie2 = (Reference)e2.next();
                    continue;
                }
                ie1 = factory.produceFast(ie1, true);
                ie1.join(ie2);
                e1.remove();
                if (!e1.hasNext()) break;
                ie1 = (Reference)e1.next();
                if (!e2.hasNext()) break;
                ie2 = (Reference)e2.next();
            }
        }
        return pivot;
    }

    @Override
    public synchronized String toString() {
        return "C[" + ASCII.String(this.termHash) + "] has " + this.size() + " entries";
    }

    public int hashCode() {
        return (int)Base64Order.enhancedCoder.decodeLong(this.termHash, 0, 4);
    }

    static {
        Method meth = null;
        try {
            Class<ReferenceContainer> c = ReferenceContainer.class;
            Class[] args = (Class[])Array.newInstance(Class.class, 2);
            args[0] = Object.class;
            args[1] = Object.class;
            meth = c.getMethod("mergeUnique", args);
        }
        catch (SecurityException e) {
            System.out.println("Error while initializing containerMerge.SecurityException: " + e.getMessage());
            meth = null;
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error while initializing containerMerge.NoSuchMethodException: " + e.getMessage());
            meth = null;
        }
        assert (meth != null);
        containerMergeMethod = meth;
    }

    public class entryIterator
    implements Iterator<ReferenceType> {
        Iterator<Row.Entry> rowEntryIterator;

        public entryIterator() {
            this.rowEntryIterator = ReferenceContainer.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowEntryIterator.hasNext();
        }

        @Override
        public ReferenceType next() {
            Row.Entry rentry = this.rowEntryIterator.next();
            if (rentry == null) {
                return null;
            }
            return ReferenceContainer.this.factory.produceSlow(rentry);
        }

        @Override
        public void remove() {
            this.rowEntryIterator.remove();
        }
    }
}

