/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.blob.ArrayStack;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainerArray;
import net.yacy.kelondro.rwi.ReferenceContainerCache;
import net.yacy.kelondro.rwi.ReferenceFactory;
import net.yacy.kelondro.util.MemoryControl;

public class IODispatcher
extends Thread {
    private static final ConcurrentLog log = new ConcurrentLog("KELONDRO IODispatcher");
    private Semaphore controlQueue;
    private final Semaphore termination = new Semaphore(0);
    private ArrayBlockingQueue<MergeJob> mergeQueue;
    private ArrayBlockingQueue<DumpJob<? extends Reference>> dumpQueue;
    private boolean terminate;
    private final int writeBufferSize;

    public IODispatcher(int dumpQueueLength, int mergeQueueLength, int writeBufferSize) {
        super("IODispatcher");
        this.controlQueue = new Semaphore(0);
        this.dumpQueue = new ArrayBlockingQueue(dumpQueueLength);
        this.mergeQueue = new ArrayBlockingQueue(mergeQueueLength);
        this.writeBufferSize = writeBufferSize;
        this.terminate = false;
    }

    public void terminate() {
        this.terminate = true;
        if (this.termination != null && this.controlQueue != null && this.isAlive()) {
            this.controlQueue.release();
            try {
                this.termination.acquire();
            }
            catch (InterruptedException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void dump(ReferenceContainerCache<? extends Reference> cache, File file, ReferenceContainerArray<? extends Reference> array) {
        if (this.dumpQueue == null || this.controlQueue == null || !this.isAlive()) {
            log.warn("emergency dump of file " + file.getName());
            if (!cache.isEmpty()) {
                cache.dump(file, (int)Math.min(MemoryControl.available() / 3L, (long)this.writeBufferSize), true);
            }
        } else {
            DumpJob<? extends Reference> job = new DumpJob<Reference>(cache, file, array);
            if (this.isAlive()) {
                try {
                    this.dumpQueue.add(job);
                    log.info("appended dump job for file " + file.getName());
                }
                catch (IllegalStateException e) {
                    log.warn("could not append dump job, emergency dump of file " + file.getName());
                    cache.dump(file, (int)Math.min(MemoryControl.available() / 3L, (long)this.writeBufferSize), true);
                }
                finally {
                    this.controlQueue.release();
                }
            } else {
                job.dump();
                log.warn("dispatcher is not alive, just dumped file " + file.getName());
            }
        }
    }

    protected synchronized int queueLength() {
        return this.controlQueue == null || !this.isAlive() ? 0 : this.controlQueue.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void merge(File f1, File f2, ReferenceFactory<? extends Reference> factory, ArrayStack array, File newFile) {
        if (this.mergeQueue == null || this.controlQueue == null || !this.isAlive()) {
            if (f2 == null) {
                log.warn("emergency rewrite of file " + f1.getName() + " to " + newFile.getName());
            } else {
                log.warn("emergency merge of files " + f1.getName() + ", " + f2.getName() + " to " + newFile.getName());
            }
            array.mergeMount(f1, f2, factory, newFile, (int)Math.min(MemoryControl.available() / 3L, (long)this.writeBufferSize));
        } else {
            MergeJob job = new MergeJob(f1, f2, factory, array, newFile);
            if (this.isAlive()) {
                try {
                    this.mergeQueue.add(job);
                    if (f2 == null) {
                        log.info("appended rewrite job of file " + f1.getName() + " to " + newFile.getName());
                    }
                    log.info("appended merge job of files " + f1.getName() + ", " + f2.getName() + " to " + newFile.getName());
                }
                catch (IllegalStateException e) {
                    log.warn("Could not add merge job to queue: " + e.getMessage());
                }
                finally {
                    this.controlQueue.release();
                }
            } else {
                job.merge();
                if (f2 == null) {
                    log.warn("dispatcher not running, merged files " + f1.getName() + " to " + newFile.getName());
                } else {
                    log.warn("dispatcher not running, rewrote file " + f1.getName() + ", " + f2.getName() + " to " + newFile.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 13 sources

                    {
                        this.controlQueue.acquire();
                        if (!this.dumpQueue.isEmpty()) {
                            f = null;
                            try {
                                dumpJob = this.dumpQueue.take();
                                f = dumpJob.file;
                                dumpJob.dump();
                            }
                            catch (InterruptedException e) {
                                IODispatcher.log.severe("main run job was interrupted (1)", e);
                            }
                            catch (Throwable e) {
                                IODispatcher.log.severe("main run job had errors (1), dump to " + String.valueOf(f) + " failed.", e);
                            }
                            finally {
                                if (!this.terminate) ** GOTO lbl-1000
                                this.controlQueue.release();
                            }
                            continue;
                        }
                        if (!this.mergeQueue.isEmpty() && !MemoryControl.shortStatus()) {
                            f = null;
                            f1 = null;
                            f2 = null;
                            try {
                                mergeJob = this.mergeQueue.take();
                                f = mergeJob.newFile;
                                f1 = mergeJob.f1;
                                f2 = mergeJob.f2;
                                mergeJob.merge();
                            }
                            catch (InterruptedException e) {
                                IODispatcher.log.severe("main run job was interrupted (2)", e);
                            }
                            catch (Throwable e) {
                                if (f2 == null) {
                                    IODispatcher.log.severe("main run job had errors (2), dump to " + String.valueOf(f) + " failed. Input file is " + String.valueOf(f1), e);
                                }
                                IODispatcher.log.severe("main run job had errors (2), dump to " + String.valueOf(f) + " failed. Input files are " + String.valueOf(f1) + " and " + String.valueOf(f2), e);
                            }
                            finally {
                                if (!this.terminate) ** GOTO lbl-1000
                                this.controlQueue.release();
                            }
                            continue;
                        }
                        if (this.terminate) break;
                    }
                    IODispatcher.log.info("caught termination signal");
                }
                catch (Throwable e) {
                    IODispatcher.log.severe("main run job failed (X)", e);
                    continue;
                }
                break;
            }
            IODispatcher.log.info("loop terminated");
        }
        catch (Throwable e) {
            IODispatcher.log.severe("main run job failed (4)", e);
        }
        finally {
            IODispatcher.log.info("terminating run job");
            this.controlQueue = null;
            this.dumpQueue = null;
            this.mergeQueue = null;
            this.termination.release();
        }
    }

    private class DumpJob<ReferenceType extends Reference> {
        private final ReferenceContainerCache<ReferenceType> cache;
        private final File file;
        private final ReferenceContainerArray<ReferenceType> array;

        private DumpJob(ReferenceContainerCache<ReferenceType> cache, File file, ReferenceContainerArray<ReferenceType> array) {
            this.cache = cache;
            this.file = file;
            this.array = array;
        }

        private void dump() {
            try {
                if (!this.cache.isEmpty()) {
                    this.cache.dump(this.file, (int)Math.min(MemoryControl.available() / 3L, (long)IODispatcher.this.writeBufferSize), true);
                }
                this.array.mountBLOBFile(this.file);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
    }

    private class MergeJob {
        private final File f1;
        private final File f2;
        private final File newFile;
        private final ArrayStack array;
        private final ReferenceFactory<? extends Reference> factory;

        private MergeJob(File f1, File f2, ReferenceFactory<? extends Reference> factory, ArrayStack array, File newFile) {
            this.f1 = f1;
            this.f2 = f2;
            this.factory = factory;
            this.newFile = newFile;
            this.array = array;
        }

        private File merge() {
            if (!this.f1.exists()) {
                log.warn("merge of file (1) " + this.f1.getName() + " failed: file does not exists");
                return null;
            }
            if (this.f2 != null && !this.f2.exists()) {
                log.warn("merge of file (2) " + this.f2.getName() + " failed: file does not exists");
                return null;
            }
            return this.array.mergeMount(this.f1, this.f2, this.factory, this.newFile, (int)Math.min(MemoryControl.available() / 3L, (long)IODispatcher.this.writeBufferSize));
        }
    }
}

