/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ByteBuffer;

public class MapColumnIndex
implements Serializable {
    private static final long serialVersionUID = -424741536889467566L;
    private final Map<String, Map<String, Collection<byte[]>>> index = new HashMap<String, Map<String, Collection<byte[]>>>();

    public synchronized Collection<byte[]> getIndex(String whereKey, String isValue) throws UnsupportedOperationException {
        Map<String, Collection<byte[]>> references = this.index.get(whereKey);
        if (references == null) {
            throw new UnsupportedOperationException();
        }
        Collection<byte[]> indexes = references.get(isValue);
        if (indexes == null) {
            return new ArrayList<byte[]>(0);
        }
        return indexes;
    }

    public synchronized void clear() {
        this.index.clear();
    }

    public synchronized void init(String whereKey, String isValue, Iterator<Map.Entry<byte[], Map<String, String>>> table) {
        HashMap<String, Collection<byte[]>> valueIdxMap = new HashMap<String, Collection<byte[]>>();
        this.index.put(whereKey, valueIdxMap);
        while (table.hasNext()) {
            Map.Entry<byte[], Map<String, String>> line = table.next();
            String value = line.getValue().get(whereKey);
            if (value == null) continue;
            MapColumnIndex.indexupdate(line.getKey(), valueIdxMap, value.toLowerCase());
        }
    }

    public synchronized void update(byte[] primarykey, Map<String, String> row) {
        for (Map.Entry<String, Map<String, Collection<byte[]>>> entry2 : this.index.entrySet()) {
            String value = row.get(entry2.getKey());
            if (value == null) continue;
            MapColumnIndex.indexupdate(primarykey, entry2.getValue(), value);
        }
    }

    private static void indexupdate(byte[] primarykey, Map<String, Collection<byte[]>> valueIdxMap, String value) {
        Collection<byte[]> indexes = valueIdxMap.get(value);
        if (indexes == null) {
            indexes = new ArrayList<byte[]>(1);
            indexes.add(primarykey);
            valueIdxMap.put(value, indexes);
        } else if (!ByteBuffer.contains(indexes, primarykey)) {
            indexes.add(primarykey);
        }
    }

    public synchronized void delete(byte[] primarykey) {
        for (Map.Entry<String, Map<String, Collection<byte[]>>> entry2 : this.index.entrySet()) {
            MapColumnIndex.indexdelete(primarykey, entry2.getValue());
        }
    }

    private static void indexdelete(byte[] index2, Map<String, Collection<byte[]>> valueIdxMap) {
        Iterator<Map.Entry<String, Collection<byte[]>>> i = valueIdxMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Collection<byte[]>> ref = i.next();
            ByteBuffer.remove(ref.getValue(), index2);
            if (!ref.getValue().isEmpty()) continue;
            i.remove();
        }
    }

    private static Collection<byte[]> getIndexWithExceptionHandler(MapColumnIndex idx2, String whereKey, String isValue, Map<byte[], Map<String, String>> table) {
        try {
            return idx2.getIndex(whereKey, isValue);
        }
        catch (UnsupportedOperationException e) {
            idx2.init(whereKey, isValue, table.entrySet().iterator());
            return idx2.getIndex(whereKey, isValue);
        }
    }

    private static void printIndex(Collection<byte[]> index2) {
        System.out.print("idx{");
        int c = 0;
        for (byte[] a : index2) {
            if (c++ != 0) {
                System.out.print(", ");
            }
            System.out.print(ASCII.String(a));
        }
        System.out.print("}");
    }

    public static void main(String[] args) {
        TreeMap<byte[], Map<String, String>> table = new TreeMap<byte[], Map<String, String>>(NaturalOrder.naturalOrder);
        HashMap<String, String> row = new HashMap<String, String>();
        row.put("a", "1");
        row.put("b", "2");
        row.put("c", "2");
        table.put("line1".getBytes(), row);
        row = new HashMap();
        row.put("a", "3");
        row.put("b", "2");
        row.put("c", "4");
        table.put("line2".getBytes(), row);
        row = new HashMap();
        row.put("a", "5");
        row.put("b", "2");
        row.put("c", "4");
        table.put("line3".getBytes(), row);
        row = new HashMap();
        row.put("a", "6");
        row.put("b", "7");
        row.put("c", "8");
        table.put("line4".getBytes(), row);
        MapColumnIndex idx2 = new MapColumnIndex();
        System.out.print("colum b, value 2: ");
        MapColumnIndex.printIndex(MapColumnIndex.getIndexWithExceptionHandler(idx2, "b", "2", table));
        System.out.println();
        System.out.print("colum c, value 4: ");
        MapColumnIndex.printIndex(MapColumnIndex.getIndexWithExceptionHandler(idx2, "c", "4", table));
        System.out.println();
        System.out.print("colum b, value 2: ");
        MapColumnIndex.printIndex(MapColumnIndex.getIndexWithExceptionHandler(idx2, "b", "7", table));
        System.out.println();
        System.out.print("colum d, value 0: ");
        MapColumnIndex.printIndex(MapColumnIndex.getIndexWithExceptionHandler(idx2, "d", "0", table));
        System.out.println();
        row = new HashMap();
        row.put("a", "9");
        row.put("b", "9");
        row.put("c", "4");
        table.put("line5".getBytes(), row);
        idx2.update("line5".getBytes(), row);
        System.out.print("colum c, value 4: ");
        MapColumnIndex.printIndex(MapColumnIndex.getIndexWithExceptionHandler(idx2, "c", "4", table));
        System.out.println();
    }
}

