/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.io.IOException;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.NoticedURL;
import net.yacy.crawler.retrieval.Request;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.peers.Protocol;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class urls {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("iam", sb.peers.mySeed().hash);
        prop.put("response", "rejected - insufficient call parameters");
        prop.put("channel_title", "");
        prop.put("channel_description", "");
        prop.put("channel_pubDate", "");
        prop.put("item", "0");
        if (post == null || env == null) {
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            return prop;
        }
        if (post.get("call", "").equals("remotecrawl")) {
            NoticedURL.StackType stackType = NoticedURL.StackType.GLOBAL;
            long maxTime = Math.min(20000, Math.max(1000, post.getInt("time", 10000)));
            long timeout = System.currentTimeMillis() + maxTime;
            int c = 0;
            for (int maxCount = Math.min(100, post.getInt("count", 10)); maxCount > 0 && System.currentTimeMillis() < timeout && !sb.crawlQueues.noticeURL.isEmpty(stackType); --maxCount) {
                String referrerURL;
                Request entry2;
                try {
                    entry2 = sb.crawlQueues.noticeURL.pop(stackType, false, sb.crawler, sb.robots);
                }
                catch (IOException e) {
                    break;
                }
                if (entry2 == null) break;
                try {
                    referrerURL = sb.getURL(entry2.referrerhash());
                }
                catch (IOException e) {
                    referrerURL = null;
                    ConcurrentLog.logException(e);
                }
                if (sb.crawlQueues.delegatedURL != null) {
                    sb.crawlQueues.delegatedURL.put(ASCII.String(entry2.url().hash()), entry2.url());
                }
                prop.put("item_" + c + "_title", "");
                prop.putXML("item_" + c + "_link", entry2.url().toNormalform(true));
                prop.putXML("item_" + c + "_referrer", referrerURL == null ? "" : referrerURL);
                prop.putXML("item_" + c + "_description", entry2.name());
                prop.put("item_" + c + "_author", "");
                prop.put("item_" + c + "_pubDate", GenericFormatter.SHORT_SECOND_FORMATTER.format(entry2.appdate()));
                prop.put("item_" + c + "_guid", entry2.url().hash());
                ++c;
            }
            prop.put("item", c);
            prop.putXML("response", "ok");
        }
        if (post.get("call", "").equals("urlhashlist")) {
            String urlhashes = post.get("hashes", "");
            if (urlhashes.length() % 12 != 0) {
                return prop;
            }
            int count = urlhashes.length() / 12;
            int c = 0;
            for (int i = 0; i < count; ++i) {
                URIMetadataNode entry3 = sb.index.fulltext().getMetadata(ASCII.getBytes(urlhashes.substring(12 * i, 12 * (i + 1))));
                if (entry3 == null) continue;
                try {
                    String referrerURL = sb.getURL(entry3.referrerHash());
                    prop.put("item_" + c + "_title", entry3.dc_title());
                    prop.putXML("item_" + c + "_link", entry3.url().toNormalform(true));
                    prop.putXML("item_" + c + "_referrer", referrerURL == null ? "" : referrerURL);
                    prop.putXML("item_" + c + "_description", entry3.dc_title());
                    prop.put("item_" + c + "_author", entry3.dc_creator());
                    prop.put("item_" + c + "_pubDate", GenericFormatter.SHORT_SECOND_FORMATTER.format(entry3.moddate()));
                    prop.put("item_" + c + "_guid", ASCII.String(entry3.hash()));
                    ++c;
                    continue;
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
            prop.put("item", c);
            prop.putXML("response", "ok");
        }
        return prop;
    }
}

