/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ProxyIndexingMonitor_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        boolean yacyonly;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("info", "0");
        prop.put("info_message", "");
        if (post != null && post.containsKey("proxyprofileset")) {
            try {
                boolean proxyYaCyOnly = post.containsKey("proxyYacyOnly");
                env.setConfig("proxyYacyOnly", proxyYaCyOnly);
                int newProxyPrefetchDepth = post.getInt("proxyPrefetchDepth", 0);
                if (newProxyPrefetchDepth < 0) {
                    newProxyPrefetchDepth = 0;
                }
                if (newProxyPrefetchDepth > 20) {
                    newProxyPrefetchDepth = 20;
                }
                env.setConfig("proxyPrefetchDepth", Integer.toString(newProxyPrefetchDepth));
                boolean proxyStoreHTCache = post.containsKey("proxyStoreHTCache");
                env.setConfig("proxyStoreHTCache", proxyStoreHTCache);
                boolean proxyIndexingRemote = post.containsKey("proxyIndexingRemote");
                env.setConfig("proxyIndexingRemote", proxyIndexingRemote);
                boolean proxyIndexingLocalText = post.containsKey("proxyIndexingLocalText");
                env.setConfig("proxyIndexingLocalText", proxyIndexingLocalText);
                boolean proxyIndexingLocalMedia = post.containsKey("proxyIndexingLocalMedia");
                env.setConfig("proxyIndexingLocalMedia", proxyIndexingLocalMedia);
                String oldProxyCachePath = env.getConfig("proxyCache", "DATA/HTCACHE");
                String newProxyCachePath = post.get("proxyCache", "DATA/HTCACHE");
                newProxyCachePath = newProxyCachePath.replace('\\', '/');
                if (newProxyCachePath.endsWith("/")) {
                    newProxyCachePath = newProxyCachePath.substring(0, newProxyCachePath.length() - 1);
                }
                env.setConfig("proxyCache", newProxyCachePath);
                File cache = env.getDataPath("proxyCache", oldProxyCachePath);
                if (!cache.isDirectory() && !cache.isFile()) {
                    cache.mkdirs();
                }
                long oldProxyCacheSize = env.getConfigLong("proxyCacheSize", 64L);
                long newProxyCacheSize = post.getLong("proxyCacheSize", 64L);
                if (newProxyCacheSize < 4L) {
                    newProxyCacheSize = 4L;
                }
                env.setConfig("proxyCacheSize", newProxyCacheSize);
                Cache.setMaxCacheSize(newProxyCacheSize * 1024L * 1024L);
                if (sb.crawler.defaultProxyProfile == null) {
                    prop.put("info", "1");
                } else {
                    assert (sb.crawler.defaultProxyProfile.handle() != null);
                    sb.crawler.defaultProxyProfile.put("generalDepth", Integer.toString(newProxyPrefetchDepth));
                    sb.crawler.defaultProxyProfile.put("storeHTCache", proxyStoreHTCache);
                    sb.crawler.defaultProxyProfile.put("remoteIndexing", proxyIndexingRemote);
                    sb.crawler.defaultProxyProfile.put("indexText", proxyIndexingLocalText);
                    sb.crawler.defaultProxyProfile.put("indexMedia", proxyIndexingLocalMedia);
                    sb.crawler.putActive(sb.crawler.defaultProxyProfile.handle().getBytes(), sb.crawler.defaultProxyProfile);
                    prop.put("info", "2");
                    prop.put("info_message", newProxyPrefetchDepth);
                    prop.put("info_caching", proxyStoreHTCache ? "1" : "0");
                    prop.put("info_indexingLocalText", proxyIndexingLocalText ? "1" : "0");
                    prop.put("info_indexingLocalMedia", proxyIndexingLocalMedia ? "1" : "0");
                    prop.put("info_indexingRemote", proxyIndexingRemote ? "1" : "0");
                    if (oldProxyCachePath.equals(newProxyCachePath)) {
                        prop.put("info_path", "0");
                        prop.putHTML("info_path_return", oldProxyCachePath);
                    } else {
                        prop.put("info_path", "1");
                        prop.putHTML("info_path_return", newProxyCachePath);
                    }
                    if (oldProxyCacheSize == newProxyCacheSize) {
                        prop.put("info_size", "0");
                        prop.put("info_size_return", oldProxyCacheSize);
                    } else {
                        prop.put("info_size", "1");
                        prop.put("info_size_return", newProxyCacheSize);
                    }
                    prop.put("info_restart", "0");
                    prop.put("info_restart_return", "0");
                    if (!oldProxyCachePath.equals(newProxyCachePath)) {
                        prop.put("info_restart", "1");
                    }
                }
            }
            catch (Exception e) {
                prop.put("info", "2");
                prop.putHTML("info_error", e.getMessage());
                ConcurrentLog.severe("SERVLET", "ProxyIndexingMonitor.case3", e);
            }
        }
        prop.put("proxyYacyOnly", (yacyonly = env.getConfigBool("proxyYacyOnly", false)) ? "1" : "0");
        prop.put("proxyPrefetchDepth", env.getConfigLong("proxyPrefetchDepth", 0L));
        prop.put("proxyStoreHTCacheChecked", env.getConfigBool("proxyStoreHTCache", false) ? "1" : "0");
        prop.put("proxyIndexingRemote", env.getConfigBool("proxyIndexingRemote", false) ? "1" : "0");
        prop.put("proxyIndexingLocalText", env.getConfigBool("proxyIndexingLocalText", false) ? "1" : "0");
        prop.put("proxyIndexingLocalMedia", env.getConfigBool("proxyIndexingLocalMedia", false) ? "1" : "0");
        prop.put("proxyCache", env.getConfig("proxyCache", "DATA/HTCACHE"));
        prop.put("proxyCacheSize", env.getConfigLong("proxyCacheSize", 64L));
        return prop;
    }
}

