/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.http.servlets.YaCyDefaultServlet;
import net.yacy.peers.NewsDB;
import net.yacy.peers.Seed;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class News {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        int tableID;
        boolean overview;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        boolean bl = overview = post == null || "0".equals(post.get("page", "0"));
        int n = overview ? -1 : (tableID = (post == null ? 0 : post.getInt("page", 0)) - 1);
        if (post != null) {
            if (post.containsKey("deletespecific") && tableID >= 0) {
                if (sb.adminAuthenticated(header) < 2) {
                    prop.authenticationRequired();
                    return prop;
                }
                for (String check : post.keySet()) {
                    if (!check.startsWith("del_") || !"on".equals(post.get(check, "off"))) continue;
                    String id = check.substring(4);
                    try {
                        sb.peers.newsPool.moveOff(tableID, id);
                    }
                    catch (Exception ee) {
                        ConcurrentLog.logException(ee);
                    }
                }
            }
            if (post.containsKey("deleteall") && tableID >= 0) {
                if (sb.adminAuthenticated(header) < 2) {
                    prop.authenticationRequired();
                    return prop;
                }
                try {
                    if (tableID == 1 || tableID == 3) {
                        sb.peers.newsPool.clear(tableID);
                    } else {
                        sb.peers.newsPool.moveOffAll(tableID);
                    }
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (overview) {
            prop.put("table", "0");
            prop.put("page", "0");
            prop.putNum("table_insize", sb.peers.newsPool.size(0));
            prop.putNum("table_prsize", sb.peers.newsPool.size(1));
            prop.putNum("table_ousize", sb.peers.newsPool.size(2));
            prop.putNum("table_pusize", sb.peers.newsPool.size(3));
        } else {
            prop.put("table", "1");
            prop.put("page", tableID + 1);
            prop.put("table_page", tableID + 1);
            if (sb.peers != null) {
                int maxCount = Math.min(1000, sb.peers.newsPool.size(tableID));
                Iterator<NewsDB.Record> recordIterator = sb.peers.newsPool.recordIterator(tableID);
                int i = 0;
                while (recordIterator.hasNext() && i < maxCount) {
                    Set<String> ips;
                    Object description;
                    Object title;
                    Object link;
                    NewsDB.Record record = recordIterator.next();
                    if (record == null) continue;
                    Seed seed = sb.peers.getConnected(record.originator());
                    if (seed == null) {
                        seed = sb.peers.getDisconnected(record.originator());
                    }
                    String category = record.category();
                    prop.put("table_list_" + i + "_id", record.id());
                    prop.putHTML("table_list_" + i + "_ori", seed == null ? record.originator() : seed.getName());
                    prop.put("table_list_" + i + "_cre", GenericFormatter.SHORT_SECOND_FORMATTER.format(record.created()));
                    prop.put("table_list_" + i + "_crerfcdate", HeaderFramework.formatRFC1123(record.created()));
                    prop.putHTML("table_list_" + i + "_cat", category);
                    prop.put("table_list_" + i + "_rec", record.received() == null ? "-" : GenericFormatter.SHORT_SECOND_FORMATTER.format(record.received()));
                    prop.put("table_list_" + i + "_dis", record.distributed());
                    Map<String, String> attributeMap = record.attributes();
                    prop.putHTML("table_list_" + i + "_att", attributeMap.toString());
                    int j = 0;
                    if (!attributeMap.isEmpty()) {
                        for (Map.Entry<String, String> attribute : attributeMap.entrySet()) {
                            prop.put("table_list_" + i + "_attributes_" + j + "_name", attribute.getKey());
                            prop.putHTML("table_list_" + i + "_attributes_" + j + "_value", attribute.getValue());
                            ++j;
                        }
                    }
                    prop.put("table_list_" + i + "_attributes", j);
                    if (category.equals("crwlstrt")) {
                        link = record.attribute("startURL", "");
                        title = record.attribute("intention", "").isEmpty() ? link : record.attribute("intention", "");
                        description = "Crawl Start Point";
                    } else if (category.equals("prfleupd")) {
                        link = record.attribute("homepage", "");
                        title = "Home Page of " + record.attribute("nickname", "");
                        description = "Profile Update";
                    } else if (category.equals("bkmrkadd")) {
                        link = record.attribute("url", "");
                        title = record.attribute("title", "");
                        description = "Bookmark: " + record.attribute("description", "");
                    } else if (category.equals("stippadd")) {
                        link = record.attribute("url", "");
                        title = record.attribute("title", "");
                        description = "Surf Tipp: " + record.attribute("description", "");
                    } else if (category.equals("stippavt")) {
                        link = record.attribute("url", "");
                        title = record.attribute("title", "");
                        description = record.attribute("url", "");
                    } else if (category.equals("wiki_upd")) {
                        link = seed == null ? "" : (!(ips = seed.getIPs()).isEmpty() ? "http://" + seed.getPublicAddress(ips.iterator().next()) + "/Wiki.html?page=" + record.attribute("page", "") : "");
                        title = record.attribute("author", "Anonymous") + ": " + record.attribute("page", "");
                        description = "Wiki Update: " + record.attribute("description", "");
                    } else if (category.equals("blog_add")) {
                        link = seed == null ? "" : (!(ips = seed.getIPs()).isEmpty() ? "http://" + seed.getPublicAddress(ips.iterator().next()) + "/Blog.html?page=" + record.attribute("page", "") : "");
                        title = record.attribute("author", "Anonymous") + ": " + record.attribute("page", "");
                        description = "Blog Entry: " + record.attribute("subject", "");
                    } else {
                        link = "";
                        title = "";
                        description = "";
                    }
                    prop.putHTML("table_list_" + i + "_link", (String)link);
                    prop.putHTML("table_list_" + i + "_title", (String)title);
                    prop.putHTML("table_list_" + i + "_description", (String)description);
                    ++i;
                }
                prop.put("table_list", i);
            }
        }
        prop.put("context", YaCyDefaultServlet.getContext(header, sb));
        return prop;
    }
}

