/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.images;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.lang.GeoLocation;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.GpsDirectory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.document.AbstractParser;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.VocabularyScraper;

public class metadataImageParser
extends AbstractParser
implements Parser {
    public metadataImageParser() {
        super("Metadata Image Parser");
        this.SUPPORTED_EXTENSIONS.add("tif");
        this.SUPPORTED_EXTENSIONS.add("psd");
        this.SUPPORTED_MIME_TYPES.add("image/tiff");
        this.SUPPORTED_MIME_TYPES.add("image/vnd.adobe.photoshop");
        this.SUPPORTED_MIME_TYPES.add("image/x-photoshop");
    }

    @Override
    public Document[] parse(DigestURL location, String mimeType, String charset, VocabularyScraper scraper, int timezoneOffset, InputStream source) throws Parser.Failure, InterruptedException {
        String title = null;
        String author = null;
        String keywords = null;
        ArrayList<String> descriptions = new ArrayList<String>();
        double gpslat = 0.0;
        double gpslon = 0.0;
        StringBuilder imgInfotxt = new StringBuilder();
        try {
            String description;
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)new BufferedInputStream(source));
            Iterator directories = metadata.getDirectories().iterator();
            HashMap<String, String> props = new HashMap<String, String>();
            while (directories.hasNext()) {
                Directory directory = (Directory)directories.next();
                if (directory instanceof GpsDirectory) {
                    GeoLocation geoloc = ((GpsDirectory)directory).getGeoLocation();
                    if (geoloc == null) continue;
                    gpslat = geoloc.getLatitude();
                    gpslon = geoloc.getLongitude();
                    continue;
                }
                for (Tag tag : directory.getTags()) {
                    if (tag.getTagName().startsWith("Unknown")) continue;
                    props.put(tag.getTagName(), tag.getDescription());
                    imgInfotxt.append(tag.getTagName() + ": " + tag.getDescription() + " .\n");
                }
            }
            title = (String)props.get("Image Description");
            if (title == null || title.isEmpty()) {
                title = (String)props.get("Headline");
            }
            if (title == null || title.isEmpty()) {
                title = (String)props.get("Object Name");
            }
            if ((author = (String)props.get("Artist")) == null || author.isEmpty()) {
                author = (String)props.get("Writer/Editor");
            }
            if (author == null || author.isEmpty()) {
                author = (String)props.get("By-line");
            }
            if (author == null || author.isEmpty()) {
                author = (String)props.get("Credit");
            }
            if (author == null || author.isEmpty()) {
                author = (String)props.get("Make");
            }
            if ((keywords = (String)props.get("Keywords")) == null || keywords.isEmpty()) {
                keywords = (String)props.get("Category");
            }
            if (keywords == null || keywords.isEmpty()) {
                keywords = (String)props.get("Supplemental Category(s)");
            }
            if ((description = (String)props.get("Caption/Abstract")) != null && description.length() > 0) {
                descriptions.add("Abstract: " + description);
            }
            if ((description = (String)props.get("Country/Primary Location")) != null && description.length() > 0) {
                descriptions.add("Location: " + description);
            }
            if ((description = (String)props.get("Province/State")) != null && description.length() > 0) {
                descriptions.add("State: " + description);
            }
            if ((description = (String)props.get("Copyright Notice")) != null && description.length() > 0) {
                descriptions.add("Copyright: " + description);
            }
        }
        catch (ImageProcessingException e) {
            throw new Parser.Failure("could not extract image meta data", location);
        }
        catch (IOException ex) {
            throw new Parser.Failure("IO-Error reading", location);
        }
        if (title == null || title.isEmpty()) {
            title = MultiProtocolURL.unescape(location.getFileName());
        }
        return new Document[]{new Document(location, mimeType, charset, this, new HashSet<String>(0), keywords == null ? new String[]{} : keywords.split(keywords.indexOf(44) > 0 ? "," : " "), metadataImageParser.singleList(title), author == null ? null : author, location.getHost(), null, descriptions, gpslon, gpslat, imgInfotxt.toString(), null, null, null, false, new Date())};
    }
}

