/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.images;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.yacy.cora.util.ConcurrentLog;

@Deprecated
public class bmpParser {
    private static int FILEHEADER_offset = 0;
    private static int INFOHEADER_offset = 14;
    public static int INFOHEADER_size = 40;
    static int BI_RGB = 0;

    public static final boolean isBMP(byte[] source) {
        return source != null && source.length >= 2 && source[0] == 66 && source[1] == 77;
    }

    public static IMAGEMAP parse(byte[] source) {
        int bfOffBits = bmpParser.DWORD(source, FILEHEADER_offset + 10);
        INFOHEADER infoheader = new INFOHEADER(source, INFOHEADER_offset);
        COLORTABLE colortable = new COLORTABLE(source, INFOHEADER_offset + INFOHEADER_size, infoheader);
        assert (bfOffBits == INFOHEADER_offset + 40 + colortable.colorbytes) : "bfOffBits = " + bfOffBits + ", colorbytes = " + colortable.colorbytes;
        assert (infoheader.biSizeImage <= source.length - bfOffBits) : "bfOffBits = " + bfOffBits + ", biSizeImage = " + infoheader.biSizeImage + ", source.length = " + source.length;
        return new IMAGEMAP(source, bfOffBits, infoheader.biWidth, infoheader.biHeight, infoheader.biCompression, infoheader.biBitCount, colortable);
    }

    public static final int DWORD(byte[] b, int offset) {
        if (offset + 3 >= b.length) {
            return 0;
        }
        int ret = b[offset + 3] & 0xFF;
        ret = ret << 8 | b[offset + 2] & 0xFF;
        ret = ret << 8 | b[offset + 1] & 0xFF;
        ret = ret << 8 | b[offset] & 0xFF;
        return ret;
    }

    public static final int WORD(byte[] b, int offset) {
        int ret = (b[offset + 1] & 0xFF) << 8 | b[offset] & 0xFF;
        return ret;
    }

    public static final int BYTE(byte[] b, int offset) {
        int ret = b[offset] & 0xFF;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        System.setProperty("java.awt.headless", "true");
        File in = new File(args[0]);
        File out = new File(args[1]);
        byte[] file = new byte[(int)in.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(in);
            fis.read(file);
        }
        catch (FileNotFoundException e) {
            ConcurrentLog.logException(e);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    ConcurrentLog.logException(ioe);
                }
            }
        }
        try {
            ImageIO.write((RenderedImage)bmpParser.parse(file).getImage(), "PNG", out);
        }
        catch (IOException e) {
            ConcurrentLog.logException(e);
        }
    }

    public static class INFOHEADER {
        public int biWidth;
        public int biHeight;
        public int biBitCount;
        public int biCompression;
        public int biSizeImage;
        public int biClrUsed;

        public INFOHEADER(byte[] s, int offset) {
            this.biWidth = bmpParser.DWORD(s, offset + 4);
            this.biHeight = bmpParser.DWORD(s, offset + 8);
            this.biBitCount = bmpParser.WORD(s, offset + 14);
            this.biCompression = bmpParser.WORD(s, offset + 16);
            this.biSizeImage = bmpParser.DWORD(s, offset + 20);
            this.biClrUsed = bmpParser.DWORD(s, offset + 32);
        }
    }

    public static class COLORTABLE {
        public int colorbytes = 0;
        public int[] colorindex;

        public COLORTABLE(byte[] s, int offset, INFOHEADER infoheader) {
            if (infoheader.biClrUsed == 0 || infoheader.biClrUsed > 1024) {
                if (infoheader.biBitCount == 1 || infoheader.biBitCount == 4 || infoheader.biBitCount == 8) {
                    this.colorindex = new int[1 << infoheader.biBitCount];
                    this.colorbytes = 4 * this.colorindex.length;
                    for (int i = 0; i < this.colorindex.length; ++i) {
                        int color;
                        this.colorindex[i] = color = 0xFFFFFF & bmpParser.DWORD(s, offset + 4 * i);
                    }
                } else {
                    this.colorindex = null;
                }
            } else {
                this.colorindex = new int[infoheader.biClrUsed];
                this.colorbytes = 4 * this.colorindex.length;
                for (int i = 0; i < this.colorindex.length; ++i) {
                    int color;
                    this.colorindex[i] = color = 0xFFFFFF & bmpParser.DWORD(s, offset + 4 * i);
                }
            }
        }
    }

    public static class IMAGEMAP {
        private BufferedImage image;

        public IMAGEMAP(byte[] s, int offset, int width, int height, int compression, int bitcount, COLORTABLE colortable) {
            if (width != 0 && height != 0) {
                this.image = new BufferedImage(width, height, 1);
                if (compression == BI_RGB) {
                    if (bitcount == 1) {
                        this.parseBMP1(s, offset, width, height, colortable);
                    } else if (bitcount == 4) {
                        this.parseBMP4(s, offset, width, height, colortable);
                    } else if (bitcount == 8) {
                        this.parseBMP8(s, offset, width, height, colortable);
                    } else if (bitcount == 24) {
                        this.parseBMP24(s, offset, width, height);
                    } else if (bitcount == 32) {
                        this.parseBMP32(s, offset, width, height);
                    } else {
                        ConcurrentLog.fine("IMAGEPARSER", "unsupported BMP format: biCompression = " + compression + ", biBitCount = " + bitcount);
                    }
                } else {
                    ConcurrentLog.fine("IMAGEPARSER", "unsupported BMP format: biCompression = " + compression + ", biBitCount = " + bitcount);
                }
            }
        }

        private void parseBMP1(byte[] s, int offset, int width, int height, COLORTABLE colortable) {
            int n = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int columns = 0; columns < width; columns += 8) {
                    if (offset + n >= s.length) {
                        return;
                    }
                    int b = s[offset + n] & 0xFF;
                    ++n;
                    this.image.setRGB(columns, height - rows - 1, colortable.colorindex[(b & 0x80) >> 7]);
                    this.image.setRGB(columns + 1, height - rows - 1, colortable.colorindex[(b & 0x40) >> 6]);
                    this.image.setRGB(columns + 2, height - rows - 1, colortable.colorindex[(b & 0x20) >> 5]);
                    this.image.setRGB(columns + 3, height - rows - 1, colortable.colorindex[(b & 0x10) >> 4]);
                    this.image.setRGB(columns + 4, height - rows - 1, colortable.colorindex[(b & 8) >> 3]);
                    this.image.setRGB(columns + 5, height - rows - 1, colortable.colorindex[(b & 4) >> 2]);
                    this.image.setRGB(columns + 6, height - rows - 1, colortable.colorindex[(b & 2) >> 1]);
                    this.image.setRGB(columns + 7, height - rows - 1, colortable.colorindex[b & 1]);
                }
                n += IMAGEMAP.fill4(n);
            }
        }

        private void parseBMP4(byte[] s, int offset, int width, int height, COLORTABLE colortable) {
            int n = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int columns = 0; columns < width - 1; columns += 2) {
                    if (offset + n >= s.length) {
                        return;
                    }
                    int b = s[offset + n] & 0xFF;
                    ++n;
                    this.image.setRGB(columns, height - rows - 1, colortable.colorindex[(b & 0xF0) >> 4]);
                    this.image.setRGB(columns + 1, height - rows - 1, colortable.colorindex[b & 0xF]);
                }
                n += IMAGEMAP.fill4(n);
            }
        }

        private void parseBMP8(byte[] s, int offset, int width, int height, COLORTABLE colortable) {
            int n = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int columns = 0; columns < width; ++columns) {
                    if (offset + n >= s.length) {
                        return;
                    }
                    this.image.setRGB(columns, height - rows - 1, colortable.colorindex[s[offset + n] & 0xFF]);
                    ++n;
                }
                n += IMAGEMAP.fill4(n);
            }
        }

        private void parseBMP24(byte[] s, int offset, int width, int height) {
            int n = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int columns = 0; columns < width; ++columns) {
                    if (offset + n + 3 >= s.length) {
                        return;
                    }
                    this.image.setRGB(columns, height - rows - 1, 0xFFFFFF & bmpParser.DWORD(s, offset + n));
                    n += 3;
                }
                n += IMAGEMAP.fill4(n);
            }
        }

        private void parseBMP32(byte[] s, int offset, int width, int height) {
            int n = 0;
            for (int rows = 0; rows < height; ++rows) {
                for (int columns = 0; columns < width; ++columns) {
                    if (offset + n + 3 >= s.length) {
                        return;
                    }
                    this.image.setRGB(columns, height - rows - 1, 0xFFFFFF & bmpParser.DWORD(s, offset + n));
                    n += 4;
                }
            }
        }

        private static final int fill4(int x) {
            int r = x % 4;
            if (r == 0) {
                return 0;
            }
            return 4 - r;
        }

        public BufferedImage getImage() {
            return this.image;
        }
    }
}

