/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.document.parser.html.IconLinkRelations;

public class IconEntry {
    public static final Pattern SIZE_PATTERN = Pattern.compile("([1-9][0-9]*)[xX]([1-9][0-9]*)");
    private final DigestURL url;
    private final Set<String> rel;
    private final Set<Dimension> sizes;

    public IconEntry(DigestURL url, Set<String> rel, Set<Dimension> sizes) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null.");
        }
        if (rel == null || rel.isEmpty()) {
            throw new IllegalArgumentException("rel must be specified");
        }
        this.url = url;
        this.rel = rel;
        this.sizes = sizes != null ? sizes : new HashSet<Dimension>();
    }

    public boolean isStandardIcon() {
        boolean standard = false;
        for (String relation : this.rel) {
            if (!IconLinkRelations.isStandardIconRel(relation)) continue;
            standard = true;
            break;
        }
        return standard;
    }

    public static double getDistance(Dimension size1, Dimension size2) {
        double result = Double.MAX_VALUE;
        if (size1 != null && size2 != null) {
            result = (double)(Math.abs(size1.width - size2.width) + Math.abs(size1.height - size2.height)) / 2.0;
        }
        return result;
    }

    public Dimension getClosestSize(Dimension preferredSize) {
        Dimension closest = null;
        if (preferredSize != null) {
            double closestDistance = Double.MAX_VALUE;
            for (Dimension size : this.sizes) {
                double currentDistance = IconEntry.getDistance(size, preferredSize);
                if (closest == null) {
                    closest = size;
                    closestDistance = currentDistance;
                    continue;
                }
                if (!(currentDistance < closestDistance)) continue;
                closest = size;
                closestDistance = currentDistance;
            }
        }
        return closest;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("<link");
        res.append(" href=\"").append(this.url.toNormalform(false)).append("\"");
        res.append(" rel=\"");
        res.append(this.relToString());
        res.append("\"");
        if (!this.sizes.isEmpty()) {
            res.append(" sizes=\"");
            res.append(this.sizesToString());
            res.append("\"");
        }
        res.append(">");
        return res.toString();
    }

    public DigestURL getUrl() {
        return this.url;
    }

    public Set<String> getRel() {
        return this.rel;
    }

    public Set<Dimension> getSizes() {
        return this.sizes;
    }

    public String sizesToString() {
        StringBuilder builder = new StringBuilder();
        for (Dimension size : this.sizes) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(size.width).append("x").append(size.height);
        }
        return builder.toString();
    }

    public String relToString() {
        StringBuilder builder = new StringBuilder();
        for (String relation : this.rel) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(relation);
        }
        return builder.toString();
    }
}

