/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.document.parser.html;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.sorting.ClusteredScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.util.MemoryControl;

public class Evaluation {
    private static List<Model> models = new ArrayList<Model>();
    private final Map<String, ClusteredScoreMap<String>> modelMap = new HashMap<String, ClusteredScoreMap<String>>();

    public String toString() {
        return this.modelMap.toString();
    }

    public Set<String> getModelNames() {
        return this.modelMap.keySet();
    }

    public ClusteredScoreMap<String> getScores(String modelName) {
        return this.modelMap.get(modelName);
    }

    public static void add(File f) throws IOException {
        Model pattern = new Model(f);
        models.add(pattern);
    }

    public void match(Element element, CharSequence content) {
        if (models.isEmpty()) {
            return;
        }
        for (Model pattern : models) {
            ClusteredScoreMap<String> newScores = pattern.match(element, content);
            ClusteredScoreMap<String> oldScores = this.getScores(pattern.getName());
            if (oldScores == null) {
                oldScores = new ClusteredScoreMap(false);
                this.modelMap.put(pattern.getName(), oldScores);
            }
            oldScores.inc((String)((Object)newScores));
        }
    }

    public void match(Element element, char[] content) {
        if (models.isEmpty()) {
            return;
        }
        if (MemoryControl.request(content.length * 2, false)) {
            this.match(element, new String(content));
        }
    }

    public static void main(String[] args) {
        String t = "// [CDATA[\nvar gaJsH xost = ((\"https:\" == document.location.protocol) ? \"https://ssl.\" : \"http://www.\");\ndocument.write(unescape(\"%3Cscript xsrc='\" + gaJ sHost + \"google-analytics.com/ga.js'\ntype='text/javascript'%3E%3C/script%3E\"));\"\n\"// ]]\"";
        Pattern p = Pattern.compile("(?s).*gaJsHost.*|(?s).*_gat._anonymizeIp.*");
        if (p.matcher(t).matches()) {
            System.out.println("1");
        }
    }

    private static class Model {
        private final String modelName;
        private final Map<Element, List<Attribute>> elementMatcher;

        public Model(File patternProperties) throws IOException {
            if (!patternProperties.exists()) {
                throw new IOException("File does not exist: " + String.valueOf(patternProperties));
            }
            String name = patternProperties.getName();
            if (!name.startsWith("parser.")) {
                throw new IOException("file name must start with 'parser.': " + name);
            }
            if (!name.endsWith(".properties")) {
                throw new IOException("file name must end with '.properties': " + name);
            }
            this.modelName = name.substring(7, name.length() - 11);
            if (this.modelName.length() < 1) {
                throw new IOException("file name too short: " + name);
            }
            Properties p = new Properties();
            p.load(new FileReader(patternProperties));
            this.elementMatcher = new HashMap<Element, List<Attribute>>();
            for (Map.Entry<Object, Object> entry2 : p.entrySet()) {
                Pattern pattern;
                String k = (String)entry2.getKey();
                String v = (String)entry2.getValue();
                int w = k.indexOf(95);
                if (w < 0) {
                    ConcurrentLog.severe("PatternAnalysis", "wrong configuration in " + name + ": separator '_' missing: " + k);
                    continue;
                }
                String subject = k.substring(0, w);
                String elementName = k.substring(w + 1);
                try {
                    pattern = Pattern.compile(v);
                }
                catch (PatternSyntaxException e) {
                    ConcurrentLog.severe("PatternAnalysis", "bad pattern in " + name + ": '" + k + "=" + v + "' - " + e.getDescription());
                    continue;
                }
                Element element = Element.valueOf(elementName);
                if (element == null) {
                    ConcurrentLog.severe("PatternAnalysis", "unknown element in " + name + ": " + elementName);
                    continue;
                }
                List<Attribute> attributeList = this.elementMatcher.get((Object)element);
                if (attributeList == null) {
                    attributeList = new ArrayList<Attribute>();
                    this.elementMatcher.put(element, attributeList);
                }
                attributeList.add(new Attribute(subject, pattern));
            }
        }

        public String getName() {
            return this.modelName;
        }

        public ClusteredScoreMap<String> match(Element element, CharSequence content) {
            ClusteredScoreMap<String> subjects = new ClusteredScoreMap<String>(false);
            List<Attribute> patterns = this.elementMatcher.get((Object)element);
            if (patterns == null) {
                return subjects;
            }
            for (Attribute attribute : patterns) {
                if (!attribute.pattern.matcher(content).matches()) continue;
                subjects.inc(attribute.subject);
            }
            return subjects;
        }

        public String toString() {
            return this.modelName + ":" + this.elementMatcher.toString();
        }
    }

    public static enum Element {
        text,
        title,
        bodyclass,
        divid,
        csspath,
        metagenerator,
        url,
        scriptpath,
        scriptcode,
        framepath,
        iframepath,
        imgpath,
        apath,
        comment;

    }

    private static class Attribute {
        public String subject;
        public Pattern pattern;

        public Attribute(String subject, Pattern pattern) {
            this.subject = subject;
            this.pattern = pattern;
        }

        public String toString() {
            return this.subject + ":" + this.pattern.toString();
        }
    }
}

