/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.data.list;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.yacy.data.list.ListAccumulator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLBlacklistImporter
extends DefaultHandler {
    private ListAccumulator ba = null;
    private String currentListName = null;
    private StringBuilder lastText = null;

    public synchronized ListAccumulator parse(InputSource input) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(this);
        reader.parse(input);
        return this.ba;
    }

    public synchronized ListAccumulator parse(Reader input) throws IOException, SAXException {
        return this.parse(new InputSource(input));
    }

    public synchronized ListAccumulator parse(String input) throws IOException, SAXException {
        return this.parse(new InputSource(input));
    }

    public synchronized ListAccumulator parse(InputStream input) throws IOException, SAXException {
        return this.parse(new InputSource(input));
    }

    @Override
    public void startDocument() {
        this.ba = new ListAccumulator();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equalsIgnoreCase("list")) {
            this.currentListName = attributes.getValue("name");
            this.ba.addList(this.currentListName);
            int attributesLength = 0;
            attributesLength = attributes.getLength();
            if (attributesLength > 1) {
                for (int i = 0; i < attributesLength; ++i) {
                    if (attributes.getQName(i).equals("name")) continue;
                    this.ba.addPropertyToCurrent(attributes.getQName(i), attributes.getValue(i));
                }
            }
        }
        if (qName.equalsIgnoreCase("item")) {
            this.lastText = new StringBuilder();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("item")) {
            this.ba.addEntryToCurrent(this.lastText.toString());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.lastText == null) {
            this.lastText = new StringBuilder();
        }
        this.lastText.append(ch, start, length);
    }
}

