/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.crawler.retrieval;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.ResponseHeader;
import net.yacy.cora.util.NumberTools;
import net.yacy.crawler.data.CrawlProfile;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.crawler.retrieval.Request;
import net.yacy.document.Document;
import net.yacy.document.Parser;
import net.yacy.document.TextParser;
import net.yacy.document.VocabularyScraper;
import net.yacy.document.parser.html.TagValency;
import net.yacy.search.Switchboard;

public class Response {
    public static final char DT_PDFPS = 'p';
    public static final char DT_TEXT = 't';
    public static final char DT_HTML = 'h';
    public static final char DT_DOC = 'd';
    public static final char DT_IMAGE = 'i';
    public static final char DT_MOVIE = 'm';
    public static final char DT_FLASH = 'f';
    public static final char DT_SHARE = 's';
    public static final char DT_AUDIO = 'a';
    public static final char DT_BINARY = 'b';
    public static final char DT_UNKNOWN = 'u';
    private final Request request;
    private final RequestHeader requestHeader;
    private final ResponseHeader responseHeader;
    private final CrawlProfile profile;
    private byte[] content;
    private int status;
    private final boolean fromCache;
    public static final long CRAWLER_MAX_SIZE_TO_CACHE = 0xA00000L;
    public static final int QUEUE_STATE_FRESH = 0;
    public static final int QUEUE_STATE_PARSING = 1;
    public static final int QUEUE_STATE_CONDENSING = 2;
    public static final int QUEUE_STATE_STRUCTUREANALYSIS = 3;
    public static final int QUEUE_STATE_INDEXSTORAGE = 4;
    public static final int QUEUE_STATE_FINISHED = 5;

    public static char docTypeExt(String ext) {
        if (ext == null) {
            return 'u';
        }
        if (ext.equals("gif")) {
            return 'i';
        }
        if (ext.equals("ico")) {
            return 'i';
        }
        if (ext.equals("bmp")) {
            return 'i';
        }
        if (ext.equals("jpg")) {
            return 'i';
        }
        if (ext.equals("jpeg")) {
            return 'i';
        }
        if (ext.equals("png")) {
            return 'i';
        }
        if (ext.equals("tif")) {
            return 'i';
        }
        if (ext.equals("tiff")) {
            return 'i';
        }
        if (ext.equals("htm")) {
            return 'h';
        }
        if (ext.equals("html")) {
            return 'h';
        }
        if (ext.equals("txt")) {
            return 't';
        }
        if (ext.equals("doc")) {
            return 'd';
        }
        if (ext.equals("rtf")) {
            return 'd';
        }
        if (ext.equals("pdf")) {
            return 'p';
        }
        if (ext.equals("ps")) {
            return 'p';
        }
        if (ext.equals("mp3")) {
            return 'a';
        }
        if (ext.equals("aac")) {
            return 'a';
        }
        if (ext.equals("m4a")) {
            return 'a';
        }
        if (ext.equals("ogg")) {
            return 'a';
        }
        if (ext.equals("wav")) {
            return 'a';
        }
        if (ext.equals("wma")) {
            return 'a';
        }
        if (ext.equals("avi")) {
            return 'm';
        }
        if (ext.equals("mov")) {
            return 'm';
        }
        if (ext.equals("qt")) {
            return 'm';
        }
        if (ext.equals("mpg")) {
            return 'm';
        }
        if (ext.equals("mp4")) {
            return 'm';
        }
        if (ext.equals("m4v")) {
            return 'm';
        }
        if (ext.equals("mkv")) {
            return 'm';
        }
        if (ext.equals("md5")) {
            return 's';
        }
        if (ext.equals("mpeg")) {
            return 'm';
        }
        if (ext.equals("asf")) {
            return 'f';
        }
        return 'u';
    }

    public static char docType(MultiProtocolURL url) {
        String ext = MultiProtocolURL.getFileExtension(url.getFileName());
        if (ext == null) {
            return 'u';
        }
        return Response.docTypeExt(ext);
    }

    public static char docType(String mime) {
        int doctype = 117;
        if (mime == null) {
            doctype = 117;
        } else if (mime.startsWith("image/")) {
            doctype = 105;
        } else if (mime.endsWith("/gif")) {
            doctype = 105;
        } else if (mime.endsWith("/jpeg")) {
            doctype = 105;
        } else if (mime.endsWith("/png")) {
            doctype = 105;
        } else if (mime.endsWith("/html")) {
            doctype = 104;
        } else if (mime.endsWith("/rtf")) {
            doctype = 100;
        } else if (mime.endsWith("/pdf")) {
            doctype = 112;
        } else if (mime.endsWith("/octet-stream")) {
            doctype = 98;
        } else if (mime.endsWith("/x-shockwave-flash")) {
            doctype = 102;
        } else if (mime.endsWith("/msword")) {
            doctype = 100;
        } else if (mime.endsWith("/mspowerpoint")) {
            doctype = 100;
        } else if (mime.endsWith("/postscript")) {
            doctype = 112;
        } else if (mime.startsWith("text/")) {
            doctype = 116;
        } else if (mime.startsWith("audio/")) {
            doctype = 97;
        } else if (mime.startsWith("video/")) {
            doctype = 109;
        }
        return (char)doctype;
    }

    public static String[] doctype2mime(String ext, char doctype) {
        if (doctype == 'p') {
            return new String[]{"application/pdf"};
        }
        if (doctype == 'h') {
            return new String[]{"text/html"};
        }
        if (doctype == 'd') {
            return new String[]{"application/msword"};
        }
        if (doctype == 'f') {
            return new String[]{"application/x-shockwave-flash"};
        }
        if (doctype == 's') {
            return new String[]{"text/plain"};
        }
        if (doctype == 'b') {
            return new String[]{"application/octet-stream"};
        }
        String mime = Classification.ext2mime(ext);
        int p = mime.indexOf(47);
        if (p < 0) {
            return new String[]{mime};
        }
        if (doctype == 't') {
            return new String[]{"text" + mime.substring(p)};
        }
        if (doctype == 'i') {
            return new String[]{"image" + mime.substring(p)};
        }
        if (doctype == 'a') {
            return new String[]{"audio" + mime.substring(p)};
        }
        if (doctype == 'm') {
            return new String[]{"video" + mime.substring(p)};
        }
        return new String[]{mime};
    }

    public Response(Request request, RequestHeader requestHeader, ResponseHeader responseHeader, CrawlProfile profile2, boolean fromCache, byte[] content) {
        this.request = request;
        this.requestHeader = requestHeader;
        this.responseHeader = responseHeader;
        this.profile = profile2;
        this.status = 0;
        this.content = content;
        this.fromCache = fromCache;
        if (this.responseHeader != null && content != null && Integer.parseInt(this.responseHeader.get("Content-Length", "0")) <= content.length) {
            this.responseHeader.put("Content-Length", Integer.toString(content.length));
        }
    }

    public Response(Request request, CrawlProfile profile2) {
        this.request = request;
        this.requestHeader = null;
        this.responseHeader = new ResponseHeader(200);
        this.responseHeader.put("Content-Type", Classification.ext2mime(MultiProtocolURL.getFileExtension(request.url().getFileName()), "text/plain"));
        this.profile = profile2;
        this.status = 0;
        this.content = request.name().length() > 0 ? UTF8.getBytes(request.name()) : UTF8.getBytes(request.url().toTokens());
        this.fromCache = true;
        if (this.responseHeader != null) {
            this.responseHeader.put("Content-Length", "0");
        }
    }

    public void updateStatus(int newStatus) {
        this.status = newStatus;
    }

    public Request getRequest() {
        return this.request;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public boolean fromCache() {
        return this.fromCache;
    }

    public int getStatus() {
        return this.status;
    }

    public String name() {
        return this.request.name();
    }

    public DigestURL url() {
        return this.request.url();
    }

    public char docType() {
        char doctype = Response.docType(this.getMimeType());
        if (doctype == 'u') {
            doctype = Response.docType(this.url());
        }
        return doctype;
    }

    public Date lastModified() {
        Date docDate = null;
        if (this.responseHeader != null) {
            docDate = this.responseHeader.lastModified();
        }
        if (docDate == null && this.request != null) {
            docDate = this.request.appdate();
        }
        if (docDate == null) {
            docDate = new Date();
        }
        return docDate;
    }

    public CrawlProfile profile() {
        return this.profile;
    }

    public byte[] initiator() {
        return this.request.initiator();
    }

    public boolean proxy() {
        return this.initiator() == null;
    }

    public long size() {
        if (this.responseHeader != null && this.responseHeader.getContentLengthLong() != -1L) {
            return this.responseHeader.getContentLengthLong();
        }
        if (this.content != null) {
            return this.content.length;
        }
        return -1L;
    }

    public int depth() {
        return this.request.depth();
    }

    public void setContent(byte[] data) {
        this.content = data;
        if (this.responseHeader != null && this.content != null && Integer.parseInt(this.responseHeader.get("Content-Length", "0")) <= this.content.length) {
            this.responseHeader.put("Content-Length", Integer.toString(this.content.length));
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public String shallStoreCacheForProxy() {
        String crawlerReason = this.shallStoreCacheForCrawler();
        if (crawlerReason != null) {
            return crawlerReason;
        }
        if (this.url().isPOST() && this.profile != null && !this.profile.crawlingQ()) {
            return "dynamic_post";
        }
        if (MultiProtocolURL.isCGI(MultiProtocolURL.getFileExtension(this.url().getFileName()))) {
            return "dynamic_cgi";
        }
        if (this.url().isLocal()) {
            return "local_URL_no_cache_needed";
        }
        if (this.responseHeader != null) {
            String cacheControl = (String)this.responseHeader.get("Pragma");
            if (cacheControl != null && cacheControl.trim().toUpperCase().contains("NO-CACHE")) {
                return "controlled_no_cache";
            }
            cacheControl = (String)this.responseHeader.get("Cache-Control");
            if (cacheControl != null && (cacheControl = cacheControl.trim().toUpperCase()).startsWith("MAX-AGE=")) {
                Date date = this.responseHeader.date();
                if (date == null) {
                    return "stale_no_date_given_in_response";
                }
                try {
                    long ttl = 1000L * NumberTools.parseLongDecSubstring(cacheControl, 8);
                    if (System.currentTimeMillis() - date.getTime() > ttl) {
                        return "stale_expired";
                    }
                }
                catch (Exception e) {
                    return "stale_error_" + e.getMessage() + ")";
                }
            }
        }
        return null;
    }

    public String shallStoreCacheForCrawler() {
        if (this.size() > 0xA00000L) {
            return "too_large_for_caching_" + this.size();
        }
        if (!this.validResponseStatus()) {
            return "bad_status_" + this.responseHeader.getStatusCode();
        }
        if (this.requestHeader != null) {
            if (this.requestHeader.containsKey("Authorization")) {
                return "personalized";
            }
            if (this.requestHeader.containsKey("Range")) {
                return "partial_request";
            }
        }
        if (this.responseHeader != null && this.responseHeader.containsKey("Content-Range")) {
            return "partial_response";
        }
        return null;
    }

    public boolean isFreshForProxy() {
        String cacheControl;
        if (Switchboard.getSwitchboard().getConfigBool("proxyAlwaysFresh", false)) {
            return true;
        }
        if (this.url().isPOST()) {
            return false;
        }
        if (MultiProtocolURL.isCGI(MultiProtocolURL.getFileExtension(this.url().getFileName()))) {
            return false;
        }
        if (this.requestHeader != null) {
            String mimeType;
            if (this.requestHeader.containsKey("Authorization")) {
                return false;
            }
            if (this.requestHeader.containsKey("Range")) {
                return false;
            }
            cacheControl = this.requestHeader.get("Pragma");
            if (cacheControl != null && cacheControl.trim().toUpperCase().contains("NO-CACHE")) {
                return false;
            }
            cacheControl = this.requestHeader.get("Cache-Control");
            if (cacheControl != null && ((cacheControl = cacheControl.trim().toUpperCase()).contains("NO-CACHE") || cacheControl.startsWith("MAX-AGE=0"))) {
                return false;
            }
            if (this.requestHeader.containsKey("If-Modified-Since")) {
                Date d1;
                if (!this.responseHeader.containsKey("Last-Modified")) {
                    return false;
                }
                Date d2 = this.responseHeader.lastModified();
                if (d2 == null) {
                    d2 = new Date();
                }
                if ((d1 = this.requestHeader.ifModifiedSince()) == null) {
                    d1 = new Date();
                }
                if (d2.after(d1)) {
                    return false;
                }
            }
            if (!Classification.isPictureMime(mimeType = this.getMimeType()) && (this.requestHeader.containsKey("Cookie") || this.responseHeader.containsKey("Set-Cookie") || this.responseHeader.containsKey("Set-Cookie2"))) {
                return false;
            }
        }
        if (this.responseHeader != null) {
            cacheControl = (String)this.responseHeader.get("Pragma");
            if (cacheControl != null && cacheControl.trim().toUpperCase().contains("NO-CACHE")) {
                return false;
            }
            Date expires = this.responseHeader.expires();
            Date now = new Date();
            if (expires != null && expires.before(now)) {
                return false;
            }
            Date lastModified = this.responseHeader.lastModified();
            cacheControl = (String)this.responseHeader.get("Cache-Control");
            if (cacheControl == null && lastModified == null && expires == null) {
                return false;
            }
            Date date = this.responseHeader.date();
            if (lastModified != null) {
                long age;
                if (date == null) {
                    date = now;
                }
                if ((age = date.getTime() - lastModified.getTime()) < 0L) {
                    return false;
                }
                if (now.getTime() - date.getTime() > age / 10L) {
                    return false;
                }
            }
            if (cacheControl != null) {
                if ((cacheControl = cacheControl.trim().toUpperCase()).contains("PRIVATE") || cacheControl.contains("NO-CACHE") || cacheControl.contains("NO-STORE")) {
                    return false;
                }
                if (cacheControl.startsWith("MAX-AGE=")) {
                    if (date == null) {
                        return false;
                    }
                    try {
                        long ttl = 1000L * NumberTools.parseLongDecSubstring(cacheControl, 8);
                        if (now.getTime() - date.getTime() > ttl) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final String shallIndexCacheForProxy() {
        if (this.profile() == null) {
            return "shallIndexCacheForProxy: profile() is null !";
        }
        if (!this.profile().indexText() && !this.profile().indexMedia()) {
            return "indexing not allowed - indexText and indexMedia not set (for proxy = " + this.profile.collectionName() + ")";
        }
        if (!this.profile().crawlingQ()) {
            if (this.url().isPOST()) {
                return "Dynamic_(POST)";
            }
            if (MultiProtocolURL.isCGI(MultiProtocolURL.getFileExtension(this.url().getFileName()))) {
                return "Dynamic_(CGI)";
            }
        }
        if (this.requestWithCookie()) {
            return "Dynamic_(Requested_With_Cookie)";
        }
        if (this.responseHeader != null) {
            String parserError = TextParser.supportsMime(this.responseHeader.getContentType());
            if (parserError != null) {
                return "Media_Content, no parser: " + parserError;
            }
            Date ifModifiedSince = this.ifModifiedSince();
            Date now = new Date();
            if (ifModifiedSince != null && this.responseHeader.containsKey("Last-Modified")) {
                Date d = this.responseHeader.lastModified();
                if (d == null) {
                    d = now;
                }
                if (d.after(ifModifiedSince)) {
                    return "Stale_(Last-Modified>Modified-Since)";
                }
            }
            if (this.responseHeader.containsKey("Pragma") && ((String)this.responseHeader.get("Pragma")).toUpperCase().contains("NO-CACHE")) {
                return "Denied_(pragma_no_cache)";
            }
            Date expires = this.responseHeader.expires();
            if (expires != null && expires.before(now)) {
                return "Stale_(Expired)";
            }
            String cacheControl = (String)this.responseHeader.get("Cache-Control");
            if (cacheControl != null) {
                if ((cacheControl = cacheControl.trim().toUpperCase()).contains("PRIVATE") || cacheControl.contains("NO-CACHE") || cacheControl.contains("NO-STORE")) {
                    return "Stale_(denied_by_cache-control=" + cacheControl + ")";
                }
                if (cacheControl.startsWith("MAX-AGE=")) {
                    Date date = this.responseHeader.date();
                    if (date == null) {
                        return "Stale_(no_date_given_in_response)";
                    }
                    try {
                        long ttl = 1000L * NumberTools.parseLongDecSubstring(cacheControl, 8);
                        if (now.getTime() - date.getTime() > ttl) {
                            return "Stale_(expired_by_cache-control)";
                        }
                    }
                    catch (Exception e) {
                        return "Error_(" + e.getMessage() + ")";
                    }
                }
            }
        }
        return null;
    }

    public final String shallIndexCacheForCrawler() {
        String mimeType;
        String parserError;
        if (this.profile() == null) {
            return "shallIndexCacheForCrawler: profile() is null !";
        }
        if (!this.profile().indexText() && !this.profile().indexMedia()) {
            return "indexing not allowed - indexText and indexMedia not set (for crawler = " + this.profile.collectionName() + ")";
        }
        if (!this.profile().crawlingQ()) {
            if (this.url().isPOST()) {
                return "Dynamic_(POST)";
            }
            if (MultiProtocolURL.isCGI(MultiProtocolURL.getFileExtension(this.url().getFileName()))) {
                return "Dynamic_(CGI)";
            }
        }
        if (this.responseHeader != null && !this.profile().isIndexNonParseableUrls() && (parserError = TextParser.supportsMime(mimeType = this.responseHeader.getContentType())) != null && TextParser.supportsExtension(this.url()) != null) {
            return "no parser available: " + parserError;
        }
        return null;
    }

    public String getMimeType() {
        if (this.responseHeader == null) {
            return null;
        }
        String mimeType = this.responseHeader.getContentType();
        if (mimeType != null) {
            int pos = (mimeType = mimeType.trim().toLowerCase(Locale.ROOT)).indexOf(59);
            return pos < 0 ? mimeType : mimeType.substring(0, pos);
        }
        return null;
    }

    public String getCharacterEncoding() {
        if (this.responseHeader == null) {
            return null;
        }
        return this.responseHeader.getCharacterEncoding();
    }

    public DigestURL referrerURL() {
        if (this.requestHeader == null) {
            return null;
        }
        return this.requestHeader.referer();
    }

    public byte[] referrerHash() {
        if (this.requestHeader == null) {
            return null;
        }
        DigestURL url = this.requestHeader.referer();
        if (url == null) {
            return null;
        }
        return url.hash();
    }

    public boolean validResponseStatus() {
        int status = this.responseHeader.getStatusCode();
        return status == 200 || status == 203;
    }

    public Date ifModifiedSince() {
        return this.requestHeader == null ? null : this.requestHeader.ifModifiedSince();
    }

    public boolean requestWithCookie() {
        return this.requestHeader == null ? false : this.requestHeader.containsKey("Cookie");
    }

    public boolean requestProhibitsIndexing() {
        return this.requestHeader == null ? false : this.requestHeader.containsKey("X-YaCy-Index-Control") && this.requestHeader.get("X-YaCy-Index-Control").toUpperCase().equals("NO-INDEX");
    }

    public ResultURLs.EventOrigin processCase(String mySeedHash) {
        ResultURLs.EventOrigin processCase = ResultURLs.EventOrigin.UNKNOWN;
        processCase = this.initiator() == null || this.initiator().length == 0 || ASCII.String(this.initiator()).equals("------------") ? ResultURLs.EventOrigin.PROXY_LOAD : (UTF8.String(this.initiator()).equals(mySeedHash) ? ResultURLs.EventOrigin.LOCAL_CRAWLING : ResultURLs.EventOrigin.GLOBAL_CRAWLING);
        return processCase;
    }

    public Document[] parse() throws Parser.Failure {
        String supportError = TextParser.supports(this.url(), this.responseHeader == null ? null : this.responseHeader.getContentType());
        if (supportError != null) {
            throw new Parser.Failure("no parser support:" + supportError, this.url());
        }
        try {
            return TextParser.parseSource(this.url(), this.responseHeader == null ? null : this.responseHeader.getContentType(), this.responseHeader == null ? StandardCharsets.UTF_8.name() : this.responseHeader.getCharacterEncoding(), TagValency.EVAL, new HashSet<String>(), new VocabularyScraper(), this.request.timezoneOffset(), this.request.depth(), this.content, null);
        }
        catch (Parser.Failure e) {
            throw e;
        }
        catch (Exception e) {
            return null;
        }
    }
}

