/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.sorting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class WeakPriorityBlockingQueue<E>
implements Serializable {
    private static final long serialVersionUID = 4573442576760691887L;
    private final TreeSet<Element<E>> queue = new TreeSet();
    private final Semaphore enqueued;
    private final ArrayList<Element<E>> drained;
    private int maxsize;

    public WeakPriorityBlockingQueue(int maxsize, boolean drain) {
        this.drained = drain ? new ArrayList() : null;
        this.enqueued = new Semaphore(0);
        this.maxsize = maxsize;
    }

    public synchronized void clear() {
        if (this.drained != null) {
            this.drained.clear();
        }
        this.queue.clear();
        this.enqueued.drainPermits();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty() & (this.drained == null || this.drained.isEmpty());
    }

    public synchronized int sizeQueue() {
        return this.queue.size();
    }

    public synchronized int sizeDrained() {
        return this.drained == null ? 0 : this.drained.size();
    }

    public synchronized int sizeAvailable() {
        return this.maxsize < 0 ? this.queue.size() + (this.drained == null ? 0 : this.drained.size()) : Math.min(this.maxsize, this.queue.size() + (this.drained == null ? 0 : this.drained.size()));
    }

    public synchronized void put(Element<E> element) {
        if (this.drained != null && this.drained.contains(element)) {
            return;
        }
        if (this.queue.size() == this.maxsize) {
            if (this.queue.add(element)) {
                this.queue.remove(this.queue.last());
            }
        } else if (this.queue.add(element)) {
            this.enqueued.release();
        }
        assert (this.queue.size() >= this.enqueued.availablePermits()) : "(put) queue.size() = " + this.queue.size() + ", enqueued.availablePermits() = " + this.enqueued.availablePermits();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element<E> poll() {
        boolean a = this.enqueued.tryAcquire();
        if (!a) {
            return null;
        }
        WeakPriorityBlockingQueue weakPriorityBlockingQueue = this;
        synchronized (weakPriorityBlockingQueue) {
            return this.takeUnsafe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element<E> poll(long timeout) throws InterruptedException {
        boolean a;
        boolean bl = a = timeout <= 0L ? this.enqueued.tryAcquire() : this.enqueued.tryAcquire(timeout, TimeUnit.MILLISECONDS);
        if (!a) {
            return null;
        }
        WeakPriorityBlockingQueue weakPriorityBlockingQueue = this;
        synchronized (weakPriorityBlockingQueue) {
            return this.takeUnsafe();
        }
    }

    private Element<E> takeUnsafe() {
        Element<E> element = this.queue.pollFirst();
        assert (element != null);
        if (this.drained != null && (this.maxsize == -1 || this.drained.size() < this.maxsize)) {
            this.drained.add(element);
        }
        assert (this.queue.size() >= this.enqueued.availablePermits()) : "(take) queue.size() = " + this.queue.size() + ", enqueued.availablePermits() = " + this.enqueued.availablePermits();
        return element;
    }

    public synchronized void requeueDrainedElements() {
        if (this.drained != null) {
            int initialDrainedSize = this.drained.size();
            for (int step = 0; step < initialDrainedSize; ++step) {
                Element<E> element = this.drained.remove(this.drained.size() - 1);
                this.put(element);
            }
        }
    }

    public synchronized Element<E> peek() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.first();
    }

    public synchronized Element<E> getLastInQueue() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.last();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element<E> element(int position) {
        if (this.drained == null) {
            return null;
        }
        if (position < this.drained.size()) {
            return this.drained.get(position);
        }
        WeakPriorityBlockingQueue weakPriorityBlockingQueue = this;
        synchronized (weakPriorityBlockingQueue) {
            if (position >= this.queue.size() + this.drained.size()) {
                return null;
            }
            while (position >= this.drained.size()) {
                int s = this.drained.size();
                Element<E> p = this.poll();
                if (this.drained.size() > s && p != null) continue;
            }
            if (position >= this.drained.size()) {
                return null;
            }
            return this.drained.get(position);
        }
    }

    public Element<E> element(int position, long time) throws InterruptedException {
        long t;
        long timeout;
        if (this.drained == null) {
            return null;
        }
        long l = timeout = time == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + time;
        if (position < this.drained.size()) {
            return this.drained.get(position);
        }
        while (position >= this.drained.size() && (t = timeout - System.currentTimeMillis()) > 0L) {
            this.poll(t);
        }
        if (position >= this.drained.size()) {
            return null;
        }
        return this.drained.get(position);
    }

    public synchronized ArrayList<Element<E>> list(int count) {
        if (this.drained == null) {
            return null;
        }
        if (count < 0) {
            return this.list();
        }
        if (count > this.sizeAvailable()) {
            throw new RuntimeException("list(" + count + ") exceeded avaiable number of elements (" + this.sizeAvailable() + ")");
        }
        while (count > this.drained.size()) {
            this.poll();
        }
        return this.drained;
    }

    private synchronized ArrayList<Element<E>> list() {
        if (this.drained == null) {
            return null;
        }
        while (!this.queue.isEmpty()) {
            this.poll();
        }
        return this.drained;
    }

    public synchronized Iterator<Element<E>> iterator() {
        if (this.drained == null) {
            return null;
        }
        while (!this.queue.isEmpty()) {
            this.poll();
        }
        return this.drained.iterator();
    }

    public static void main(String[] args) {
        final WeakPriorityBlockingQueue<String> a = new WeakPriorityBlockingQueue<String>(3, true);
        new Thread(){

            @Override
            public void run() {
                try {
                    Element e;
                    while ((e = a.poll(1000L)) != null) {
                        System.out.println("> " + e.toString());
                    }
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
        a.put(new ReverseElement<String>("abc", 1L));
        a.put(new ReverseElement<String>("abcx", 2L));
        a.put(new ReverseElement<String>("6s_7dfZk4xvc", 3L));
        a.put(new ReverseElement<String>("6s_7dfZk4xvcx", 4L));
        System.out.println("size = " + a.sizeAvailable());
    }

    public static interface Element<E>
    extends Serializable,
    Comparable<Element<E>>,
    Comparator<Element<E>> {
        public long getWeight();

        public E getElement();

        public boolean equals(Element<E> var1);

        public int hashCode();

        public String toString();

        @Override
        public int compare(Element<E> var1, Element<E> var2);

        @Override
        public int compareTo(Element<E> var1);
    }

    public static class ReverseElement<E>
    extends AbstractElement<E>
    implements Element<E>,
    Comparable<Element<E>>,
    Comparator<Element<E>> {
        private static final long serialVersionUID = -8166724491837508921L;

        public ReverseElement(E element, long weight) {
            this.element = element;
            this.weight = weight;
        }

        @Override
        public int compare(Element<E> o1, Element<E> o2) {
            return o1.compareTo(o2);
        }

        @Override
        public int compareTo(Element<E> o) {
            int o2h;
            if (this.element == o.getElement()) {
                return 0;
            }
            if (this.element.equals(o.getElement())) {
                return 0;
            }
            if (this.weight > o.getWeight()) {
                return -1;
            }
            if (this.weight < o.getWeight()) {
                return 1;
            }
            int o1h = this.hashCode();
            if (o1h > (o2h = o.hashCode())) {
                return -1;
            }
            if (o1h < o2h) {
                return 1;
            }
            return 0;
        }
    }

    public static class NaturalElement<E>
    extends AbstractElement<E>
    implements Element<E>,
    Comparable<Element<E>>,
    Comparator<Element<E>> {
        private static final long serialVersionUID = 6816543012966928794L;

        public NaturalElement(E element, long weight) {
            this.element = element;
            this.weight = weight;
        }

        @Override
        public int compare(Element<E> o1, Element<E> o2) {
            return o1.compareTo(o2);
        }

        @Override
        public int compareTo(Element<E> o) {
            int o2h;
            if (this.element == o.getElement()) {
                return 0;
            }
            if (this.element.equals(o.getElement())) {
                return 0;
            }
            if (this.weight > o.getWeight()) {
                return 1;
            }
            if (this.weight < o.getWeight()) {
                return -1;
            }
            int o1h = this.hashCode();
            if (o1h > (o2h = o.hashCode())) {
                return 1;
            }
            if (o1h < o2h) {
                return -1;
            }
            return 0;
        }
    }

    private static abstract class AbstractElement<E>
    implements Element<E>,
    Serializable {
        private static final long serialVersionUID = -7026597258248026566L;
        public long weight;
        public E element;

        private AbstractElement() {
        }

        @Override
        public long getWeight() {
            return this.weight;
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public boolean equals(Element<E> o) {
            return this.element.equals(o.getElement());
        }

        @Override
        public int hashCode() {
            return this.element.hashCode();
        }

        @Override
        public String toString() {
            return this.element.toString() + "/" + this.weight;
        }
    }
}

