/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.language.phonetic;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class Soundex
implements StringEncoder {
    public static final String US_ENGLISH_MAPPING_STRING = "01230120022455012623010202";
    private static final char[] US_ENGLISH_MAPPING = "01230120022455012623010202".toCharArray();
    public static final Soundex US_ENGLISH = new Soundex();
    private final char[] soundexMapping;

    public Soundex() {
        this.soundexMapping = US_ENGLISH_MAPPING;
    }

    public Soundex(char[] mapping) {
        this.soundexMapping = new char[mapping.length];
        System.arraycopy(mapping, 0, this.soundexMapping, 0, mapping.length);
    }

    public Soundex(String mapping) {
        this.soundexMapping = mapping.toCharArray();
    }

    public int difference(String s1, String s2) throws EncoderException {
        return Soundex.difference(this, s1, s2);
    }

    public Object encode(Object pObject) throws EncoderException {
        if (!(pObject instanceof String)) {
            throw new EncoderException("Parameter supplied to Soundex encode is not of type java.lang.String");
        }
        return this.soundex((String)pObject);
    }

    public String encode(String pString) {
        return this.soundex(pString);
    }

    private char getMappingCode(String str, int index2) {
        char preHWChar;
        char firstCode;
        char hwChar;
        char mappedChar = this.map(str.charAt(index2));
        if (!(index2 <= 1 || mappedChar == '0' || 'H' != (hwChar = str.charAt(index2 - 1)) && 'W' != hwChar || (firstCode = this.map(preHWChar = str.charAt(index2 - 2))) != mappedChar && 'H' != preHWChar && 'W' != preHWChar)) {
            return '\u0000';
        }
        return mappedChar;
    }

    private char[] getSoundexMapping() {
        return this.soundexMapping;
    }

    private char map(char ch) {
        int index2 = ch - 65;
        if (index2 < 0 || index2 >= this.getSoundexMapping().length) {
            throw new IllegalArgumentException("The character is not mapped: " + ch);
        }
        return this.getSoundexMapping()[index2];
    }

    public String soundex(String str) {
        if (str == null) {
            return null;
        }
        if ((str = Soundex.clean(str)).isEmpty()) {
            return str;
        }
        char[] out = new char[]{'0', '0', '0', '0'};
        int incount = 1;
        int count = 1;
        out[0] = str.charAt(0);
        char last = this.getMappingCode(str, 0);
        while (incount < str.length() && count < out.length) {
            char mapped;
            if ((mapped = this.getMappingCode(str, incount++)) == '\u0000') continue;
            if (mapped != '0' && mapped != last) {
                out[count++] = mapped;
            }
            last = mapped;
        }
        return new String(out);
    }

    static String clean(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        int len = str.length();
        char[] chars = new char[len];
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (!Character.isLetter(str.charAt(i))) continue;
            chars[count++] = str.charAt(i);
        }
        if (count == len) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return new String(chars, 0, count).toUpperCase(Locale.ENGLISH);
    }

    static int difference(StringEncoder encoder, String s1, String s2) throws EncoderException {
        return Soundex.differenceEncoded(encoder.encode(s1), encoder.encode(s2));
    }

    static int differenceEncoded(String es1, String es2) {
        if (es1 == null || es2 == null) {
            return 0;
        }
        int lengthToMatch = Math.min(es1.length(), es2.length());
        int diff = 0;
        for (int i = 0; i < lengthToMatch; ++i) {
            if (es1.charAt(i) != es2.charAt(i)) continue;
            ++diff;
        }
        return diff;
    }
}

