/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.yacy.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import net.yacy.cora.federate.yacy.Peer;
import net.yacy.cora.federate.yacy.Peers;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.http.HTTPClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Network {
    public static Peers getNetwork(String address) throws IOException {
        Peers peers = new Peers();
        try (HTTPClient httpclient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
            byte[] content = httpclient.GETbytes("http://" + address + "/Network.xml?page=1&maxCount=1000&ip=", null, null, false);
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            Document doc = null;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            }
            catch (Throwable e) {
                throw new IOException(e.getMessage());
            }
            bais.close();
            doc.getDocumentElement().normalize();
            NodeList objects = doc.getElementsByTagName("peer");
            for (int i = 0; i < objects.getLength(); ++i) {
                Node object = objects.item(i);
                if (object.getNodeType() != 1) continue;
                Element element = (Element)object;
                Peer peer = new Peer();
                for (Peer.Schema attr : Peer.Schema.values()) {
                    peer.put(attr, Network.getAttr(attr.name(), element));
                }
                peers.add(peer);
            }
        }
        return peers;
    }

    private static String getAttr(String attr, Element eElement) {
        NodeList nl0 = eElement.getElementsByTagName(attr);
        if (nl0 == null) {
            return "";
        }
        Node n0 = nl0.item(0);
        if (n0 == null) {
            return "";
        }
        NodeList nl1 = n0.getChildNodes();
        if (nl1 == null) {
            return "";
        }
        Node n1 = nl1.item(0);
        if (n1 == null) {
            return "";
        }
        return n1.getNodeValue();
    }

    public static void main(String[] args) {
        try {
            Network.getNetwork("sokrates.homeunix.net:9090");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            HTTPClient.closeConnectionManager();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

