/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.yacy;

import java.io.Serializable;
import java.util.HashMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.order.Base64Order;

public class Peer
extends HashMap<Schema, String>
implements Comparable<Peer>,
Serializable {
    private static final long serialVersionUID = -3279480981385980050L;
    private long time = System.currentTimeMillis();

    public int lastseen() {
        String x = (String)this.get(Schema.lastseen);
        if (x == null) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(x);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public long lastseenTime() {
        return this.time - (long)(this.lastseen() * 60000);
    }

    public float version() {
        String x = (String)this.get(Schema.version);
        if (x == null) {
            return 0.0f;
        }
        int p = x.indexOf(47);
        if (p < 0) {
            return 0.0f;
        }
        x = x.substring(0, p);
        try {
            return Float.parseFloat(x);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public boolean supportsSolr() {
        return this.version() >= 1.041f;
    }

    @Override
    public int compareTo(Peer o) {
        String h0 = (String)this.get(Schema.hash);
        String h1 = (String)o.get(Schema.hash);
        return Base64Order.enhancedCoder.compare(ASCII.getBytes(h0), ASCII.getBytes(h1));
    }

    @Override
    public int hashCode() {
        String h = (String)this.get(Schema.hash);
        return (int)(Base64Order.enhancedCoder.cardinal(h) >> 32);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Peer)) {
            return false;
        }
        String h0 = (String)this.get(Schema.hash);
        String h1 = (String)((Peer)o).get(Schema.hash);
        return h0.equals(h1);
    }

    public static void main(String[] args) {
        String h = "____________";
        long l = Base64Order.enhancedCoder.cardinal(h);
        System.out.println("l = " + l + ", h = " + (int)(l >> 32));
        System.out.println("l-maxlong = " + (l - Long.MAX_VALUE) + ", (h-maxint) = " + ((int)(l >> 32) - Integer.MAX_VALUE));
    }

    public static enum Schema implements Serializable
    {
        hash,
        fullname,
        version,
        ppm,
        qph,
        uptime,
        links,
        words,
        rurls,
        lastseen,
        sendWords,
        receivedWords,
        sendURLs,
        receivedURLs,
        type,
        direct,
        acceptcrawl,
        dhtreceive,
        nodestate,
        location,
        seedurl,
        age,
        seeds,
        connects,
        address,
        useragent;

    }
}

