/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.federate.solr.responsewriter;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.yacy.cora.federate.solr.SolrType;
import net.yacy.cora.federate.solr.responsewriter.SolrjResponseWriter;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.ReturnFields;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SolrReturnFields;

public class EnhancedXMLResponseWriter
implements QueryResponseWriter,
SolrjResponseWriter {
    private static final char lb = '\n';
    private static final char[] XML_START = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>\n<response>\n".toCharArray();
    private static final char[] XML_STOP = "\n</response>\n".toCharArray();

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/xml; charset=UTF-8";
    }

    public void init(NamedList n) {
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse rsp) throws IOException {
        writer.write(XML_START);
        NamedList values = rsp.getValues();
        assert (values.get("responseHeader") != null);
        assert (values.get("response") != null);
        NamedList responseHeader = rsp.getResponseHeader();
        Object responseObj = rsp.getResponse();
        EnhancedXMLResponseWriter.writeProps(writer, "responseHeader", responseHeader);
        if (responseObj instanceof ResultContext) {
            EnhancedXMLResponseWriter.writeDocs(writer, request, ((ResultContext)responseObj).getDocList(), rsp.getReturnFields());
        } else if (responseObj instanceof SolrDocumentList) {
            EnhancedXMLResponseWriter.writeDocs(writer, (SolrDocumentList)responseObj, rsp.getReturnFields());
        } else {
            throw new IOException("Unable to process Solr response format");
        }
        Object highlightingObj = values.get("highlighting");
        if (highlightingObj instanceof NamedList) {
            EnhancedXMLResponseWriter.writeProps(writer, "highlighting", (NamedList)highlightingObj);
        }
        writer.write(XML_STOP);
    }

    @Override
    public void write(Writer writer, SolrQueryRequest request, String coreName, QueryResponse response) throws IOException {
        writer.write(XML_START);
        EnhancedXMLResponseWriter.writeDocs(writer, response.getResults(), (ReturnFields)(request != null ? new SolrReturnFields(request) : new SolrReturnFields()));
        writer.write(XML_STOP);
    }

    private static void writeProps(Writer writer, String name, NamedList<?> val) throws IOException {
        if (val == null) {
            return;
        }
        int sz = val.size();
        if (sz <= 0) {
            EnhancedXMLResponseWriter.startTagClose(writer, "lst", name);
        } else {
            EnhancedXMLResponseWriter.startTagOpen(writer, "lst", name);
        }
        for (int i = 0; i < sz; ++i) {
            String n = val.getName(i);
            Object v = val.getVal(i);
            if (v instanceof Integer) {
                EnhancedXMLResponseWriter.writeTag(writer, "int", n, ((Integer)v).toString(), false);
                continue;
            }
            if (v instanceof String) {
                EnhancedXMLResponseWriter.writeTag(writer, "str", n, (String)v, true);
                continue;
            }
            if (v instanceof String[]) {
                EnhancedXMLResponseWriter.writeTag(writer, "str", n, (String[])v, true);
                continue;
            }
            if (!(v instanceof NamedList)) continue;
            EnhancedXMLResponseWriter.writeProps(writer, n, (NamedList)v);
        }
        if (sz > 0) {
            writer.write("</lst>");
            writer.write(10);
        }
    }

    private static final void writeDocs(Writer writer, SolrQueryRequest request, DocList response, ReturnFields returnFields) throws IOException {
        boolean includeScore = false;
        int sz = response.size();
        writer.write("<result");
        EnhancedXMLResponseWriter.writeAttr(writer, "name", "response");
        EnhancedXMLResponseWriter.writeAttr(writer, "numFound", Long.toString(response.matches()));
        EnhancedXMLResponseWriter.writeAttr(writer, "start", Long.toString(response.offset()));
        if (includeScore) {
            EnhancedXMLResponseWriter.writeAttr(writer, "maxScore", Float.toString(response.maxScore()));
        }
        if (sz == 0) {
            writer.write("/>");
            return;
        }
        writer.write(62);
        writer.write(10);
        SolrIndexSearcher searcher = request.getSearcher();
        DocIterator iterator = response.iterator();
        includeScore = includeScore && response.hasScores();
        IndexSchema schema2 = request.getSchema();
        for (int i = 0; i < sz; ++i) {
            int id = iterator.nextDoc();
            Document doc = searcher.doc(id);
            EnhancedXMLResponseWriter.writeDoc(writer, schema2, null, doc.getFields(), includeScore ? iterator.score() : 0.0f, includeScore, returnFields);
        }
        writer.write("</result>");
        writer.write(10);
    }

    private static final void writeDocs(Writer writer, SolrDocumentList docs, ReturnFields returnFields) throws IOException {
        boolean includeScore = false;
        int sz = docs.size();
        writer.write("<result");
        EnhancedXMLResponseWriter.writeAttr(writer, "name", "response");
        EnhancedXMLResponseWriter.writeAttr(writer, "numFound", Long.toString(docs.getNumFound()));
        EnhancedXMLResponseWriter.writeAttr(writer, "start", Long.toString(docs.getStart()));
        if (includeScore) {
            EnhancedXMLResponseWriter.writeAttr(writer, "maxScore", Float.toString(docs.getMaxScore().floatValue()));
        }
        if (sz == 0) {
            writer.write("/>");
            return;
        }
        writer.write(62);
        writer.write(10);
        Iterator iterator = docs.iterator();
        for (int i = 0; i < sz; ++i) {
            SolrDocument doc = (SolrDocument)iterator.next();
            EnhancedXMLResponseWriter.writeDoc(writer, doc, returnFields);
        }
        writer.write("</result>");
        writer.write(10);
    }

    private static final void writeDoc(Writer writer, IndexSchema schema2, String name, List<IndexableField> fields, float score, boolean includeScore, ReturnFields returnFields) throws IOException {
        EnhancedXMLResponseWriter.startTagOpen(writer, "doc", name);
        if (includeScore) {
            EnhancedXMLResponseWriter.writeTag(writer, "float", "score", Float.toString(score), false);
        }
        Map fieldRenamings = returnFields == null ? Collections.emptyMap() : returnFields.getFieldRenames();
        int sz = fields.size();
        int fidx1 = 0;
        int fidx2 = 0;
        while (fidx1 < sz) {
            IndexableField value = fields.get(fidx1);
            String fieldName = value.name();
            for (fidx2 = fidx1 + 1; fidx2 < sz && fieldName.equals(fields.get(fidx2).name()); ++fidx2) {
            }
            if (returnFields == null || returnFields.wantsField(fieldName)) {
                SchemaField sf;
                SchemaField schemaField = sf = schema2 == null ? null : schema2.getFieldOrNull(fieldName);
                if (sf == null) {
                    sf = new SchemaField(fieldName, (FieldType)new TextField());
                }
                String renderedFieldName = fieldRenamings.getOrDefault(fieldName, fieldName);
                FieldType type = sf.getType();
                if (fidx1 + 1 == fidx2) {
                    if (sf.multiValued()) {
                        EnhancedXMLResponseWriter.startTagOpen(writer, "arr", renderedFieldName);
                        writer.write(10);
                        String sv = value.stringValue();
                        EnhancedXMLResponseWriter.writeField(writer, type.getTypeName(), null, sv);
                        writer.write("</arr>");
                    } else {
                        EnhancedXMLResponseWriter.writeField(writer, type.getTypeName(), renderedFieldName, value.stringValue());
                    }
                } else {
                    EnhancedXMLResponseWriter.startTagOpen(writer, "arr", renderedFieldName);
                    writer.write(10);
                    for (int i = fidx1; i < fidx2; ++i) {
                        String sv = fields.get(i).stringValue();
                        EnhancedXMLResponseWriter.writeField(writer, type.getTypeName(), null, sv);
                    }
                    writer.write("</arr>");
                    writer.write(10);
                }
            }
            fidx1 = fidx2;
        }
        writer.write("</doc>");
        writer.write(10);
    }

    public static final void writeDoc(Writer writer, SolrInputDocument sid) throws IOException {
        EnhancedXMLResponseWriter.startTagOpen(writer, "doc", null);
        for (String key : sid.getFieldNames()) {
            SolrInputField sif = sid.getField(key);
            Object value = sif.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                EnhancedXMLResponseWriter.startTagOpen(writer, "arr", key);
                writer.write(10);
                for (Object o : (Collection)value) {
                    EnhancedXMLResponseWriter.writeField(writer, null, o);
                }
                writer.write("</arr>");
                writer.write(10);
                continue;
            }
            EnhancedXMLResponseWriter.writeField(writer, key, value);
        }
        writer.write("</doc>");
        writer.write(10);
    }

    private static final void writeDoc(Writer writer, SolrDocument doc, ReturnFields returnFields) throws IOException {
        EnhancedXMLResponseWriter.startTagOpen(writer, "doc", null);
        Map fieldRenamings = returnFields == null ? Collections.emptyMap() : returnFields.getFieldRenames();
        Map fields = doc.getFieldValueMap();
        for (String key : fields.keySet()) {
            if (key == null || returnFields != null && !returnFields.wantsField(key)) continue;
            Object value = doc.get((Object)key);
            String renderedFieldName = fieldRenamings.getOrDefault(key, key);
            if (value == null) continue;
            if (value instanceof Collection) {
                EnhancedXMLResponseWriter.startTagOpen(writer, "arr", renderedFieldName);
                writer.write(10);
                for (Object o : (Collection)value) {
                    EnhancedXMLResponseWriter.writeField(writer, null, o);
                }
                writer.write("</arr>");
                writer.write(10);
                continue;
            }
            EnhancedXMLResponseWriter.writeField(writer, renderedFieldName, value);
        }
        writer.write("</doc>");
        writer.write(10);
    }

    public static final void writeDoc(Writer writer, SolrDocument doc) throws IOException {
        EnhancedXMLResponseWriter.writeDoc(writer, doc, null);
    }

    private static void writeField(Writer writer, String typeName, String name, String value) throws IOException {
        if (typeName.equals(SolrType.text_general.printName()) || typeName.equals(SolrType.string.printName()) || typeName.equals(SolrType.text_en_splitting_tight.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "str", name, value, true);
        } else if (typeName.equals(SolrType.bool.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "bool", name, "F".equals(value) ? "false" : "true", true);
        } else if (typeName.equals(SolrType.num_integer.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "int", name, value, true);
        } else if (typeName.equals(SolrType.num_long.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "long", name, value, true);
        } else if (typeName.equals(SolrType.date.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "date", name, new Date(Long.parseLong(value)).toInstant().toString(), true);
        } else if (typeName.equals(SolrType.num_float.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "float", name, value, true);
        } else if (typeName.equals(SolrType.num_double.printName())) {
            EnhancedXMLResponseWriter.writeTag(writer, "double", name, value, true);
        }
    }

    private static void writeField(Writer writer, String name, Object value) throws IOException {
        if (value instanceof String) {
            EnhancedXMLResponseWriter.writeTag(writer, "str", name, (String)value, true);
        } else if (value instanceof Boolean) {
            EnhancedXMLResponseWriter.writeTag(writer, "bool", name, ((Boolean)value).toString(), true);
        } else if (value instanceof Integer) {
            EnhancedXMLResponseWriter.writeTag(writer, "int", name, ((Integer)value).toString(), true);
        } else if (value instanceof Long) {
            EnhancedXMLResponseWriter.writeTag(writer, "long", name, ((Long)value).toString(), true);
        } else if (value instanceof Date) {
            EnhancedXMLResponseWriter.writeTag(writer, "date", name, ((Date)value).toInstant().toString(), true);
        } else if (value instanceof Float) {
            EnhancedXMLResponseWriter.writeTag(writer, "float", name, ((Float)value).toString(), true);
        } else if (value instanceof Double) {
            EnhancedXMLResponseWriter.writeTag(writer, "double", name, ((Double)value).toString(), true);
        }
    }

    private static void writeTag(Writer writer, String tag, String nameAttr, String val, boolean escape) throws IOException {
        int contentLen = val.length();
        if (contentLen == 0) {
            EnhancedXMLResponseWriter.startTagClose(writer, tag, nameAttr);
            return;
        }
        EnhancedXMLResponseWriter.startTagOpen(writer, tag, nameAttr);
        if (escape) {
            XML.escapeCharData((String)val, (Writer)writer);
        } else {
            writer.write(val, 0, contentLen);
        }
        writer.write("</");
        writer.write(tag);
        writer.write(62);
        writer.write(10);
    }

    private static void writeTag(Writer writer, String tag, String nameAttr, String[] vals, boolean escape) throws IOException {
        EnhancedXMLResponseWriter.startTagOpen(writer, "arr", nameAttr);
        for (String val : vals) {
            EnhancedXMLResponseWriter.writeTag(writer, tag, null, val, escape);
        }
        writer.write("</arr>");
        writer.write(10);
    }

    private static void startTagOpen(Writer writer, String tag, String nameAttr) throws IOException {
        writer.write(60);
        writer.write(tag);
        if (nameAttr != null) {
            EnhancedXMLResponseWriter.writeAttr(writer, "name", nameAttr);
        }
        writer.write(62);
    }

    private static void startTagClose(Writer writer, String tag, String nameAttr) throws IOException {
        writer.write(60);
        writer.write(tag);
        if (nameAttr != null) {
            EnhancedXMLResponseWriter.writeAttr(writer, "name", nameAttr);
        }
        writer.write("/>");
        writer.write(10);
    }

    private static void writeAttr(Writer writer, String nameAttr, String val) throws IOException {
        writer.write(32);
        writer.write(nameAttr);
        writer.write("=\"");
        XML.escapeAttributeValue((String)val, (Writer)writer);
        writer.write(34);
    }
}

