/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.document.encoding;

import java.util.Comparator;

public class ASCII
implements Comparator<String> {
    public static final ASCII insensitiveASCIIComparator = new ASCII(true);
    public static final ASCII identityASCIIComparator = new ASCII(false);
    public boolean insensitive;

    public ASCII(boolean insensitive) {
        this.insensitive = insensitive;
    }

    public Object clone() {
        return this;
    }

    @Override
    public int compare(String s0, String s1) {
        if (s0 == null && s1 == null) {
            return 0;
        }
        if (s0 == null) {
            return -1;
        }
        if (s1 == null) {
            return 1;
        }
        int l0 = s0.length();
        int l1 = s1.length();
        int lm = Math.min(l0, l1);
        for (int i = 0; i < lm; ++i) {
            char c0 = s0.charAt(i);
            char c1 = s1.charAt(i);
            if (this.insensitive && c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)((byte)c0 + 32);
            }
            if (this.insensitive && c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)((byte)c1 + 32);
            }
            if (c0 > c1) {
                return 1;
            }
            if (c1 <= c0) continue;
            return -1;
        }
        if (l0 > l1) {
            return 1;
        }
        if (l1 > l0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(String s0, String s1) {
        if (s0 == null && s1 == null) {
            return true;
        }
        if (s0 == null) {
            return false;
        }
        if (s1 == null) {
            return false;
        }
        int l0 = s0.length();
        int l1 = s1.length();
        int lm = Math.min(l0, l1);
        for (int i = 0; i < lm; ++i) {
            char c0 = s0.charAt(i);
            char c1 = s1.charAt(i);
            if (this.insensitive && c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)((byte)c0 + 32);
            }
            if (this.insensitive && c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)((byte)c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return l0 == l1;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static final String String(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] c = new char[bytes.length];
        for (int i = bytes.length - 1; i >= 0; --i) {
            c[i] = (char)bytes[i];
        }
        return new String(c);
    }

    public static final String String(byte[] bytes, int offset, int length) {
        int l = Math.min(length, bytes.length - offset);
        char[] c = new char[l];
        for (int i = 0; i < l; ++i) {
            if (bytes[i + offset] < 0) {
                throw new IllegalArgumentException("non-ASCII character detected");
            }
            c[i] = (char)bytes[i + offset];
        }
        return new String(c);
    }

    public static final byte[] getBytes(String s) {
        assert (s != null);
        int count = s.length();
        byte[] b = new byte[count];
        for (int i = 0; i < count; ++i) {
            b[i] = (byte)s.charAt(i);
        }
        return b;
    }

    public static final byte[] getBytes(String s, int beginIndex, int endIndex) {
        assert (s != null);
        int count = endIndex - beginIndex;
        byte[] b = new byte[count];
        for (int i = 0; i < count; ++i) {
            b[i] = (byte)s.charAt(i + beginIndex);
        }
        return b;
    }
}

