/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.cora.bayes;

import java.util.Collection;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.yacy.cora.bayes.Classification;
import net.yacy.cora.bayes.Classifier;

public class BayesClassifier<T, K>
extends Classifier<T, K> {
    private float featuresProbabilityProduct(Collection<T> features, K category) {
        float product = 1.0f;
        for (T feature : features) {
            product *= this.featureWeighedAverage(feature, category);
        }
        return product;
    }

    private float categoryProbability(Collection<T> features, K category) {
        return (float)this.categoryCount(category) / (float)this.getCategoriesTotal() * this.featuresProbabilityProduct(features, category);
    }

    private SortedSet<Classification<T, K>> categoryProbabilities(Collection<T> features) {
        TreeSet<Classification<T, K>> probabilities = new TreeSet<Classification<T, K>>(new Comparator<Classification<T, K>>(){

            @Override
            public int compare(Classification<T, K> o1, Classification<T, K> o2) {
                int toReturn = Float.compare(o1.getProbability(), o2.getProbability());
                if (toReturn == 0 && !o1.getCategory().equals(o2.getCategory())) {
                    toReturn = -1;
                }
                return toReturn;
            }
        });
        for (Object category : this.getCategories()) {
            probabilities.add(new Classification(features, category, this.categoryProbability(features, category)));
        }
        return probabilities;
    }

    @Override
    public Classification<T, K> classify(Collection<T> features) {
        SortedSet<Classification<T, K>> probabilites = this.categoryProbabilities(features);
        if (probabilites.size() > 0) {
            return probabilites.last();
        }
        return null;
    }

    public Collection<Classification<T, K>> classifyDetailed(Collection<T> features) {
        return this.categoryProbabilities(features);
    }
}

