/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javainetlocator;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.sf.javainetlocator.InetAddressLocatorException;

public class InetAddressLocator {
    private static final String thisClass = "net.sf.javainetlocator.InetAddressLocator";
    private static final String thisPath = "net/sf/javainetlocator/";
    private static final String locPropPath = "net/sf/javainetlocator/locale.props";
    private static final String ipDbPath = "net/sf/javainetlocator/ip";
    private static final String ccDbPath = "net/sf/javainetlocator/cc";
    private final byte[] ip_db;
    private final Locale[] cc_db;
    private static final InetAddressLocator me;

    private InetAddressLocator() throws InetAddressLocatorException {
        Map map = InetAddressLocator.load_locales();
        this.ip_db = InetAddressLocator.load_ip_database();
        this.cc_db = InetAddressLocator.load_cc_database(map);
    }

    private static Map load_locales() throws InetAddressLocatorException {
        Object object;
        HashMap<String, Locale> hashMap = new HashMap<String, Locale>();
        Properties properties = new Properties();
        try {
            object = Class.forName(thisClass).getClassLoader();
            properties.load(((ClassLoader)object).getResourceAsStream(locPropPath));
        }
        catch (Exception exception) {
            throw new InetAddressLocatorException("couldn't read locale.props file", exception);
        }
        object = properties.propertyNames();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            if (string.length() != 2) {
                throw new InetAddressLocatorException("bad country name in locale.props:" + string);
            }
            String string2 = properties.getProperty(string, "");
            if (string2.length() != 2) {
                throw new InetAddressLocatorException("bad language naname in locale.props: " + string2);
            }
            hashMap.put(string, new Locale(string2, string));
        }
        hashMap.put("--", new Locale("", ""));
        return hashMap;
    }

    private static byte[] load_ip_database() throws InetAddressLocatorException {
        try {
            return InetAddressLocator.getResourceAsByteArray(ipDbPath);
        }
        catch (Exception exception) {
            throw new InetAddressLocatorException("couldn't read IP database", exception);
        }
    }

    private static Locale[] load_cc_database(Map map) throws InetAddressLocatorException {
        byte[] byArray;
        Locale[] localeArray = new Locale[256];
        try {
            byArray = InetAddressLocator.getResourceAsByteArray(ccDbPath);
        }
        catch (Exception exception) {
            throw new InetAddressLocatorException("couldn't read country-code database", exception);
        }
        for (int i = 0; i < byArray.length; i += 3) {
            int n = InetAddressLocator.complementToUnsigned(byArray[i]);
            String string = "" + (char)InetAddressLocator.complementToUnsigned(byArray[i + 1]) + (char)InetAddressLocator.complementToUnsigned(byArray[i + 2]);
            Locale locale = (Locale)map.get(string);
            if (locale == null) {
                throw new InetAddressLocatorException("country code must appear in locale.props (but doesn't): " + string);
            }
            localeArray[n] = locale;
        }
        return localeArray;
    }

    private static byte[] getResourceAsByteArray(String string) throws IOException, NoClassDefFoundError, ClassNotFoundException {
        byte[] byArray;
        int n;
        ClassLoader classLoader = Class.forName(thisClass).getClassLoader();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(classLoader.getResourceAsStream(string));
        byte[] byArray2 = new byte[256];
        int n2 = 0;
        while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
            if (n2 >= byArray2.length) {
                byArray = new byte[byArray2.length * 2];
                System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
                byArray2 = byArray;
            }
            byArray2[n2] = InetAddressLocator.unsignedToComplement(n);
            ++n2;
        }
        ((InputStream)bufferedInputStream).close();
        byArray = new byte[n2];
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        byArray2 = byArray;
        return byArray2;
    }

    public static Locale getLocale(String string) throws InetAddressLocatorException {
        byte[] byArray = InetAddressLocator.addressToByteArray(string);
        if (byArray != null) {
            return InetAddressLocator.getLocale(byArray);
        }
        try {
            return InetAddressLocator.getLocale(InetAddress.getByName(string));
        }
        catch (UnknownHostException unknownHostException) {
            throw new InetAddressLocatorException(unknownHostException.getMessage(), unknownHostException);
        }
    }

    public static Locale getLocale(InetAddress inetAddress) throws InetAddressLocatorException {
        return InetAddressLocator.getLocale(inetAddress.getAddress());
    }

    public static Locale getLocale(byte[] byArray) throws InetAddressLocatorException {
        int n = 4;
        for (int n2 = 0; n2 < byArray.length; n2 = (int)((byte)(n2 + 1))) {
            for (int n3 = 0; n3 < 8; n3 = (int)((byte)(n3 + 1))) {
                int n4;
                int n5;
                if (InetAddressLocator.isJump(InetAddressLocator.me.ip_db[n])) {
                    n5 = 1;
                    boolean bl = false;
                    n4 = 0;
                    if (InetAddressLocator.isMultiByteJump(InetAddressLocator.me.ip_db[n])) {
                        n5 = 3;
                        bl = true;
                    }
                    if (InetAddressLocator.bitIsSet(byArray[n2], n3)) {
                        n4 = bl ? InetAddressLocator.jump(InetAddressLocator.me.ip_db[n], InetAddressLocator.me.ip_db[n + 1], InetAddressLocator.me.ip_db[n + 2]) : InetAddressLocator.jump(InetAddressLocator.me.ip_db[n]);
                    }
                } else {
                    throw new InetAddressLocatorException("IP database is corrupt - please re-install");
                }
                n = n + n5 + n4;
                if (!InetAddressLocator.isCountryCode(InetAddressLocator.me.ip_db[n])) continue;
                n5 = InetAddressLocator.isMultiByteCountry(InetAddressLocator.me.ip_db[n]) ? InetAddressLocator.country(InetAddressLocator.me.ip_db[n], InetAddressLocator.me.ip_db[n + 1]) : InetAddressLocator.country(InetAddressLocator.me.ip_db[n]);
                return InetAddressLocator.me.cc_db[n5];
            }
        }
        throw new InetAddressLocatorException("IP database is corrupt - please re-install");
    }

    private static boolean isCountryCode(byte by) throws InetAddressLocatorException {
        return InetAddressLocator.bitIsSet(by, 0);
    }

    private static boolean isMultiByteCountry(byte by) throws InetAddressLocatorException {
        return InetAddressLocator.bitIsSet(by, 1);
    }

    private static boolean isJump(byte by) throws InetAddressLocatorException {
        return !InetAddressLocator.bitIsSet(by, 0);
    }

    private static boolean isMultiByteJump(byte by) throws InetAddressLocatorException {
        return !InetAddressLocator.bitIsSet(by, 1);
    }

    private static int jump(byte by) {
        return by - 64;
    }

    private static int jump(byte by, byte by2, byte by3) throws InetAddressLocatorException {
        return InetAddressLocator.complementToUnsigned(by) * 256 * 256 + InetAddressLocator.complementToUnsigned(by2) * 256 + InetAddressLocator.complementToUnsigned(by3);
    }

    private static int country(byte by) {
        return by + 128;
    }

    private static int country(byte by, byte by2) throws InetAddressLocatorException {
        return InetAddressLocator.complementToUnsigned(by2);
    }

    private static boolean bitIsSet(byte by, int n) throws InetAddressLocatorException {
        int n2;
        switch (n) {
            case 0: {
                n2 = -128;
                break;
            }
            case 1: {
                n2 = 64;
                break;
            }
            case 2: {
                n2 = 32;
                break;
            }
            case 3: {
                n2 = 16;
                break;
            }
            case 4: {
                n2 = 8;
                break;
            }
            case 5: {
                n2 = 4;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 7: {
                n2 = 1;
                break;
            }
            default: {
                throw new InetAddressLocatorException("attempt to check bad bit position");
            }
        }
        return (by & n2) == n2;
    }

    private static int complementToUnsigned(byte by) throws InetAddressLocatorException {
        if (InetAddressLocator.bitIsSet(by, 0)) {
            return by + 256;
        }
        return by;
    }

    private static byte unsignedToComplement(int n) {
        if ((n & 0x80) == 128) {
            return (byte)(n - 256);
        }
        return (byte)n;
    }

    private static byte[] addressToByteArray(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c;
            if (Character.isDigit(c = cArray[n2++])) {
                int n4 = byArray[n3] * 10 + (Character.digit(c, 10) & 0xFF);
                if (n4 > 255) {
                    return null;
                }
                byArray[n3] = (byte)(n4 & 0xFF);
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '.' && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n != 4) {
            return null;
        }
        return byArray;
    }

    static {
        try {
            me = new InetAddressLocator();
        }
        catch (InetAddressLocatorException inetAddressLocatorException) {
            throw new RuntimeException("error during class loading", inetAddressLocatorException);
        }
    }
}

