/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import org.apache.solr.client.solrj.request.ApiMapping;
import org.apache.solr.client.solrj.request.CoreApiMapping;
import org.apache.solr.handler.admin.BaseHandlerApiSupport;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CoreAdminOperation;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;

public class CoreAdminHandlerApi
extends BaseHandlerApiSupport {
    private final CoreAdminHandler handler;
    static Collection<BaseHandlerApiSupport.ApiCommand> apiCommands = CoreAdminHandlerApi.createMapping();

    private static Collection<BaseHandlerApiSupport.ApiCommand> createMapping() {
        EnumMap<CoreApiMapping.Meta, 1> result = new EnumMap<CoreApiMapping.Meta, 1>(CoreApiMapping.Meta.class);
        for (final CoreApiMapping.Meta meta : CoreApiMapping.Meta.values()) {
            for (final CoreAdminOperation op : CoreAdminOperation.values()) {
                if (op.action != meta.action) continue;
                result.put(meta, new BaseHandlerApiSupport.ApiCommand(){

                    @Override
                    public ApiMapping.CommandMeta meta() {
                        return meta;
                    }

                    @Override
                    public void invoke(SolrQueryRequest req, SolrQueryResponse rsp, BaseHandlerApiSupport apiHandler) throws Exception {
                        op.execute(new CoreAdminHandler.CallInfo(((CoreAdminHandlerApi)apiHandler).handler, req, rsp, op));
                    }
                });
            }
        }
        for (final CoreApiMapping.Meta meta : CoreApiMapping.Meta.values()) {
            if (result.get(meta) != null) continue;
            throw new RuntimeException("No implementation for " + meta.name());
        }
        return result.values();
    }

    public CoreAdminHandlerApi(CoreAdminHandler handler) {
        this.handler = handler;
    }

    @Override
    protected Collection<BaseHandlerApiSupport.ApiCommand> getCommands() {
        return apiCommands;
    }

    @Override
    protected Collection<ApiMapping.V2EndPoint> getEndPoints() {
        return Arrays.asList(CoreApiMapping.EndPoint.values());
    }
}

