/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CloudConfig;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrPaths;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.logging.LogWatcherConfig;
import org.apache.solr.metrics.reporters.SolrJmxReporter;
import org.apache.solr.update.UpdateShardHandlerConfig;
import org.apache.solr.util.JmxUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SolrXmlConfig {
    public static final String ZK_HOST = "zkHost";
    public static final String SOLR_XML_FILE = "solr.xml";
    public static final String SOLR_DATA_HOME = "solr.data.home";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern COMMA_SEPARATED_PATTERN = Pattern.compile("\\s*,\\s*");

    public static Properties wrapAndSetZkHostFromSysPropIfNeeded(Properties props) {
        if (null != props && !StringUtils.isEmpty((CharSequence)props.getProperty(ZK_HOST))) {
            return props;
        }
        Properties results = null == props ? new Properties() : new Properties(props);
        String sysprop = System.getProperty(ZK_HOST);
        if (!StringUtils.isEmpty((CharSequence)sysprop)) {
            results.setProperty(ZK_HOST, sysprop);
        }
        return results;
    }

    public static NodeConfig fromConfig(Path solrHome, XmlConfigFile config, boolean fromZookeeper) {
        UpdateShardHandlerConfig updateConfig;
        NamedList<Object> entries;
        String nodeName;
        SolrXmlConfig.checkForIllegalConfig(config);
        assert (!fromZookeeper || null != config.getSubstituteProperties() && null != config.getSubstituteProperties().getProperty(ZK_HOST));
        String defaultZkHost = SolrXmlConfig.wrapAndSetZkHostFromSysPropIfNeeded(config.getSubstituteProperties()).getProperty(ZK_HOST);
        CloudConfig cloudConfig = null;
        UpdateShardHandlerConfig deprecatedUpdateConfig = null;
        if (config.getNodeList("solr/solrcloud", false).getLength() > 0) {
            NamedList<Object> cloudSection = SolrXmlConfig.readNodeListAsNamedList(config, "solr/solrcloud/*[@name]", "<solrcloud>");
            deprecatedUpdateConfig = SolrXmlConfig.loadUpdateConfig(cloudSection, false);
            cloudConfig = SolrXmlConfig.fillSolrCloudSection(cloudSection, config, defaultZkHost);
        }
        if (Strings.isNullOrEmpty((String)(nodeName = (String)(entries = SolrXmlConfig.readNodeListAsNamedList(config, "solr/*[@name]", "<solr>")).remove("nodeName"))) && cloudConfig != null) {
            nodeName = cloudConfig.getHost();
        }
        if (deprecatedUpdateConfig == null) {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), true);
        } else {
            updateConfig = SolrXmlConfig.loadUpdateConfig(SolrXmlConfig.readNodeListAsNamedList(config, "solr/updateshardhandler/*[@name]", "<updateshardhandler>"), false);
            if (updateConfig != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "UpdateShardHandler configuration defined twice in solr.xml");
            }
            updateConfig = deprecatedUpdateConfig;
        }
        NodeConfig.NodeConfigBuilder configBuilder = new NodeConfig.NodeConfigBuilder(nodeName, solrHome);
        configBuilder.setSolrResourceLoader(config.getResourceLoader());
        configBuilder.setUpdateShardHandlerConfig(updateConfig);
        configBuilder.setShardHandlerFactoryConfig(SolrXmlConfig.getShardHandlerFactoryPluginInfo(config));
        configBuilder.setSolrCoreCacheFactoryConfig(SolrXmlConfig.getTransientCoreCacheFactoryPluginInfo(config));
        configBuilder.setTracerConfig(SolrXmlConfig.getTracerPluginInfo(config));
        configBuilder.setLogWatcherConfig(SolrXmlConfig.loadLogWatcherConfig(config, "solr/logging/*[@name]", "solr/logging/watcher/*[@name]"));
        configBuilder.setSolrProperties(SolrXmlConfig.loadProperties(config));
        if (cloudConfig != null) {
            configBuilder.setCloudConfig(cloudConfig);
        }
        configBuilder.setBackupRepositoryPlugins(SolrXmlConfig.getBackupRepositoryPluginInfos(config));
        configBuilder.setMetricsConfig(SolrXmlConfig.getMetricsConfig(config));
        configBuilder.setFromZookeeper(fromZookeeper);
        configBuilder.setDefaultZkHost(defaultZkHost);
        return SolrXmlConfig.fillSolrSection(configBuilder, entries);
    }

    public static NodeConfig fromFile(Path solrHome, Path configFile, Properties substituteProps) {
        NodeConfig nodeConfig;
        block12: {
            if (!Files.exists(configFile, new LinkOption[0])) {
                if (Boolean.getBoolean("solr.solrxml.required")) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "solr.xml does not exist in " + configFile.getParent() + " cannot start Solr");
                }
                log.info("solr.xml not found in SOLR_HOME, using built-in default");
                String solrInstallDir = System.getProperty("solr.install.dir");
                if (solrInstallDir == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find default solr.xml file due to missing solr.install.dir");
                }
                configFile = Path.of(solrInstallDir, new String[0]).resolve("server").resolve("solr").resolve(SOLR_XML_FILE);
            }
            log.info("Loading solr.xml from {}", (Object)configFile);
            InputStream inputStream = Files.newInputStream(configFile, new OpenOption[0]);
            try {
                nodeConfig = SolrXmlConfig.fromInputStream(solrHome, inputStream, substituteProps);
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SolrException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)exc);
                }
            }
            inputStream.close();
        }
        return nodeConfig;
    }

    public static NodeConfig fromString(Path solrHome, String xml) {
        return SolrXmlConfig.fromInputStream(solrHome, new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), new Properties());
    }

    public static NodeConfig fromInputStream(Path solrHome, InputStream is, Properties substituteProps) {
        return SolrXmlConfig.fromInputStream(solrHome, is, substituteProps, false);
    }

    public static NodeConfig fromInputStream(Path solrHome, InputStream is, Properties substituteProps, boolean fromZookeeper) {
        NodeConfig nodeConfig;
        SolrResourceLoader loader = new SolrResourceLoader(solrHome);
        if (substituteProps == null) {
            substituteProps = new Properties();
        }
        byte[] buf = IOUtils.toByteArray((InputStream)is);
        ByteArrayInputStream dup = new ByteArrayInputStream(buf);
        try {
            XmlConfigFile config = new XmlConfigFile(loader, null, new InputSource(dup), null, substituteProps);
            nodeConfig = SolrXmlConfig.fromConfig(solrHome, config, fromZookeeper);
        }
        catch (Throwable throwable) {
            try {
                try {
                    dup.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SolrException exc) {
                throw exc;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
        }
        dup.close();
        return nodeConfig;
    }

    public static NodeConfig fromSolrHome(Path solrHome, Properties substituteProps) {
        return SolrXmlConfig.fromFile(solrHome, solrHome.resolve(SOLR_XML_FILE), substituteProps);
    }

    private static void checkForIllegalConfig(XmlConfigFile config) {
        SolrXmlConfig.failIfFound(config, "solr/@coreLoadThreads");
        SolrXmlConfig.failIfFound(config, "solr/@persistent");
        SolrXmlConfig.failIfFound(config, "solr/@sharedLib");
        SolrXmlConfig.failIfFound(config, "solr/@zkHost");
        SolrXmlConfig.failIfFound(config, "solr/cores");
        SolrXmlConfig.assertSingleInstance("solrcloud", config);
        SolrXmlConfig.assertSingleInstance("logging", config);
        SolrXmlConfig.assertSingleInstance("logging/watcher", config);
        SolrXmlConfig.assertSingleInstance("backup", config);
    }

    private static void assertSingleInstance(String section, XmlConfigFile config) {
        if (config.getNodeList("/solr/" + section, false).getLength() > 1) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple instances of " + section + " section found in solr.xml");
        }
    }

    private static void failIfFound(XmlConfigFile config, String xPath) {
        if (config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + "\n. Please upgrade your solr.xml: https://solr.apache.org/guide/format-of-solr-xml.html");
        }
    }

    private static Properties loadProperties(XmlConfigFile config) {
        try {
            Node node = ((NodeList)config.evaluate("solr", XPathConstants.NODESET)).item(0);
            XPath xpath = config.getXPath();
            NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
            Properties properties = new Properties(config.getSubstituteProperties());
            for (int i = 0; i < props.getLength(); ++i) {
                Node prop = props.item(i);
                properties.setProperty(DOMUtil.getAttr((Node)prop, (String)"name"), PropertiesUtil.substituteProperty((String)DOMUtil.getAttr((Node)prop, (String)"value"), null));
            }
            return properties;
        }
        catch (XPathExpressionException e) {
            log.warn("Error parsing solr.xml: ", (Throwable)e);
            return null;
        }
    }

    private static NamedList<Object> readNodeListAsNamedList(XmlConfigFile config, String path, String section) {
        NodeList nodes = config.getNodeList(path, false);
        if (nodes == null) {
            return null;
        }
        return SolrXmlConfig.checkForDuplicates(section, (NamedList<Object>)DOMUtil.nodesToNamedList((NodeList)nodes));
    }

    private static NamedList<Object> checkForDuplicates(String section, NamedList<Object> nl) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry entry : nl) {
            if (keys.add((String)entry.getKey())) continue;
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section of solr.xml contains duplicated '" + (String)entry.getKey() + "'");
        }
        return nl;
    }

    private static int parseInt(String field, String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error parsing '" + field + "', value '" + value + "' cannot be parsed as int");
        }
    }

    private static NodeConfig fillSolrSection(NodeConfig.NodeConfigBuilder builder, NamedList<Object> nl) {
        block42: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "adminHandler": {
                    builder.setCoreAdminHandlerClass(value);
                    continue block42;
                }
                case "collectionsHandler": {
                    builder.setCollectionsAdminHandlerClass(value);
                    continue block42;
                }
                case "healthCheckHandler": {
                    builder.setHealthCheckHandlerClass(value);
                    continue block42;
                }
                case "infoHandler": {
                    builder.setInfoHandlerClass(value);
                    continue block42;
                }
                case "configSetsHandler": {
                    builder.setConfigSetsHandlerClass(value);
                    continue block42;
                }
                case "configSetService": {
                    builder.setConfigSetServiceClass(value);
                    continue block42;
                }
                case "coreRootDirectory": {
                    builder.setCoreRootDirectory(value);
                    continue block42;
                }
                case "solrDataHome": {
                    builder.setSolrDataHome(value);
                    continue block42;
                }
                case "maxBooleanClauses": {
                    builder.setBooleanQueryMaxClauseCount(SolrXmlConfig.parseInt(name, value));
                    continue block42;
                }
                case "managementPath": {
                    builder.setManagementPath(value);
                    continue block42;
                }
                case "sharedLib": {
                    builder.setSharedLibDirectory(value);
                    continue block42;
                }
                case "modules": {
                    builder.setModules(value);
                    continue block42;
                }
                case "allowPaths": {
                    builder.setAllowPaths(SolrXmlConfig.separatePaths(value));
                    continue block42;
                }
                case "configSetBaseDir": {
                    builder.setConfigSetBaseDirectory(value);
                    continue block42;
                }
                case "shareSchema": {
                    builder.setUseSchemaCache(Boolean.parseBoolean(value));
                    continue block42;
                }
                case "coreLoadThreads": {
                    builder.setCoreLoadThreads(SolrXmlConfig.parseInt(name, value));
                    continue block42;
                }
                case "replayUpdatesThreads": {
                    builder.setReplayUpdatesThreads(SolrXmlConfig.parseInt(name, value));
                    continue block42;
                }
                case "transientCacheSize": {
                    builder.setTransientCacheSize(SolrXmlConfig.parseInt(name, value));
                    continue block42;
                }
                case "allowUrls": {
                    builder.setAllowUrls(SolrXmlConfig.separateStrings(value));
                    continue block42;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration value in solr.xml: " + name);
        }
        return builder.build();
    }

    private static List<String> separateStrings(String commaSeparatedString) {
        if (Strings.isNullOrEmpty((String)commaSeparatedString)) {
            return Collections.emptyList();
        }
        return Arrays.asList(COMMA_SEPARATED_PATTERN.split(commaSeparatedString));
    }

    private static Set<Path> separatePaths(String commaSeparatedString) {
        if (Strings.isNullOrEmpty((String)commaSeparatedString)) {
            return Collections.emptySet();
        }
        String[] pathStrings = COMMA_SEPARATED_PATTERN.split(commaSeparatedString);
        SolrPaths.AllowPathBuilder allowPathBuilder = new SolrPaths.AllowPathBuilder();
        for (String p : pathStrings) {
            allowPathBuilder.addPath(p);
        }
        return allowPathBuilder.build();
    }

    private static UpdateShardHandlerConfig loadUpdateConfig(NamedList<Object> nl, boolean alwaysDefine) {
        Object mrt;
        Object mns;
        Object dct;
        Object dst;
        Object mucph;
        if (nl == null && !alwaysDefine) {
            return null;
        }
        if (nl == null) {
            return UpdateShardHandlerConfig.DEFAULT;
        }
        boolean defined = false;
        int maxUpdateConnections = 100000;
        int maxUpdateConnectionsPerHost = 100000;
        int distributedSocketTimeout = 600000;
        int distributedConnectionTimeout = 60000;
        String metricNameStrategy = "queryLessURLAndMethod";
        int maxRecoveryThreads = -1;
        Object muc = nl.remove("maxUpdateConnections");
        if (muc != null) {
            maxUpdateConnections = SolrXmlConfig.parseInt("maxUpdateConnections", muc.toString());
            defined = true;
        }
        if ((mucph = nl.remove("maxUpdateConnectionsPerHost")) != null) {
            maxUpdateConnectionsPerHost = SolrXmlConfig.parseInt("maxUpdateConnectionsPerHost", mucph.toString());
            defined = true;
        }
        if ((dst = nl.remove("distribUpdateSoTimeout")) != null) {
            distributedSocketTimeout = SolrXmlConfig.parseInt("distribUpdateSoTimeout", dst.toString());
            defined = true;
        }
        if ((dct = nl.remove("distribUpdateConnTimeout")) != null) {
            distributedConnectionTimeout = SolrXmlConfig.parseInt("distribUpdateConnTimeout", dct.toString());
            defined = true;
        }
        if ((mns = nl.remove("metricNameStrategy")) != null) {
            metricNameStrategy = mns.toString();
            defined = true;
        }
        if ((mrt = nl.remove("maxRecoveryThreads")) != null) {
            maxRecoveryThreads = SolrXmlConfig.parseInt("maxRecoveryThreads", mrt.toString());
            defined = true;
        }
        if (!defined && !alwaysDefine) {
            return null;
        }
        return new UpdateShardHandlerConfig(maxUpdateConnections, maxUpdateConnectionsPerHost, distributedSocketTimeout, distributedConnectionTimeout, metricNameStrategy, maxRecoveryThreads);
    }

    private static String removeValue(NamedList<Object> nl, String key) {
        Object value = nl.remove(key);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private static String required(String section, String key, String value) {
        if (value != null) {
            return value;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, section + " section missing required entry '" + key + "'");
    }

    private static CloudConfig fillSolrCloudSection(NamedList<Object> nl, XmlConfigFile config, String defaultZkHost) {
        int hostPort = SolrXmlConfig.parseInt("hostPort", SolrXmlConfig.required("solrcloud", "hostPort", SolrXmlConfig.removeValue(nl, "hostPort")));
        if (hostPort <= 0) {
            hostPort = SolrXmlConfig.parseInt("jetty.port", System.getProperty("jetty.port", "8983"));
        }
        String hostName = SolrXmlConfig.required("solrcloud", "host", SolrXmlConfig.removeValue(nl, "host"));
        String hostContext = SolrXmlConfig.required("solrcloud", "hostContext", SolrXmlConfig.removeValue(nl, "hostContext"));
        CloudConfig.CloudConfigBuilder builder = new CloudConfig.CloudConfigBuilder(hostName, hostPort, hostContext);
        builder.setZkHost(defaultZkHost);
        block30: for (Map.Entry entry : nl) {
            String name = (String)entry.getKey();
            if (entry.getValue() == null) continue;
            String value = entry.getValue().toString();
            switch (name) {
                case "leaderVoteWait": {
                    builder.setLeaderVoteWait(SolrXmlConfig.parseInt(name, value));
                    continue block30;
                }
                case "leaderConflictResolveWait": {
                    builder.setLeaderConflictResolveWait(SolrXmlConfig.parseInt(name, value));
                    continue block30;
                }
                case "zkClientTimeout": {
                    builder.setZkClientTimeout(SolrXmlConfig.parseInt(name, value));
                    continue block30;
                }
                case "zkHost": {
                    builder.setZkHost(value);
                    continue block30;
                }
                case "genericCoreNodeNames": {
                    builder.setUseGenericCoreNames(Boolean.parseBoolean(value));
                    continue block30;
                }
                case "zkACLProvider": {
                    builder.setZkACLProviderClass(value);
                    continue block30;
                }
                case "zkCredentialsProvider": {
                    builder.setZkCredentialsProviderClass(value);
                    continue block30;
                }
                case "createCollectionWaitTimeTillActive": {
                    builder.setCreateCollectionWaitTimeTillActive(SolrXmlConfig.parseInt(name, value));
                    continue block30;
                }
                case "createCollectionCheckLeaderActive": {
                    builder.setCreateCollectionCheckLeaderActive(Boolean.parseBoolean(value));
                    continue block30;
                }
                case "pkiHandlerPrivateKeyPath": {
                    builder.setPkiHandlerPrivateKeyPath(value);
                    continue block30;
                }
                case "pkiHandlerPublicKeyPath": {
                    builder.setPkiHandlerPublicKeyPath(value);
                    continue block30;
                }
                case "distributedClusterStateUpdates": {
                    builder.setUseDistributedClusterStateUpdates(Boolean.parseBoolean(value));
                    continue block30;
                }
                case "distributedCollectionConfigSetExecution": {
                    builder.setUseDistributedCollectionConfigSetExecution(Boolean.parseBoolean(value));
                    continue block30;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown configuration parameter in <solrcloud> section of solr.xml: " + name);
        }
        return builder.build();
    }

    private static LogWatcherConfig loadLogWatcherConfig(XmlConfigFile config, String loggingPath, String watcherPath) {
        String value;
        String name;
        String loggingClass = null;
        boolean enabled = true;
        int watcherQueueSize = 50;
        String watcherThreshold = null;
        block16: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, loggingPath, "<logging>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "class": {
                    loggingClass = value;
                    continue block16;
                }
                case "enabled": {
                    enabled = Boolean.parseBoolean(value);
                    continue block16;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        block17: for (Map.Entry entry : SolrXmlConfig.readNodeListAsNamedList(config, watcherPath, "<watcher>")) {
            name = (String)entry.getKey();
            value = entry.getValue().toString();
            switch (name) {
                case "size": {
                    watcherQueueSize = SolrXmlConfig.parseInt(name, value);
                    continue block17;
                }
                case "threshold": {
                    watcherThreshold = value;
                    continue block17;
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown value in logwatcher config: " + name);
        }
        return new LogWatcherConfig(enabled, loggingClass, watcherThreshold, watcherQueueSize);
    }

    private static PluginInfo getShardHandlerFactoryPluginInfo(XmlConfigFile config) {
        Node node = config.getNode("solr/shardHandlerFactory", false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }

    private static PluginInfo[] getBackupRepositoryPluginInfos(XmlConfigFile config) {
        NodeList nodes = (NodeList)config.evaluate("solr/backup/repository", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return new PluginInfo[0];
        }
        PluginInfo[] configs = new PluginInfo[nodes.getLength()];
        for (int i = 0; i < nodes.getLength(); ++i) {
            configs[i] = new PluginInfo(nodes.item(i), "BackupRepositoryFactory", true, true);
        }
        return configs;
    }

    private static MetricsConfig getMetricsConfig(XmlConfigFile config) {
        MetricsConfig.MetricsConfigBuilder builder = new MetricsConfig.MetricsConfigBuilder();
        Node node = config.getNode("solr/metrics", false);
        boolean enabled = true;
        if (node != null) {
            enabled = Boolean.parseBoolean(DOMUtil.getAttrOrDefault((Node)node, (String)"enabled", (String)"true"));
        }
        builder.setEnabled(enabled);
        if (!enabled) {
            log.info("Metrics collection is disabled.");
            return builder.build();
        }
        node = config.getNode("solr/metrics/suppliers/counter", false);
        if (node != null) {
            builder = builder.setCounterSupplier(new PluginInfo(node, "counterSupplier", false, false));
        }
        if ((node = config.getNode("solr/metrics/suppliers/meter", false)) != null) {
            builder = builder.setMeterSupplier(new PluginInfo(node, "meterSupplier", false, false));
        }
        if ((node = config.getNode("solr/metrics/suppliers/timer", false)) != null) {
            builder = builder.setTimerSupplier(new PluginInfo(node, "timerSupplier", false, false));
        }
        if ((node = config.getNode("solr/metrics/suppliers/histogram", false)) != null) {
            builder = builder.setHistogramSupplier(new PluginInfo(node, "histogramSupplier", false, false));
        }
        if ((node = config.getNode("solr/metrics/missingValues", false)) != null) {
            NamedList missingValues = DOMUtil.childNodesToNamedList((Node)node);
            builder.setNullNumber(SolrXmlConfig.decodeNullValue(missingValues.get("nullNumber")));
            builder.setNotANumber(SolrXmlConfig.decodeNullValue(missingValues.get("notANumber")));
            builder.setNullString(SolrXmlConfig.decodeNullValue(missingValues.get("nullString")));
            builder.setNullObject(SolrXmlConfig.decodeNullValue(missingValues.get("nullObject")));
        }
        PluginInfo[] reporterPlugins = SolrXmlConfig.getMetricReporterPluginInfos(config);
        Set<String> hiddenSysProps = SolrXmlConfig.getHiddenSysProps(config);
        return builder.setMetricReporterPlugins(reporterPlugins).setHiddenSysProps(hiddenSysProps).build();
    }

    private static Object decodeNullValue(Object o) {
        String str;
        if (o instanceof String && !(str = (String)o).isBlank() && (str.startsWith("{") || str.startsWith("["))) {
            try {
                o = Utils.fromJSONString((String)((String)o));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return o;
    }

    private static PluginInfo[] getMetricReporterPluginInfos(XmlConfigFile config) {
        MBeanServer mBeanServer;
        NodeList nodes = (NodeList)config.evaluate("solr/metrics/reporter", XPathConstants.NODESET);
        ArrayList<PluginInfo> configs = new ArrayList<PluginInfo>();
        boolean hasJmxReporter = false;
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                PluginInfo info = new PluginInfo(nodes.item(i), "SolrMetricReporter", true, false);
                String clazz = info.className;
                if (clazz != null && clazz.equals(SolrJmxReporter.class.getName())) {
                    hasJmxReporter = true;
                }
                configs.add(info);
            }
        }
        if ((mBeanServer = JmxUtil.findFirstMBeanServer()) != null && !hasJmxReporter) {
            log.debug("MBean server found: {}, but no JMX reporters were configured - adding default JMX reporter.", (Object)mBeanServer);
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("name", "default");
            attributes.put("class", SolrJmxReporter.class.getName());
            PluginInfo defaultPlugin = new PluginInfo("reporter", attributes);
            configs.add(defaultPlugin);
        }
        return configs.toArray(new PluginInfo[configs.size()]);
    }

    private static Set<String> getHiddenSysProps(XmlConfigFile config) {
        NodeList nodes = (NodeList)config.evaluate("solr/metrics/hiddenSysProps/str", XPathConstants.NODESET);
        if (nodes == null || nodes.getLength() == 0) {
            return NodeConfig.NodeConfigBuilder.DEFAULT_HIDDEN_SYS_PROPS;
        }
        HashSet<String> props = new HashSet<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String prop = DOMUtil.getText((Node)nodes.item(i));
            if (prop == null || prop.trim().isEmpty()) continue;
            props.add(prop.trim());
        }
        if (props.isEmpty()) {
            return NodeConfig.NodeConfigBuilder.DEFAULT_HIDDEN_SYS_PROPS;
        }
        return props;
    }

    private static PluginInfo getTransientCoreCacheFactoryPluginInfo(XmlConfigFile config) {
        Node node = config.getNode("solr/transientCoreCacheFactory", false);
        return node == null ? null : new PluginInfo(node, "transientCoreCacheFactory", false, true);
    }

    private static PluginInfo getTracerPluginInfo(XmlConfigFile config) {
        Node node = config.getNode("solr/tracerConfig", false);
        return node == null ? null : new PluginInfo(node, "tracerConfig", false, true);
    }
}

