/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cluster.placement.DeleteCollectionRequest;
import org.apache.solr.cluster.placement.DeleteReplicasRequest;
import org.apache.solr.cluster.placement.PlacementException;
import org.apache.solr.cluster.placement.PlacementPlan;
import org.apache.solr.cluster.placement.PlacementPlugin;
import org.apache.solr.cluster.placement.PlacementRequest;
import org.apache.solr.cluster.placement.impl.ModificationRequestImpl;
import org.apache.solr.cluster.placement.impl.PlacementRequestImpl;
import org.apache.solr.cluster.placement.impl.ReplicaPlacementImpl;
import org.apache.solr.cluster.placement.impl.SimplePlacementContextImpl;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;

public class PlacementPluginAssignStrategy
implements Assign.AssignStrategy {
    private final PlacementPlugin plugin;

    public PlacementPluginAssignStrategy(PlacementPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public List<ReplicaPosition> assign(SolrCloudManager solrCloudManager, List<Assign.AssignRequest> assignRequests) throws Assign.AssignmentException, IOException, InterruptedException {
        SimplePlacementContextImpl placementContext = new SimplePlacementContextImpl(solrCloudManager);
        ArrayList<PlacementRequest> placementRequests = new ArrayList<PlacementRequest>(assignRequests.size());
        for (Assign.AssignRequest assignRequest : assignRequests) {
            placementRequests.add(PlacementRequestImpl.toPlacementRequest(placementContext.getCluster(), placementContext.getCluster().getCollection(assignRequest.collectionName), assignRequest));
        }
        ArrayList<ReplicaPosition> replicaPositions = new ArrayList<ReplicaPosition>();
        try {
            List<PlacementPlan> placementPlans = this.plugin.computePlacements(placementRequests, placementContext);
            if (placementPlans != null) {
                for (PlacementPlan placementPlan : placementPlans) {
                    replicaPositions.addAll(ReplicaPlacementImpl.toReplicaPositions(placementPlan.getRequest().getCollection().getName(), placementPlan.getReplicaPlacements()));
                }
            }
        }
        catch (PlacementException pe) {
            throw new Assign.AssignmentException(pe);
        }
        return replicaPositions;
    }

    @Override
    public void verifyDeleteCollection(SolrCloudManager solrCloudManager, DocCollection collection) throws Assign.AssignmentException, IOException, InterruptedException {
        SimplePlacementContextImpl placementContext = new SimplePlacementContextImpl(solrCloudManager);
        DeleteCollectionRequest modificationRequest = ModificationRequestImpl.createDeleteCollectionRequest(collection);
        try {
            this.plugin.verifyAllowedModification(modificationRequest, placementContext);
        }
        catch (PlacementException pe) {
            throw new Assign.AssignmentException(pe);
        }
    }

    @Override
    public void verifyDeleteReplicas(SolrCloudManager solrCloudManager, DocCollection collection, String shardId, Set<Replica> replicas) throws Assign.AssignmentException, IOException, InterruptedException {
        SimplePlacementContextImpl placementContext = new SimplePlacementContextImpl(solrCloudManager);
        DeleteReplicasRequest modificationRequest = ModificationRequestImpl.createDeleteReplicasRequest(collection, shardId, replicas);
        try {
            this.plugin.verifyAllowedModification(modificationRequest, placementContext);
        }
        catch (PlacementException pe) {
            throw new Assign.AssignmentException(pe);
        }
    }
}

