/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.ExclusiveSliceProperty;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.cloud.overseer.ClusterStateMutator;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.NodeMutator;
import org.apache.solr.cloud.overseer.ReplicaMutator;
import org.apache.solr.cloud.overseer.SliceMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.PerReplicaStatesOps;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedClusterStateUpdater {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean useDistributedStateUpdate;

    public DistributedClusterStateUpdater(boolean useDistributedStateUpdate) {
        this.useDistributedStateUpdate = useDistributedStateUpdate;
        if (log.isInfoEnabled()) {
            log.info("Creating DistributedClusterStateUpdater with useDistributedStateUpdate=" + useDistributedStateUpdate + ". Solr will be using " + (useDistributedStateUpdate ? "distributed" : "Overseer based") + " cluster state updates.");
        }
    }

    public StateChangeRecorder createStateChangeRecorder(String collectionName, boolean isCollectionCreation) {
        if (!this.useDistributedStateUpdate) {
            throw new IllegalStateException("Not expecting to create instances of StateChangeRecorder when not using distributed state update");
        }
        return new StateChangeRecorder(collectionName, isCollectionCreation);
    }

    public void doSingleStateUpdate(MutatingCommand command, ZkNodeProps message, SolrCloudManager scm, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        if (!this.useDistributedStateUpdate) {
            throw new IllegalStateException("Not expecting to execute doSingleStateUpdate when not using distributed state update");
        }
        String collectionName = command.getCollectionName(message);
        StateChangeRecorder scr = new StateChangeRecorder(collectionName, command.isCollectionCreation());
        scr.record(command, message);
        scr.executeStateUpdates(scm, zkStateReader);
    }

    public void executeNodeDownStateUpdate(String nodeName, ZkStateReader zkStateReader) {
        if (!this.useDistributedStateUpdate) {
            throw new IllegalStateException("Not expecting to execute executeNodeDownStateUpdate when not using distributed state update");
        }
        CollectionNodeDownChangeCalculator.executeNodeDownStateUpdate(nodeName, zkStateReader);
    }

    public boolean isDistributedStateUpdate() {
        return this.useDistributedStateUpdate;
    }

    private static class CollectionNodeDownChangeCalculator
    implements StateChangeCalculator {
        private final String collectionName;
        private final String nodeName;
        private ClusterState computedState = null;
        private List<PerReplicaStatesOps> replicaOpsList = null;

        public static void executeNodeDownStateUpdate(String nodeName, ZkStateReader zkStateReader) {
            log.debug("DownNode state change invoked for node: {}", (Object)nodeName);
            try {
                List collectionNames = zkStateReader.getZkClient().getChildren("/collections", null, true);
                for (String collectionName : collectionNames) {
                    CollectionNodeDownChangeCalculator collectionUpdater = new CollectionNodeDownChangeCalculator(collectionName, nodeName);
                    ZkUpdateApplicator.applyUpdate(zkStateReader, collectionUpdater);
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.error("Could not successfully process DOWNNODE, giving up", (Throwable)e);
            }
        }

        private CollectionNodeDownChangeCalculator(String collectionName, String nodeName) {
            this.collectionName = collectionName;
            this.nodeName = nodeName;
        }

        @Override
        public String getCollectionName() {
            return this.collectionName;
        }

        @Override
        public boolean isCollectionCreation() {
            return false;
        }

        @Override
        public void computeUpdates(ClusterState clusterState, SolrZkClient client) {
            Optional result;
            DocCollection docCollection = clusterState.getCollectionOrNull(this.collectionName);
            Optional<Object> optional = result = docCollection != null ? NodeMutator.computeCollectionUpdate(this.nodeName, this.collectionName, docCollection, client) : Optional.empty();
            if (docCollection == null) {
                log.warn("Processing DOWNNODE, collection " + this.collectionName + " disappeared during iteration");
            }
            if (result.isPresent()) {
                ZkWriteCommand zkcmd = (ZkWriteCommand)result.get();
                this.computedState = zkcmd != ZkStateWriter.NO_OP ? clusterState.copyWith(zkcmd.name, zkcmd.collection) : null;
                this.replicaOpsList = zkcmd.ops != null && zkcmd.ops.get() != null ? Collections.singletonList(zkcmd.ops) : null;
            } else {
                this.computedState = null;
                this.replicaOpsList = null;
            }
        }

        @Override
        public ClusterState getUpdatedClusterState() {
            return this.computedState;
        }

        @Override
        public List<PerReplicaStatesOps> getPerReplicaStatesOps() {
            return this.replicaOpsList;
        }
    }

    public static class StateChangeRecorder {
        final List<Pair<MutatingCommand, ZkNodeProps>> mutations;
        final String collectionName;
        final boolean isCollectionCreation;
        boolean creationCommandRecorded = false;

        private StateChangeRecorder(String collectionName, boolean isCollectionCreation) {
            if (collectionName == null) {
                String err = "Internal bug. collectionName=null (isCollectionCreation=" + isCollectionCreation + ")";
                log.error(err);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err);
            }
            this.mutations = new LinkedList<Pair<MutatingCommand, ZkNodeProps>>();
            this.collectionName = collectionName;
            this.isCollectionCreation = isCollectionCreation;
        }

        public void record(MutatingCommand command, ZkNodeProps message) {
            if (this.isCollectionCreation && !this.creationCommandRecorded) {
                if (!command.isCollectionCreation()) {
                    String err = "Internal bug. Creation of collection " + this.collectionName + " unexpected command " + command.name();
                    log.error(err);
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err);
                }
                this.creationCommandRecorded = true;
            } else if (command.isCollectionCreation()) {
                String err = "Internal bug. Creation of collection " + this.collectionName + " unexpected command " + command.name() + " (isCollectionCreation=" + this.isCollectionCreation + ", creationCommandRecorded=" + this.creationCommandRecorded + ")";
                log.error(err);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err);
            }
            if (!this.collectionName.equals(command.getCollectionName(message))) {
                String err = "Internal bug. State change for collection " + this.collectionName + " received command " + command + " for collection " + command.getCollectionName(message);
                log.error(err);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err);
            }
            this.mutations.add((Pair<MutatingCommand, ZkNodeProps>)new Pair((Object)command, (Object)message));
        }

        public void executeStateUpdates(SolrCloudManager scm, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
            if (log.isDebugEnabled()) {
                log.debug("Executing updates for collection " + this.collectionName + ", is creation=" + this.isCollectionCreation + ", " + this.mutations.size() + " recorded mutations.", (Throwable)new Exception("StackTraceOnly"));
            }
            if (this.mutations.isEmpty()) {
                String err = "Internal bug. Unexpected empty set of mutations to apply for collection " + this.collectionName;
                log.error(err);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, err);
            }
            RecordedMutationsPlayer mutationPlayer = new RecordedMutationsPlayer(scm, this.collectionName, this.isCollectionCreation, this.mutations);
            ZkUpdateApplicator.applyUpdate(zkStateReader, mutationPlayer);
        }

        private static class RecordedMutationsPlayer
        implements StateChangeCalculator {
            private final SolrCloudManager scm;
            private final String collectionName;
            private final boolean isCollectionCreation;
            final List<Pair<MutatingCommand, ZkNodeProps>> mutations;
            private ClusterState computedState = null;
            private List<PerReplicaStatesOps> replicaOpsList = null;

            RecordedMutationsPlayer(SolrCloudManager scm, String collectionName, boolean isCollectionCreation, List<Pair<MutatingCommand, ZkNodeProps>> mutations) {
                this.scm = scm;
                this.collectionName = collectionName;
                this.isCollectionCreation = isCollectionCreation;
                this.mutations = mutations;
            }

            @Override
            public String getCollectionName() {
                return this.collectionName;
            }

            @Override
            public boolean isCollectionCreation() {
                return this.isCollectionCreation;
            }

            @Override
            public void computeUpdates(ClusterState clusterState, SolrZkClient client) {
                boolean hasJsonUpdates = false;
                LinkedList<PerReplicaStatesOps> perReplicaStateOps = new LinkedList<PerReplicaStatesOps>();
                for (Pair<MutatingCommand, ZkNodeProps> mutation : this.mutations) {
                    MutatingCommand mutatingCommand = (MutatingCommand)((Object)mutation.first());
                    ZkNodeProps message = (ZkNodeProps)mutation.second();
                    try {
                        ZkWriteCommand zkcmd = mutatingCommand.buildWriteCommand(this.scm, clusterState, message);
                        if (zkcmd != ZkStateWriter.NO_OP) {
                            hasJsonUpdates = true;
                            clusterState = clusterState.copyWith(zkcmd.name, zkcmd.collection);
                        }
                        if (zkcmd.ops == null || zkcmd.ops.get() == null) continue;
                        perReplicaStateOps.add(zkcmd.ops);
                    }
                    catch (Exception e) {
                        log.error("Distributed cluster state update could not process the current clusterstate state update message, skipping the message: {}", (Object)message, (Object)e);
                    }
                }
                this.computedState = hasJsonUpdates ? clusterState : null;
                this.replicaOpsList = perReplicaStateOps.isEmpty() ? null : perReplicaStateOps;
            }

            @Override
            public ClusterState getUpdatedClusterState() {
                return this.computedState;
            }

            @Override
            public List<PerReplicaStatesOps> getPerReplicaStatesOps() {
                return this.replicaOpsList;
            }
        }
    }

    private static class ZkUpdateApplicator {
        public static final int CAS_MAX_ATTEMPTS = 50;
        private final ZkStateReader zkStateReader;
        private final StateChangeCalculator updater;

        static void applyUpdate(ZkStateReader zkStateReader, StateChangeCalculator updater) throws KeeperException, InterruptedException {
            ZkUpdateApplicator zua = new ZkUpdateApplicator(zkStateReader, updater);
            zua.applyUpdate();
        }

        private ZkUpdateApplicator(ZkStateReader zkStateReader, StateChangeCalculator updater) {
            this.zkStateReader = zkStateReader;
            this.updater = updater;
        }

        private void applyUpdate() throws KeeperException, InterruptedException {
            Set liveNodes = Collections.emptySet();
            boolean firstAttempt = true;
            PerReplicaStates fetchedPerReplicaStates = null;
            for (int attempt = 0; attempt < 50; ++attempt) {
                ClusterState initialClusterState = this.updater.isCollectionCreation() ? new ClusterState(liveNodes, Collections.emptyMap()) : this.fetchStateForCollection();
                this.updater.computeUpdates(initialClusterState, this.zkStateReader.getZkClient());
                ClusterState updatedState = this.updater.getUpdatedClusterState();
                List<PerReplicaStatesOps> allStatesOps = this.updater.getPerReplicaStatesOps();
                if (firstAttempt && allStatesOps != null) {
                    firstAttempt = false;
                    String prsParentNode = ZkStateReader.getCollectionPath((String)this.updater.getCollectionName());
                    for (PerReplicaStatesOps prso : allStatesOps) {
                        prso.persist(prsParentNode, this.zkStateReader.getZkClient());
                    }
                }
                if (updatedState == null) {
                    return;
                }
                DocCollection docCollection = updatedState.getCollectionOrNull(this.updater.getCollectionName(), true);
                if (allStatesOps != null && docCollection != null) {
                    fetchedPerReplicaStates = PerReplicaStates.fetch((String)docCollection.getZNode(), (SolrZkClient)this.zkStateReader.getZkClient(), fetchedPerReplicaStates);
                    updatedState = updatedState.copyWith(this.updater.getCollectionName(), docCollection.copyWith(fetchedPerReplicaStates));
                }
                try {
                    this.doStateDotJsonCasUpdate(updatedState);
                    return;
                }
                catch (KeeperException.BadVersionException bve) {
                    if (this.updater.isCollectionCreation()) {
                        throw bve;
                    }
                    Thread.sleep(CollectionHandlingUtils.RANDOM.nextInt(attempt < 13 ? 1 << attempt : 8192));
                    continue;
                }
            }
            throw new KeeperException.BadVersionException(ZkStateReader.getCollectionPath((String)this.updater.getCollectionName()));
        }

        private void doStateDotJsonCasUpdate(ClusterState updatedState) throws KeeperException, InterruptedException {
            String jsonPath = ZkStateReader.getCollectionPath((String)this.updater.getCollectionName());
            if (!updatedState.hasCollection(this.updater.getCollectionName())) {
                log.debug("going to recursively delete state.json at {}", (Object)jsonPath);
                this.zkStateReader.getZkClient().clean(jsonPath);
            } else {
                DocCollection collection = updatedState.getCollection(this.updater.getCollectionName());
                byte[] stateJson = Utils.toJSON(Collections.singletonMap(this.updater.getCollectionName(), collection));
                if (this.updater.isCollectionCreation()) {
                    log.debug("going to create collection {}", (Object)jsonPath);
                    this.zkStateReader.getZkClient().create(jsonPath, stateJson, CreateMode.PERSISTENT, true);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("going to update collection {} version: {}", (Object)jsonPath, (Object)collection.getZNodeVersion());
                    }
                    this.zkStateReader.getZkClient().setData(jsonPath, stateJson, collection.getZNodeVersion(), true);
                }
            }
        }

        private ClusterState fetchStateForCollection() throws KeeperException, InterruptedException {
            String collectionStatePath = ZkStateReader.getCollectionPath((String)this.updater.getCollectionName());
            Stat stat = new Stat();
            byte[] data = this.zkStateReader.getZkClient().getData(collectionStatePath, null, stat, true);
            ClusterState clusterState = ClusterState.createFromJsonSupportingLegacyConfigName((int)stat.getVersion(), (byte[])data, Collections.emptySet(), (String)this.updater.getCollectionName(), (SolrZkClient)this.zkStateReader.getZkClient());
            return clusterState;
        }
    }

    static interface StateChangeCalculator {
        public String getCollectionName();

        public boolean isCollectionCreation();

        public void computeUpdates(ClusterState var1, SolrZkClient var2);

        public ClusterState getUpdatedClusterState();

        public List<PerReplicaStatesOps> getPerReplicaStatesOps();
    }

    public static enum MutatingCommand {
        BalanceShardsUnique(CollectionParams.CollectionAction.BALANCESHARDUNIQUE, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                ExclusiveSliceProperty dProp = new ExclusiveSliceProperty(cs, message);
                if (dProp.balanceProperty()) {
                    return new ZkWriteCommand(this.getCollectionName(message), dProp.getDocCollection());
                }
                return ZkStateWriter.NO_OP;
            }
        }
        ,
        ClusterCreateCollection(CollectionParams.CollectionAction.CREATE, "name"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new ClusterStateMutator(scm).createCollection(cs, message);
            }

            @Override
            public boolean isCollectionCreation() {
                return true;
            }
        }
        ,
        ClusterDeleteCollection(CollectionParams.CollectionAction.DELETE, "name"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new ClusterStateMutator(scm).deleteCollection(cs, message);
            }
        }
        ,
        CollectionDeleteShard(CollectionParams.CollectionAction.DELETESHARD, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new CollectionMutator(scm).deleteShard(cs, message);
            }
        }
        ,
        CollectionModifyCollection(CollectionParams.CollectionAction.MODIFYCOLLECTION, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new CollectionMutator(scm).modifyCollection(cs, message);
            }
        }
        ,
        CollectionCreateShard(CollectionParams.CollectionAction.CREATESHARD, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new CollectionMutator(scm).createShard(cs, message);
            }
        }
        ,
        ReplicaAddReplicaProperty(CollectionParams.CollectionAction.ADDREPLICAPROP, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new ReplicaMutator(scm).addReplicaProperty(cs, message);
            }
        }
        ,
        ReplicaDeleteReplicaProperty(CollectionParams.CollectionAction.DELETEREPLICAPROP, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new ReplicaMutator(scm).deleteReplicaProperty(cs, message);
            }
        }
        ,
        ReplicaSetState(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new ReplicaMutator(scm).setState(cs, message);
            }
        }
        ,
        SliceAddReplica(CollectionParams.CollectionAction.ADDREPLICA, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).addReplica(cs, message);
            }
        }
        ,
        SliceAddRoutingRule(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).addRoutingRule(cs, message);
            }
        }
        ,
        SliceRemoveReplica(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).removeReplica(cs, message);
            }
        }
        ,
        SliceRemoveRoutingRule(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).removeRoutingRule(cs, message);
            }
        }
        ,
        SliceSetShardLeader(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).setShardLeader(cs, message);
            }
        }
        ,
        SliceUpdateShardState(null, "collection"){

            @Override
            public ZkWriteCommand buildWriteCommand(SolrCloudManager scm, ClusterState cs, ZkNodeProps message) {
                return new SliceMutator(scm).updateShardState(cs, message);
            }
        };

        private static final EnumMap<CollectionParams.CollectionAction, MutatingCommand> actionsToCommands;
        private final CollectionParams.CollectionAction collectionAction;
        private final String collectionNameParamName;

        private MutatingCommand(CollectionParams.CollectionAction collectionAction, String collectionNameParamName) {
            this.collectionAction = collectionAction;
            this.collectionNameParamName = collectionNameParamName;
        }

        public abstract ZkWriteCommand buildWriteCommand(SolrCloudManager var1, ClusterState var2, ZkNodeProps var3);

        public String getCollectionName(ZkNodeProps message) {
            return message.getStr(this.collectionNameParamName);
        }

        public static MutatingCommand getCommandFor(CollectionParams.CollectionAction collectionAction) {
            return actionsToCommands.get(collectionAction);
        }

        public boolean isCollectionCreation() {
            return false;
        }

        static {
            actionsToCommands = new EnumMap(CollectionParams.CollectionAction.class);
            for (MutatingCommand mc : MutatingCommand.values()) {
                if (mc.collectionAction == null) continue;
                actionsToCommands.put(mc.collectionAction, mc);
            }
        }
    }
}

