/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.modality.nlp.preprocess;

import ai.djl.modality.nlp.preprocess.TextProcessor;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TextCleaner
implements TextProcessor {
    private Function<Character, Boolean> condition;
    private char replace;

    public TextCleaner(Function<Character, Boolean> condition) {
        this.condition = condition;
    }

    public TextCleaner(Function<Character, Boolean> condition, char replace) {
        this.condition = condition;
        this.replace = replace;
    }

    private String cleanText(String text) {
        StringBuilder sb = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (this.condition.apply(Character.valueOf(c)).booleanValue()) {
                if (this.replace == '\u0000') continue;
                sb.append(this.replace);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public List<String> preprocess(List<String> tokens) {
        return tokens.stream().map(this::cleanText).collect(Collectors.toList());
    }
}

