/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import com.carrotsearch.hppc.IntByteHashMap;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.cursors.IntByteCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.util.Arrays;
import org.apache.solr.util.LongIterator;
import org.apache.solr.util.hll.BitUtil;
import org.apache.solr.util.hll.BitVector;
import org.apache.solr.util.hll.HLLMetadata;
import org.apache.solr.util.hll.HLLType;
import org.apache.solr.util.hll.HLLUtil;
import org.apache.solr.util.hll.IHLLMetadata;
import org.apache.solr.util.hll.ISchemaVersion;
import org.apache.solr.util.hll.IWordDeserializer;
import org.apache.solr.util.hll.IWordSerializer;
import org.apache.solr.util.hll.NumberUtil;
import org.apache.solr.util.hll.SerializationUtil;

public class HLL
implements Cloneable {
    public static final int MINIMUM_LOG2M_PARAM = 4;
    public static final int MAXIMUM_LOG2M_PARAM = 30;
    public static final int MINIMUM_REGWIDTH_PARAM = 1;
    public static final int MAXIMUM_REGWIDTH_PARAM = 8;
    public static final int MINIMUM_EXPTHRESH_PARAM = -1;
    public static final int MAXIMUM_EXPTHRESH_PARAM = 18;
    public static final int MAXIMUM_EXPLICIT_THRESHOLD = 131072;
    LongHashSet explicitStorage;
    IntByteHashMap sparseProbabilisticStorage;
    BitVector probabilisticStorage;
    private HLLType type;
    private final int log2m;
    private final int regwidth;
    private final boolean explicitOff;
    private final boolean explicitAuto;
    private final int explicitThreshold;
    private final int shortWordLength;
    private final boolean sparseOff;
    private final int sparseThreshold;
    private final int m;
    private final int mBitsMask;
    private final int valueMask;
    private final long pwMaxMask;
    private final double alphaMSquared;
    private final double smallEstimatorCutoff;
    private final double largeEstimatorCutoff;

    public HLL(int log2m, int regwidth, int expthresh, boolean sparseon, HLLType type) {
        this.log2m = log2m;
        if (log2m < 4 || log2m > 30) {
            throw new IllegalArgumentException("'log2m' must be at least 4 and at most 30 (was: " + log2m + ")");
        }
        this.regwidth = regwidth;
        if (regwidth < 1 || regwidth > 8) {
            throw new IllegalArgumentException("'regwidth' must be at least 1 and at most 8 (was: " + regwidth + ")");
        }
        this.m = 1 << log2m;
        this.mBitsMask = this.m - 1;
        this.valueMask = (1 << regwidth) - 1;
        this.pwMaxMask = HLLUtil.pwMaxMask(regwidth);
        this.alphaMSquared = HLLUtil.alphaMSquared(this.m);
        this.smallEstimatorCutoff = HLLUtil.smallEstimatorCutoff(this.m);
        this.largeEstimatorCutoff = HLLUtil.largeEstimatorCutoff(log2m, regwidth);
        if (expthresh == -1) {
            this.explicitAuto = true;
            this.explicitOff = false;
            long fullRepresentationSize = ((long)this.regwidth * (long)this.m + 7L) / 8L;
            int numLongs = (int)(fullRepresentationSize / 8L);
            this.explicitThreshold = numLongs > 131072 ? 131072 : numLongs;
        } else if (expthresh == 0) {
            this.explicitAuto = false;
            this.explicitOff = true;
            this.explicitThreshold = 0;
        } else if (expthresh > 0 && expthresh <= 18) {
            this.explicitAuto = false;
            this.explicitOff = false;
            this.explicitThreshold = 1 << expthresh - 1;
        } else {
            throw new IllegalArgumentException("'expthresh' must be at least -1 and at most 18 (was: " + expthresh + ")");
        }
        this.shortWordLength = regwidth + log2m;
        boolean bl = this.sparseOff = !sparseon;
        if (this.sparseOff) {
            this.sparseThreshold = 0;
        } else {
            int largestPow2LessThanCutoff = (int)NumberUtil.log2(this.m * this.regwidth / this.shortWordLength);
            this.sparseThreshold = 1 << largestPow2LessThanCutoff;
        }
        this.initializeStorage(type);
    }

    public HLL(int log2m, int regwidth) {
        this(log2m, regwidth, -1, true, HLLType.EMPTY);
    }

    HLL(int log2m, int regwidth, int explicitThreshold, int sparseThreshold, HLLType type) {
        this.log2m = log2m;
        if (log2m < 4 || log2m > 30) {
            throw new IllegalArgumentException("'log2m' must be at least 4 and at most 30 (was: " + log2m + ")");
        }
        this.regwidth = regwidth;
        if (regwidth < 1 || regwidth > 8) {
            throw new IllegalArgumentException("'regwidth' must be at least 1 and at most 8 (was: " + regwidth + ")");
        }
        this.m = 1 << log2m;
        this.mBitsMask = this.m - 1;
        this.valueMask = (1 << regwidth) - 1;
        this.pwMaxMask = HLLUtil.pwMaxMask(regwidth);
        this.alphaMSquared = HLLUtil.alphaMSquared(this.m);
        this.smallEstimatorCutoff = HLLUtil.smallEstimatorCutoff(this.m);
        this.largeEstimatorCutoff = HLLUtil.largeEstimatorCutoff(log2m, regwidth);
        this.explicitAuto = false;
        this.explicitOff = false;
        this.explicitThreshold = explicitThreshold;
        if (explicitThreshold < 1 || explicitThreshold > 131072) {
            throw new IllegalArgumentException("'explicitThreshold' must be at least 1 and at most 131072 (was: " + explicitThreshold + ")");
        }
        this.shortWordLength = regwidth + log2m;
        this.sparseOff = false;
        this.sparseThreshold = sparseThreshold;
        this.initializeStorage(type);
    }

    public HLLType getType() {
        return this.type;
    }

    public void addRaw(long rawValue) {
        switch (this.type) {
            case EMPTY: {
                if (this.explicitThreshold > 0) {
                    this.initializeStorage(HLLType.EXPLICIT);
                    this.explicitStorage.add(rawValue);
                } else if (!this.sparseOff) {
                    this.initializeStorage(HLLType.SPARSE);
                    this.addRawSparseProbabilistic(rawValue);
                } else {
                    this.initializeStorage(HLLType.FULL);
                    this.addRawProbabilistic(rawValue);
                }
                return;
            }
            case EXPLICIT: {
                this.explicitStorage.add(rawValue);
                if (this.explicitStorage.size() > this.explicitThreshold) {
                    if (!this.sparseOff) {
                        this.initializeStorage(HLLType.SPARSE);
                        for (LongCursor c : this.explicitStorage) {
                            this.addRawSparseProbabilistic(c.value);
                        }
                    } else {
                        this.initializeStorage(HLLType.FULL);
                        for (LongCursor c : this.explicitStorage) {
                            this.addRawProbabilistic(c.value);
                        }
                    }
                    this.explicitStorage = null;
                }
                return;
            }
            case SPARSE: {
                this.addRawSparseProbabilistic(rawValue);
                if (this.sparseProbabilisticStorage.size() > this.sparseThreshold) {
                    this.initializeStorage(HLLType.FULL);
                    for (IntByteCursor c : this.sparseProbabilisticStorage) {
                        int registerIndex = c.key;
                        byte registerValue = c.value;
                        this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
                    }
                    this.sparseProbabilisticStorage = null;
                }
                return;
            }
            case FULL: {
                this.addRawProbabilistic(rawValue);
                return;
            }
        }
        throw new RuntimeException("Unsupported HLL type " + this.type);
    }

    private void addRawSparseProbabilistic(long rawValue) {
        long substreamValue = rawValue >>> this.log2m;
        byte p_w = substreamValue == 0L ? (byte)0 : (byte)(1 + BitUtil.leastSignificantBit(substreamValue | this.pwMaxMask));
        if (p_w == 0) {
            return;
        }
        int j = (int)(rawValue & (long)this.mBitsMask);
        int index = this.sparseProbabilisticStorage.indexOf(j);
        byte currentValue = index >= 0 ? this.sparseProbabilisticStorage.indexGet(index) : (byte)0;
        if (p_w > currentValue) {
            this.sparseProbabilisticStorage.put(j, p_w);
        }
    }

    private void addRawProbabilistic(long rawValue) {
        long substreamValue = rawValue >>> this.log2m;
        byte p_w = substreamValue == 0L ? (byte)0 : (byte)(1 + BitUtil.leastSignificantBit(substreamValue | this.pwMaxMask));
        if (p_w == 0) {
            return;
        }
        int j = (int)(rawValue & (long)this.mBitsMask);
        this.probabilisticStorage.setMaxRegister(j, p_w);
    }

    private void initializeStorage(HLLType type) {
        this.type = type;
        switch (type) {
            case EMPTY: {
                break;
            }
            case EXPLICIT: {
                this.explicitStorage = new LongHashSet();
                break;
            }
            case SPARSE: {
                this.sparseProbabilisticStorage = new IntByteHashMap();
                break;
            }
            case FULL: {
                this.probabilisticStorage = new BitVector(this.regwidth, this.m);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HLL type " + type);
            }
        }
    }

    public long cardinality() {
        switch (this.type) {
            case EMPTY: {
                return 0L;
            }
            case EXPLICIT: {
                return this.explicitStorage.size();
            }
            case SPARSE: {
                return (long)Math.ceil(this.sparseProbabilisticAlgorithmCardinality());
            }
            case FULL: {
                return (long)Math.ceil(this.fullProbabilisticAlgorithmCardinality());
            }
        }
        throw new RuntimeException("Unsupported HLL type " + this.type);
    }

    double sparseProbabilisticAlgorithmCardinality() {
        int m = this.m;
        double sum = 0.0;
        int numberOfZeroes = 0;
        for (int j = 0; j < m; ++j) {
            long register = this.sparseProbabilisticStorage.containsKey(j) ? (long)this.sparseProbabilisticStorage.get(j) : 0L;
            sum += 1.0 / (double)(1L << (int)register);
            if (register != 0L) continue;
            ++numberOfZeroes;
        }
        double estimator = this.alphaMSquared / sum;
        if (numberOfZeroes != 0 && estimator < this.smallEstimatorCutoff) {
            return HLLUtil.smallEstimator(m, numberOfZeroes);
        }
        if (estimator <= this.largeEstimatorCutoff) {
            return estimator;
        }
        return HLLUtil.largeEstimator(this.log2m, this.regwidth, estimator);
    }

    double fullProbabilisticAlgorithmCardinality() {
        int m = this.m;
        double sum = 0.0;
        int numberOfZeroes = 0;
        LongIterator iterator = this.probabilisticStorage.registerIterator();
        while (iterator.hasNext()) {
            long register = iterator.next();
            sum += 1.0 / (double)(1L << (int)register);
            if (register != 0L) continue;
            ++numberOfZeroes;
        }
        double estimator = this.alphaMSquared / sum;
        if (numberOfZeroes != 0 && estimator < this.smallEstimatorCutoff) {
            return HLLUtil.smallEstimator(m, numberOfZeroes);
        }
        if (estimator <= this.largeEstimatorCutoff) {
            return estimator;
        }
        return HLLUtil.largeEstimator(this.log2m, this.regwidth, estimator);
    }

    public void clear() {
        switch (this.type) {
            case EMPTY: {
                return;
            }
            case EXPLICIT: {
                this.explicitStorage.clear();
                return;
            }
            case SPARSE: {
                this.sparseProbabilisticStorage.clear();
                return;
            }
            case FULL: {
                this.probabilisticStorage.fill(0L);
                return;
            }
        }
        throw new RuntimeException("Unsupported HLL type " + this.type);
    }

    public void union(HLL other) {
        HLLType otherType = other.getType();
        if (this.type.equals((Object)otherType)) {
            this.homogeneousUnion(other);
            return;
        }
        this.heterogenousUnion(other);
    }

    void heterogenousUnion(HLL other) {
        if (HLLType.EMPTY.equals((Object)this.type)) {
            switch (other.getType()) {
                case EXPLICIT: {
                    if (other.explicitStorage.size() <= this.explicitThreshold) {
                        this.type = HLLType.EXPLICIT;
                        this.explicitStorage = other.explicitStorage.clone();
                    } else {
                        if (!this.sparseOff) {
                            this.initializeStorage(HLLType.SPARSE);
                        } else {
                            this.initializeStorage(HLLType.FULL);
                        }
                        for (LongCursor c : other.explicitStorage) {
                            this.addRaw(c.value);
                        }
                    }
                    return;
                }
                case SPARSE: {
                    if (!this.sparseOff) {
                        this.type = HLLType.SPARSE;
                        this.sparseProbabilisticStorage = other.sparseProbabilisticStorage.clone();
                    } else {
                        this.initializeStorage(HLLType.FULL);
                        for (IntByteCursor c : other.sparseProbabilisticStorage) {
                            int registerIndex = c.key;
                            byte registerValue = c.value;
                            this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
                        }
                    }
                    return;
                }
            }
            this.type = HLLType.FULL;
            this.probabilisticStorage = other.probabilisticStorage.clone();
            return;
        }
        if (HLLType.EMPTY.equals((Object)other.getType())) {
            return;
        }
        switch (this.type) {
            case EXPLICIT: {
                if (HLLType.SPARSE.equals((Object)other.getType())) {
                    if (!this.sparseOff) {
                        this.type = HLLType.SPARSE;
                        this.sparseProbabilisticStorage = other.sparseProbabilisticStorage.clone();
                    } else {
                        this.initializeStorage(HLLType.FULL);
                        for (IntByteCursor c : other.sparseProbabilisticStorage) {
                            int registerIndex = c.key;
                            byte registerValue = c.value;
                            this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
                        }
                    }
                } else {
                    this.type = HLLType.FULL;
                    this.probabilisticStorage = other.probabilisticStorage.clone();
                }
                for (IntByteCursor c : this.explicitStorage) {
                    this.addRaw(c.value);
                }
                this.explicitStorage = null;
                return;
            }
            case SPARSE: {
                if (HLLType.EXPLICIT.equals((Object)other.getType())) {
                    for (LongCursor c : other.explicitStorage) {
                        this.addRaw(c.value);
                    }
                } else {
                    this.type = HLLType.FULL;
                    this.probabilisticStorage = other.probabilisticStorage.clone();
                    for (IntByteCursor c : this.sparseProbabilisticStorage) {
                        int registerIndex = c.key;
                        byte registerValue = c.value;
                        this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
                    }
                    this.sparseProbabilisticStorage = null;
                }
                return;
            }
        }
        if (HLLType.EXPLICIT.equals((Object)other.getType())) {
            for (LongCursor c : other.explicitStorage) {
                this.addRaw(c.value);
            }
        } else {
            for (IntByteCursor c : other.sparseProbabilisticStorage) {
                int registerIndex = c.key;
                byte registerValue = c.value;
                this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
            }
        }
    }

    private void homogeneousUnion(HLL other) {
        switch (this.type) {
            case EMPTY: {
                return;
            }
            case EXPLICIT: {
                for (LongCursor c : other.explicitStorage) {
                    this.addRaw(c.value);
                }
                return;
            }
            case SPARSE: {
                int registerIndex;
                byte registerValue;
                for (IntByteCursor c : other.sparseProbabilisticStorage) {
                    registerValue = c.value;
                    registerIndex = c.key;
                    byte currentRegisterValue = this.sparseProbabilisticStorage.get(registerIndex);
                    if (registerValue <= currentRegisterValue) continue;
                    this.sparseProbabilisticStorage.put(registerIndex, registerValue);
                }
                if (this.sparseProbabilisticStorage.size() > this.sparseThreshold) {
                    this.initializeStorage(HLLType.FULL);
                    for (IntByteCursor c : this.sparseProbabilisticStorage) {
                        registerIndex = c.key;
                        registerValue = c.value;
                        this.probabilisticStorage.setMaxRegister(registerIndex, registerValue);
                    }
                    this.sparseProbabilisticStorage = null;
                }
                return;
            }
            case FULL: {
                for (int i = 0; i < this.m; ++i) {
                    long registerValue = other.probabilisticStorage.getRegister(i);
                    this.probabilisticStorage.setMaxRegister(i, registerValue);
                }
                return;
            }
        }
        throw new RuntimeException("Unsupported HLL type " + this.type);
    }

    public byte[] toBytes() {
        return this.toBytes(SerializationUtil.DEFAULT_SCHEMA_VERSION);
    }

    public byte[] toBytes(ISchemaVersion schemaVersion) {
        byte[] bytes;
        switch (this.type) {
            case EMPTY: {
                bytes = new byte[schemaVersion.paddingBytes(this.type)];
                break;
            }
            case EXPLICIT: {
                IWordSerializer serializer = schemaVersion.getSerializer(this.type, 64, this.explicitStorage.size());
                long[] values = this.explicitStorage.toArray();
                Arrays.sort(values);
                for (long value : values) {
                    serializer.writeWord(value);
                }
                bytes = serializer.getBytes();
                break;
            }
            case SPARSE: {
                IWordSerializer serializer = schemaVersion.getSerializer(this.type, this.shortWordLength, this.sparseProbabilisticStorage.size());
                int[] indices = this.sparseProbabilisticStorage.keys().toArray();
                Arrays.sort(indices);
                for (int registerIndex : indices) {
                    assert (this.sparseProbabilisticStorage.containsKey(registerIndex));
                    long registerValue = this.sparseProbabilisticStorage.get(registerIndex);
                    long shortWord = (long)(registerIndex << this.regwidth) | registerValue;
                    serializer.writeWord(shortWord);
                }
                bytes = serializer.getBytes();
                break;
            }
            case FULL: {
                IWordSerializer serializer = schemaVersion.getSerializer(this.type, this.regwidth, this.m);
                this.probabilisticStorage.getRegisterContents(serializer);
                bytes = serializer.getBytes();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HLL type " + this.type);
            }
        }
        HLLMetadata metadata = new HLLMetadata(schemaVersion.schemaVersionNumber(), this.type, this.log2m, this.regwidth, (int)NumberUtil.log2(this.explicitThreshold), this.explicitOff, this.explicitAuto, !this.sparseOff);
        schemaVersion.writeMetadata(bytes, metadata);
        return bytes;
    }

    public static HLL fromBytes(byte[] bytes) {
        int wordLength;
        ISchemaVersion schemaVersion = SerializationUtil.getSchemaVersion(bytes);
        IHLLMetadata metadata = schemaVersion.readMetadata(bytes);
        HLLType type = metadata.HLLType();
        int regwidth = metadata.registerWidth();
        int log2m = metadata.registerCountLog2();
        boolean sparseon = metadata.sparseEnabled();
        int expthresh = metadata.explicitAuto() ? -1 : (metadata.explicitOff() ? 0 : metadata.log2ExplicitCutoff() + 1);
        HLL hll = new HLL(log2m, regwidth, expthresh, sparseon, type);
        if (HLLType.EMPTY.equals((Object)type)) {
            return hll;
        }
        switch (type) {
            case EXPLICIT: {
                wordLength = 64;
                break;
            }
            case SPARSE: {
                wordLength = hll.shortWordLength;
                break;
            }
            case FULL: {
                wordLength = hll.regwidth;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HLL type " + type);
            }
        }
        IWordDeserializer deserializer = schemaVersion.getDeserializer(type, wordLength, bytes);
        switch (type) {
            case EXPLICIT: {
                for (int i = 0; i < deserializer.totalWordCount(); ++i) {
                    hll.explicitStorage.add(deserializer.readWord());
                }
                break;
            }
            case SPARSE: {
                for (int i = 0; i < deserializer.totalWordCount(); ++i) {
                    long shortWord = deserializer.readWord();
                    byte registerValue = (byte)(shortWord & (long)hll.valueMask);
                    if (registerValue == 0) continue;
                    hll.sparseProbabilisticStorage.put((int)(shortWord >>> hll.regwidth), registerValue);
                }
                break;
            }
            case FULL: {
                for (long i = 0L; i < (long)hll.m; ++i) {
                    hll.probabilisticStorage.setRegister(i, deserializer.readWord());
                }
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HLL type " + type);
            }
        }
        return hll;
    }

    public HLL clone() throws CloneNotSupportedException {
        int copyExpthresh = this.explicitAuto ? -1 : (this.explicitOff ? 0 : BitUtil.leastSignificantBit(this.explicitThreshold) + 1);
        HLL copy = new HLL(this.log2m, this.regwidth, copyExpthresh, !this.sparseOff, this.type);
        switch (this.type) {
            case EMPTY: {
                break;
            }
            case EXPLICIT: {
                copy.explicitStorage = this.explicitStorage.clone();
                break;
            }
            case SPARSE: {
                copy.sparseProbabilisticStorage = this.sparseProbabilisticStorage.clone();
                break;
            }
            case FULL: {
                copy.probabilisticStorage = this.probabilisticStorage.clone();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported HLL type " + this.type);
            }
        }
        return copy;
    }
}

