/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;
import org.apache.solr.spelling.Token;

public abstract class AbstractLuceneSpellChecker
extends SolrSpellChecker {
    public static final String SPELLCHECKER_ARG_NAME = "spellchecker";
    public static final String LOCATION = "sourceLocation";
    public static final String INDEX_DIR = "spellcheckIndexDir";
    public static final String ACCURACY = "accuracy";
    public static final String STRING_DISTANCE = "distanceMeasure";
    public static final String COMPARATOR_CLASS = "comparatorClass";
    public static final String SCORE_COMP = "score";
    public static final String FREQ_COMP = "freq";
    protected SpellChecker spellChecker;
    protected String sourceLocation;
    protected Directory index;
    protected Dictionary dictionary;
    public static final int DEFAULT_SUGGESTION_COUNT = 5;
    protected String indexDir;
    protected float accuracy = 0.5f;
    public static final String FIELD = "field";
    protected StringDistance sd;

    @Override
    public String init(NamedList<?> config, SolrCore core) {
        Comparator temp;
        super.init(config, core);
        this.indexDir = (String)config.get(INDEX_DIR);
        String accuracy = (String)config.get(ACCURACY);
        if (this.indexDir != null && !new File(this.indexDir).isAbsolute()) {
            this.indexDir = core.getDataDir() + File.separator + this.indexDir;
        }
        this.sourceLocation = (String)config.get(LOCATION);
        String compClass = (String)config.get(COMPARATOR_CLASS);
        Object comp = null;
        comp = compClass != null ? (compClass.equalsIgnoreCase(SCORE_COMP) ? SuggestWordQueue.DEFAULT_COMPARATOR : (compClass.equalsIgnoreCase(FREQ_COMP) ? new SuggestWordFrequencyComparator() : (temp = core.getResourceLoader().newInstance(compClass, Comparator.class)))) : SuggestWordQueue.DEFAULT_COMPARATOR;
        String strDistanceName = (String)config.get(STRING_DISTANCE);
        this.sd = strDistanceName != null ? core.getResourceLoader().newInstance(strDistanceName, StringDistance.class) : new LevenshteinDistance();
        try {
            this.initIndex();
            this.spellChecker = new SpellChecker(this.index, this.sd, (Comparator)comp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (accuracy != null) {
            try {
                this.accuracy = Float.parseFloat(accuracy);
                this.spellChecker.setAccuracy(this.accuracy);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unparseable accuracy given for dictionary: " + this.name, e);
            }
        }
        return this.name;
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        SpellingResult result = new SpellingResult(options.tokens);
        IndexReader reader = this.determineReader(options.reader);
        Term term = this.field != null ? new Term(this.field, "") : null;
        float theAccuracy = options.accuracy == Float.MIN_VALUE ? this.spellChecker.getAccuracy() : options.accuracy;
        int count = Math.max(options.count, 5);
        for (Token token : options.tokens) {
            String[] suggestions;
            String tokenText = new String(token.buffer(), 0, token.length());
            term = new Term(this.field, tokenText);
            int docFreq = 0;
            if (reader != null) {
                docFreq = reader.docFreq(term);
            }
            if ((suggestions = this.spellChecker.suggestSimilar(tokenText, options.alternativeTermCount == 0 || docFreq == 0 ? count : options.alternativeTermCount, (IndexReader)(this.field != null ? reader : null), this.field, options.suggestMode, theAccuracy)).length == 1 && suggestions[0].equals(tokenText) && options.alternativeTermCount == 0) continue;
            if (options.alternativeTermCount > 0 && docFreq > 0) {
                boolean foundOriginal = false;
                String[] suggestionsWithOrig = new String[suggestions.length + 1];
                for (int i = 0; i < suggestions.length; ++i) {
                    if (suggestions[i].equals(tokenText)) {
                        foundOriginal = true;
                        break;
                    }
                    suggestionsWithOrig[i + 1] = suggestions[i];
                }
                if (!foundOriginal) {
                    suggestionsWithOrig[0] = tokenText;
                    suggestions = suggestionsWithOrig;
                }
            }
            if (options.extendedResults && reader != null && this.field != null) {
                result.addFrequency(token, docFreq);
                int countLimit = Math.min(options.count, suggestions.length);
                if (countLimit > 0) {
                    for (int i = 0; i < countLimit; ++i) {
                        term = new Term(this.field, suggestions[i]);
                        result.add(token, suggestions[i], reader.docFreq(term));
                    }
                    continue;
                }
                List<String> suggList = Collections.emptyList();
                result.add(token, suggList);
                continue;
            }
            if (suggestions.length > 0) {
                List<String> suggList = Arrays.asList(suggestions);
                if (suggestions.length > options.count) {
                    suggList = suggList.subList(0, options.count);
                }
                result.add(token, suggList);
                continue;
            }
            List<String> suggList = Collections.emptyList();
            result.add(token, suggList);
        }
        return result;
    }

    protected IndexReader determineReader(IndexReader reader) {
        return reader;
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        this.spellChecker.setSpellIndex(this.index);
    }

    protected void initIndex() throws IOException {
        this.index = this.indexDir != null ? new FilterDirectory((Directory)FSDirectory.open((Path)Path.of(this.indexDir, new String[0]))){} : new ByteBuffersDirectory();
    }

    @Override
    public float getAccuracy() {
        return this.accuracy;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public StringDistance getStringDistance() {
        return this.sd;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }
}

