/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.document.KnnVectorField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.KnnVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.FloatPointField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;

public class DenseVectorField
extends FloatPointField {
    static final String KNN_VECTOR_DIMENSION = "vectorDimension";
    static final String KNN_SIMILARITY_FUNCTION = "similarityFunction";
    static final String CODEC_FORMAT = "codecFormat";
    static final String HNSW_MAX_CONNECTIONS = "hnswMaxConnections";
    static final String HNSW_BEAM_WIDTH = "hnswBeamWidth";
    private int dimension;
    private VectorSimilarityFunction similarityFunction;
    private VectorSimilarityFunction DEFAULT_SIMILARITY = VectorSimilarityFunction.EUCLIDEAN;
    private String codecFormat;
    private int hnswMaxConn;
    private int hnswBeamWidth;

    public DenseVectorField() {
    }

    public DenseVectorField(int dimension) {
        this.dimension = dimension;
        this.similarityFunction = this.DEFAULT_SIMILARITY;
    }

    public DenseVectorField(int dimension, VectorSimilarityFunction similarityFunction) {
        this.dimension = dimension;
        this.similarityFunction = similarityFunction;
    }

    @Override
    public void init(IndexSchema schema, Map<String, String> args) {
        this.dimension = Optional.ofNullable(args.get(KNN_VECTOR_DIMENSION)).map(value -> Integer.parseInt(value)).orElseThrow(() -> new SolrException(SolrException.ErrorCode.SERVER_ERROR, "the vector dimension is a mandatory parameter"));
        args.remove(KNN_VECTOR_DIMENSION);
        this.similarityFunction = Optional.ofNullable(args.get(KNN_SIMILARITY_FUNCTION)).map(value -> VectorSimilarityFunction.valueOf((String)value.toUpperCase(Locale.ROOT))).orElse(this.DEFAULT_SIMILARITY);
        args.remove(KNN_SIMILARITY_FUNCTION);
        this.codecFormat = args.get(CODEC_FORMAT);
        args.remove(CODEC_FORMAT);
        this.hnswMaxConn = Optional.ofNullable(args.get(HNSW_MAX_CONNECTIONS)).map(value -> Integer.parseInt(value)).orElse(16);
        args.remove(HNSW_MAX_CONNECTIONS);
        this.hnswBeamWidth = Optional.ofNullable(args.get(HNSW_BEAM_WIDTH)).map(value -> Integer.parseInt(value)).orElse(100);
        args.remove(HNSW_BEAM_WIDTH);
        this.properties &= 0xFFFFFDFF;
        this.properties &= 0xFFF7FFFF;
        super.init(schema, args);
    }

    public int getDimension() {
        return this.dimension;
    }

    public VectorSimilarityFunction getSimilarityFunction() {
        return this.similarityFunction;
    }

    public String getCodecFormat() {
        return this.codecFormat;
    }

    public Integer getHnswMaxConn() {
        return this.hnswMaxConn;
    }

    public Integer getHnswBeamWidth() {
        return this.hnswBeamWidth;
    }

    @Override
    public void checkSchemaField(SchemaField field) throws SolrException {
        super.checkSchemaField(field);
        if (field.multiValued()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + " fields can not be multiValued: " + field.getName());
        }
        if (field.hasDocValues()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, this.getClass().getSimpleName() + " fields can not have docValues: " + field.getName());
        }
    }

    @Override
    public List<IndexableField> createFields(SchemaField field, Object value) {
        float[] parsedVector;
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
        try {
            parsedVector = this.parseVector(value);
        }
        catch (RuntimeException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error while creating field '" + field + "' from value '" + value + "', expected format:'[f1, f2, f3...fn]' e.g. [1.0, 3.4, 5.6]", (Throwable)e);
        }
        if (field.indexed()) {
            fields.add(this.createField(field, parsedVector));
        }
        if (field.stored()) {
            fields.ensureCapacity(parsedVector.length + 1);
            for (float vectorElement : parsedVector) {
                fields.add((IndexableField)this.getStoredField(field, Float.valueOf(vectorElement)));
            }
        }
        return fields;
    }

    @Override
    public IndexableField createField(SchemaField field, Object parsedVector) {
        if (parsedVector == null) {
            return null;
        }
        float[] typedVector = (float[])parsedVector;
        return new KnnVectorField(field.getName(), typedVector, this.similarityFunction);
    }

    float[] parseVector(Object inputValue) {
        if (!(inputValue instanceof List)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector format. The expected format is an array :'[f1,f2..f3]' where each element f is a float");
        }
        List inputVector = (List)inputValue;
        if (inputVector.size() != this.dimension) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector dimension. The vector value has size " + inputVector.size() + " while it is expected a vector with size " + this.dimension);
        }
        float[] vector = new float[this.dimension];
        if (inputVector.get(0) instanceof CharSequence) {
            for (int i = 0; i < this.dimension; ++i) {
                try {
                    vector[i] = Float.parseFloat(inputVector.get(i).toString());
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector element: '" + inputVector.get(i) + "'. The expected format is:'[f1,f2..f3]' where each element f is a float");
                }
            }
        } else if (inputVector.get(0) instanceof Number) {
            for (int i = 0; i < this.dimension; ++i) {
                vector[i] = ((Number)inputVector.get(i)).floatValue();
            }
        } else {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "incorrect vector format. The expected format is an array :'[f1,f2..f3]' where each element f is a float");
        }
        return vector;
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        return null;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Function queries are not supported for Dense Vector fields.");
    }

    public Query getKnnVectorQuery(String fieldName, float[] vectorToSearch, int topK) {
        return new KnnVectorQuery(fieldName, vectorToSearch, topK);
    }

    @Override
    public Query getFieldQuery(QParser parser, SchemaField field, String externalVal) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field Queries are not supported for Dense Vector fields. Please use the {!knn} query parser to run K nearest neighbors search queries.");
    }

    @Override
    public Query getRangeQuery(QParser parser, SchemaField field, String part1, String part2, boolean minInclusive, boolean maxInclusive) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Range Queries are not supported for Dense Vector fields. Please use the {!knn} query parser to run K nearest neighbors search queries.");
    }

    @Override
    public SortField getSortField(SchemaField field, boolean top) {
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot sort on a Dense Vector field");
    }
}

