/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.concurrent.ExecutorService;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.DistributedClusterStateUpdater;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.Stats;
import org.apache.solr.cloud.api.collections.CollectionHandlingUtils;
import org.apache.solr.common.SolrCloseable;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.zookeeper.KeeperException;

public interface CollectionCommandContext {
    public boolean isDistributedCollectionAPI();

    public ShardHandler newShardHandler();

    public SolrCloudManager getSolrCloudManager();

    public ZkStateReader getZkStateReader();

    public DistributedClusterStateUpdater getDistributedClusterStateUpdater();

    public CoreContainer getCoreContainer();

    default public CollectionHandlingUtils.ShardRequestTracker asyncRequestTracker(String asyncId) {
        return new CollectionHandlingUtils.ShardRequestTracker(asyncId, this.getAdminPath(), this.getZkStateReader(), this.newShardHandler().getShardHandlerFactory());
    }

    default public String getAdminPath() {
        return "/admin/cores";
    }

    public SolrCloseable getCloseableToLatchOn();

    public ExecutorService getExecutorService();

    default public void offerStateUpdate(byte[] data) throws KeeperException, InterruptedException {
        throw new IllegalStateException("Bug! offerStateUpdate() should not be called when distributed cluster state updates are enabled");
    }

    default public String getOverseerId() {
        throw new IllegalStateException("Bug! getOverseerId() default implementation should never be called");
    }

    default public Stats getOverseerStats() {
        throw new IllegalStateException("Bug! getOverseerStats() should not be called when distributed state updates are enabled");
    }

    default public void submitIntraProcessMessage(Overseer.Message message) {
        throw new IllegalStateException("Bug! submitIntraProcessMessage() should not be called when distributed state updates are enabled");
    }
}

