/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import traer.physics.Force;
import traer.physics.Particle;
import traer.physics.Vector3D;

public class Attraction
implements Force {
    Particle a;
    Particle b;
    float k;
    boolean on;
    float distanceMin;

    public Attraction(Particle a, Particle b, float k, float distanceMin) {
        this.a = a;
        this.b = b;
        this.k = k;
        this.on = true;
        this.distanceMin = distanceMin;
    }

    public final float getMinimumDistance() {
        return this.distanceMin;
    }

    public final void setMinimumDistance(float d) {
        this.distanceMin = d;
    }

    public final void turnOff() {
        this.on = false;
    }

    public final void turnOn() {
        this.on = true;
    }

    public final void setStrength(float k) {
        this.k = k;
    }

    public final Particle getOneEnd() {
        return this.a;
    }

    public final Particle getTheOtherEnd() {
        return this.b;
    }

    public final void apply() {
        if (this.on) {
            float a2bX = this.a.position().x - this.b.position().x;
            float a2bY = this.a.position().y - this.b.position().y;
            float a2bZ = this.a.position().z - this.b.position().z;
            float oneOvera2bDistance = Vector3D.fastInverseSqrt(a2bX * a2bX + a2bY * a2bY + a2bZ * a2bZ);
            float a2bDistance = 1.0f / oneOvera2bDistance;
            if (a2bDistance == 0.0f) {
                return;
            }
            a2bX *= oneOvera2bDistance;
            a2bY *= oneOvera2bDistance;
            a2bZ *= oneOvera2bDistance;
            float force = this.k * this.a.mass * this.b.mass;
            force = a2bDistance < this.distanceMin ? (force /= this.distanceMin * this.distanceMin) : (force *= oneOvera2bDistance * oneOvera2bDistance);
            this.a.force().add(-(a2bX *= force), -(a2bY *= force), -(a2bZ *= force));
            this.b.force().add(a2bX, a2bY, a2bZ);
        }
    }

    public final float getStrength() {
        return this.k;
    }

    public final boolean isOn() {
        return this.on;
    }

    public final boolean isOff() {
        return !this.on;
    }

    public final boolean hasDead() {
        return this.a.isDead() || this.b.isDead();
    }
}

