/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class SignalCascadeMatrixPlotter
extends RasterPlotter {
    private final int columns;
    private final int rows;
    private final double[][] amplitudes;
    private final Random random;

    public SignalCascadeMatrixPlotter(int width, int height, int columns, int rows) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 16L);
        this.columns = columns;
        this.rows = rows;
        this.random = new Random(-889275714L);
        this.amplitudes = new double[columns][rows];
        for (int c = 0; c < columns; ++c) {
            for (int r = 0; r < rows; ++r) {
                this.amplitudes[c][r] = this.random.nextDouble();
            }
        }
    }

    public void renderFrame() {
        this.clear();
        this.drawBackground();
        int columnWidth = this.getWidth() / this.columns;
        for (int c = 0; c < this.columns; ++c) {
            this.updateColumn(c);
            this.drawColumn(c * columnWidth, columnWidth - 6, this.amplitudes[c]);
        }
        this.drawOverlay();
    }

    private void drawBackground() {
        this.setColor(6698L);
        for (int x = 0; x < this.getWidth(); x += 10) {
            this.line(x, 0, x, this.getHeight(), 12);
        }
        for (int y = 0; y < this.getHeight(); y += 6) {
            this.line(0, y, this.getWidth(), y, 10);
        }
    }

    private void updateColumn(int column) {
        for (int r = this.rows - 1; r > 0; --r) {
            this.amplitudes[column][r] = this.amplitudes[column][r - 1];
        }
        double prev = this.amplitudes[column][0];
        double next = prev + (this.random.nextDouble() - 0.5) * 0.4;
        this.amplitudes[column][0] = next = Math.max(0.05, Math.min(0.95, next));
    }

    private void drawColumn(int left, int width, double[] values) {
        int barHeight = this.getHeight() / this.rows;
        for (int r = 0; r < this.rows; ++r) {
            double value = values[r];
            int height = (int)(value * (double)barHeight);
            int y = this.getHeight() - (r + 1) * barHeight;
            long color = value > 0.7 ? 0xFF5577L : (value > 0.4 ? 65450L : 0x55CCFFL);
            this.fillBar(left, y, width, height, color, r);
        }
    }

    private void fillBar(int left, int bottom, int width, int height, long color, int row) {
        int y;
        int top = bottom + (row % 2 == 0 ? 2 : 0);
        for (int i = 0; i < height && (y = bottom - i) >= 0; i += 3) {
            this.setColor(SignalCascadeMatrixPlotter.darken(color, 0.4 + (double)(i % 9) * 0.03));
            this.line(left + 2, y, left + width - 2, y, 65);
        }
        this.setColor(SignalCascadeMatrixPlotter.lighten(color, 1.5));
        this.line(left + 2, top, left + width - 2, top, 85);
        this.line(left + 2, bottom - height, left + width - 2, bottom - height, 30);
    }

    private void drawOverlay() {
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 6, 14, 0, "SIGNAL CASCADE", -1, 80);
        this.setColor(65450L);
        PrintTool.print5(this, this.getWidth() - 6, 14, 0, "CHANNELS:" + this.columns, 1, 70);
    }

    public static void main(String[] args) {
        File dir;
        System.setProperty("java.awt.headless", "true");
        File file = dir = args.length > 0 ? new File(args[0]) : new File(".");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        SignalCascadeMatrixPlotter plotter = new SignalCascadeMatrixPlotter(480, 360, 10, 40);
        for (int frame = 0; frame < 8; ++frame) {
            plotter.renderFrame();
            File out = new File(dir, String.format("cascade_matrix_%02d.png", frame));
            try {
                plotter.save(out, "png");
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not save cascade frame", e);
            }
        }
    }
}

