/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.visualization;

import java.io.File;
import java.io.IOException;
import net.yacy.visualization.PrintTool;
import net.yacy.visualization.RasterPlotter;

public class IsometricPlotter
extends RasterPlotter {
    private static final int TILE_WIDTH = 24;
    private static final int TILE_HEIGHT = 12;
    private static final int BASELINE = 260;
    private static final int ORIGIN_X = 240;
    private final int[][] heightMap;
    private final long[] palette;

    public IsometricPlotter(int width, int height, int[][] heightMap) {
        super(width, height, RasterPlotter.DrawMode.MODE_REPLACE, 12L);
        this.heightMap = heightMap;
        this.palette = new long[]{1715801L, 2375803L, 3365019L, 2059407L, 4169663L, 8377343L};
    }

    public void renderScene() {
        this.clear();
        this.drawBackgroundGrid();
        for (int y = 0; y < this.heightMap.length; ++y) {
            for (int x = this.heightMap[y].length - 1; x >= 0; --x) {
                int h = this.heightMap[y][x];
                if (h <= 0) continue;
                long baseColor = this.palette[(x + y) % this.palette.length];
                this.drawBuilding(x, y, h, baseColor);
            }
        }
        this.drawForeground();
    }

    private void drawBackgroundGrid() {
        int i;
        this.setColor(4403L);
        for (i = 0; i < 7; ++i) {
            int y = 260 + i * 10;
            this.line(0, y, this.getWidth(), y, 12 + i * 2);
        }
        this.setColor(8772L);
        for (i = -6; i <= 6; ++i) {
            int x0 = 240 + i * 24 / 2;
            this.line(x0, 260, x0 + 144, 332, 20);
            this.line(x0, 260, x0 - 144, 332, 20);
        }
    }

    private void drawBuilding(int gridX, int gridY, int height, long color) {
        int xRight;
        int xLeft;
        int y;
        int i;
        int baseX = 240 + (gridX - gridY) * 12;
        int baseY = 260 + (gridX + gridY) * 6;
        int topY = baseY - height;
        int halfWidth = 12;
        int halfHeight = 6;
        this.setColor(IsometricPlotter.lighten(color, 1.3));
        for (i = 0; i <= 6; ++i) {
            y = topY - 6 + i;
            xLeft = baseX - 12 + i;
            xRight = baseX + 12 - i;
            if (xLeft > xRight) continue;
            this.line(xLeft, y, xRight, y, 60);
        }
        for (i = 0; i <= 6; ++i) {
            y = topY + i;
            xLeft = baseX - 12 + i;
            xRight = baseX + 12 - i;
            if (xLeft > xRight) continue;
            this.line(xLeft, y, xRight, y, 60);
        }
        this.setColor(IsometricPlotter.darken(color, 0.8));
        for (i = 0; i <= height; ++i) {
            y = topY + i;
            xLeft = baseX - 12;
            xRight = baseX - 12 + 6;
            this.line(xLeft, y, xRight, y + 6, 45);
        }
        this.setColor(IsometricPlotter.darken(color, 0.6));
        for (i = 0; i <= height; ++i) {
            y = topY + i;
            xLeft = baseX + 12 - 6;
            xRight = baseX + 12;
            this.line(xLeft, y + 6, xRight, y, 50);
        }
        this.setColor(IsometricPlotter.lighten(color, 1.6));
        this.line(baseX, topY - 6, baseX + 12, topY, 100);
        this.line(baseX, topY - 6, baseX - 12, topY, 100);
        this.line(baseX - 12, topY, baseX - 12, baseY, 80);
        this.line(baseX + 12, topY, baseX + 12, baseY, 80);
        this.line(baseX - 12, baseY, baseX, baseY + 6, 70);
        this.line(baseX + 12, baseY, baseX, baseY + 6, 70);
        this.setColor(0xFFEE66L);
        for (int row = 4; row < height; row += 6) {
            y = topY + row;
            this.line(baseX - 6, y, baseX - 2, y, 85);
            this.line(baseX + 2, y, baseX + 6, y, 85);
        }
    }

    private void drawForeground() {
        this.setColor(43775L);
        PrintTool.print5(this, 6, 12, 0, "ISOMETRIC CITYSCAPE", -1, 90);
        this.setColor(0x66FFFFL);
        PrintTool.print5(this, 6, 24, 0, "GRID SECTOR 7B", -1, 70);
        this.setColor(52394L);
        PrintTool.print5(this, this.getWidth() - 6, this.getHeight() - 8, 0, "POPULATION: 1.2M", 1, 60);
    }

    public static void main(String[] args) {
        File target;
        System.setProperty("java.awt.headless", "true");
        File file = target = args.length > 0 ? new File(args[0]) : new File(".");
        if (!target.exists()) {
            target.mkdirs();
        }
        int[][] heights = new int[][]{{40, 60, 80, 70, 45}, {20, 50, 110, 90, 40}, {10, 30, 140, 120, 70}, {0, 40, 90, 80, 30}, {0, 10, 40, 30, 20}};
        IsometricPlotter city = new IsometricPlotter(480, 320, heights);
        city.renderScene();
        File out = new File(target, "isometric_city.png");
        try {
            city.save(out, "png");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to save cityscape", e);
        }
    }
}

