/*
 * Decompiled with CFR 0.152.
 */
package net.yacy;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.search.Switchboard;

class shutdownHookThread
extends Thread {
    private final Switchboard sb;
    private final Semaphore shutdownSemaphore;

    public shutdownHookThread(Switchboard sb, Semaphore shutdownSemaphore) {
        super("yacy.shutdownHookThread");
        this.sb = sb;
        this.shutdownSemaphore = shutdownSemaphore;
    }

    @Override
    public void run() {
        try {
            if (!this.sb.isTerminated()) {
                ConcurrentLog.config("SHUTDOWN", "Shutdown via shutdown hook.");
                System.out.println("SHUTDOWN Starting shutdown via shutdown hook.");
                ConcurrentLog.fine("SHUTDOWN", "Signaling shutdown to the switchboard.");
                this.sb.terminate("shutdown hook");
                ConcurrentLog.fine("SHUTDOWN", "Waiting for main thread to finish.");
                int maxWaitTime = 30;
                if (!this.shutdownSemaphore.tryAcquire(30L, TimeUnit.SECONDS)) {
                    System.out.println("Shutting down JVM. Main thread did not completely finish within 30 seconds.");
                }
            }
        }
        catch (Exception e) {
            ConcurrentLog.severe("SHUTDOWN", "Unexpected error. " + e.getClass().getName(), e);
        }
    }
}

