/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.HashSet;
import java.util.Set;
import net.yacy.cora.sorting.ScoreMap;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.schema.CollectionSchema;

public class RestrictedStringNavigator
extends StringNavigator
implements Navigator {
    Set<String> allowed = new HashSet<String>();
    Set<String> forbidden = new HashSet<String>();

    public RestrictedStringNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        super(title, field, sort);
    }

    public boolean addAllowed(String s) {
        return this.allowed.add(s);
    }

    public boolean addForbidden(String s) {
        return this.forbidden.add(s);
    }

    @Override
    public void inc(String key) {
        if (!this.forbidden.contains(key)) {
            if (this.allowed.isEmpty()) {
                super.inc(key);
            } else if (this.allowed.contains(key)) {
                super.inc(key);
            }
        }
    }

    @Override
    public void inc(ScoreMap<String> map) {
        if (map == null) {
            return;
        }
        for (String entry2 : map) {
            int count;
            if (this.forbidden.contains(entry2)) continue;
            if (this.allowed.isEmpty()) {
                count = map.get(entry2);
                if (count <= 0) continue;
                this.inc(entry2, count);
                continue;
            }
            if (!this.allowed.contains(entry2) || (count = map.get(entry2)) <= 0) continue;
            this.inc(entry2, count);
        }
    }
}

