/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.search.navigator;

import java.util.Collection;
import java.util.Map;
import net.yacy.cora.document.analysis.Classification;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.navigator.Navigator;
import net.yacy.search.navigator.NavigatorSort;
import net.yacy.search.navigator.StringNavigator;
import net.yacy.search.query.QueryModifier;
import net.yacy.search.schema.CollectionSchema;

public class FileTypeNavigator
extends StringNavigator
implements Navigator {
    public FileTypeNavigator(String title, CollectionSchema field, NavigatorSort sort) {
        super(title, field, sort);
    }

    @Override
    public void incFacet(Map<String, ReversibleScoreMap<String>> facets) {
        ReversibleScoreMap<String> fcts;
        if (this.field != null && facets != null && !facets.isEmpty() && (fcts = facets.get(this.field.getSolrFieldName())) != null) {
            for (String ext : fcts) {
                if (!Classification.isAnyKnownExtension(ext)) continue;
                int cnt = fcts.get(ext);
                this.inc(ext, cnt);
            }
        }
    }

    @Override
    public void incDoc(URIMetadataNode doc) {
        if (this.field != null) {
            String ext;
            Object val = doc.getFieldValue(this.field.getSolrFieldName());
            if (val instanceof Collection) {
                Collection ll = (Collection)val;
                for (Object obj : ll) {
                    String s;
                    if (!(obj instanceof String) || !Classification.isAnyKnownExtension(s = (String)obj)) continue;
                    this.inc(s);
                }
            } else if (val != null && Classification.isAnyKnownExtension(ext = (String)val)) {
                this.inc(ext);
            }
        }
    }

    @Override
    public String getQueryModifier(String key) {
        return "filetype:" + key;
    }

    @Override
    public boolean modifieractive(QueryModifier modifier, String name) {
        if (modifier.filetype != null) {
            return modifier.filetype.contains(name);
        }
        return false;
    }
}

