/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Order;
import net.yacy.cora.util.ConcurrentLog;

public class MergeIterator<E>
implements CloneableIterator<E> {
    private final Comparator<E> comp;
    private final CloneableIterator<E> a;
    private final CloneableIterator<E> b;
    private E na;
    private E nb;
    private final Method merger;
    private final boolean up;
    public static final Method simpleMerge;

    public MergeIterator(CloneableIterator<E> a, CloneableIterator<E> b, Comparator<E> c, Method m, boolean up) {
        assert (a != null);
        assert (b != null);
        this.a = a;
        this.b = b;
        this.up = up;
        this.comp = c;
        this.merger = m;
        this.nexta();
        this.nextb();
    }

    @Override
    public void close() {
        this.a.close();
        this.b.close();
    }

    @Override
    public MergeIterator<E> clone(Object modifier) {
        assert (this.a != null);
        assert (this.b != null);
        assert (this.merger != null);
        return new MergeIterator<E>(this.a.clone(modifier), this.b.clone(modifier), this.comp, this.merger, this.up);
    }

    private void nexta() {
        try {
            this.na = this.a != null && this.a.hasNext() ? this.a.next() : null;
        }
        catch (ConcurrentModificationException e) {
            this.na = null;
        }
    }

    private void nextb() {
        try {
            this.nb = this.b != null && this.b.hasNext() ? this.b.next() : null;
        }
        catch (ConcurrentModificationException e) {
            this.nb = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.na != null || this.nb != null;
    }

    @Override
    public E next() {
        if (this.na == null) {
            E s = this.nb;
            this.nextb();
            return s;
        }
        if (this.nb == null) {
            E s = this.na;
            this.nexta();
            return s;
        }
        int c = this.comp.compare(this.na, this.nb);
        if (c == 0) {
            Object s;
            try {
                s = this.merger.invoke(null, this.na, this.nb);
            }
            catch (IllegalArgumentException e) {
                ConcurrentLog.logException(e);
                s = null;
            }
            catch (IllegalAccessException e) {
                ConcurrentLog.logException(e);
                s = null;
            }
            catch (InvocationTargetException e) {
                ConcurrentLog.logException(e);
                ConcurrentLog.logException(e.getCause());
                s = null;
            }
            this.nexta();
            this.nextb();
            return (E)s;
        }
        if (this.up && c < 0 || !this.up && c > 0) {
            E s = this.na;
            this.nexta();
            return s;
        }
        E s = this.nb;
        this.nextb();
        return s;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("merge does not support remove");
    }

    public static <A> CloneableIterator<A> cascade(Collection<CloneableIterator<A>> iterators, Order<A> c, Method merger, boolean up) {
        if (iterators == null || iterators.isEmpty()) {
            return new CloneableIterator<A>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public A next() {
                    return null;
                }

                @Override
                public void remove() {
                }

                @Override
                public CloneableIterator<A> clone(Object modifier) {
                    return this;
                }

                @Override
                public void close() {
                }
            };
        }
        return MergeIterator.cascade(iterators.iterator(), c, merger, up);
    }

    private static <A> CloneableIterator<A> cascade(Iterator<CloneableIterator<A>> iiterators, Order<A> c, Method merger, boolean up) {
        if (iiterators == null || !iiterators.hasNext()) {
            return new CloneableIterator<A>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public A next() {
                    return null;
                }

                @Override
                public void remove() {
                }

                @Override
                public CloneableIterator<A> clone(Object modifier) {
                    return this;
                }

                @Override
                public void close() {
                }
            };
        }
        CloneableIterator<A> one = iiterators.next();
        if (!iiterators.hasNext()) {
            return one;
        }
        assert (merger != null);
        return new MergeIterator<A>(one, MergeIterator.cascade(iiterators, c, merger, up), c, merger, up);
    }

    public static Object mergeEqualByReplace(Object a, Object b) {
        return a;
    }

    static {
        Method meth = null;
        try {
            Class<MergeIterator> c = MergeIterator.class;
            Class[] args = (Class[])Array.newInstance(Class.class, 2);
            args[0] = Object.class;
            args[1] = Object.class;
            meth = c.getMethod("mergeEqualByReplace", args);
        }
        catch (SecurityException e) {
            System.out.println("Error while initializing simpleMerge (1): " + e.getMessage());
            meth = null;
        }
        catch (NoSuchMethodException e) {
            System.out.println("Error while initializing simpleMerge (3): " + e.getMessage());
            meth = null;
        }
        assert (meth != null);
        simpleMerge = meth;
    }
}

