/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.util.TreeMap;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.storage.HandleSet;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.rwi.Index;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceFactory;

public class TermSearch<ReferenceType extends Reference> {
    private final ReferenceContainer<ReferenceType> joinResult;
    private TreeMap<byte[], ReferenceContainer<ReferenceType>> inclusionContainers;

    public TermSearch(Index<ReferenceType> base, HandleSet queryHashes, HandleSet excludeHashes, HandleSet urlselection, ReferenceFactory<ReferenceType> termFactory, int maxDistance) throws SpaceExceededException {
        TreeMap<byte[], Object> treeMap = this.inclusionContainers = queryHashes.isEmpty() ? new TreeMap(Base64Order.enhancedCoder) : base.searchConjunction(queryHashes, urlselection);
        if (!this.inclusionContainers.isEmpty() && this.inclusionContainers.size() < queryHashes.size()) {
            this.inclusionContainers = new TreeMap(Base64Order.enhancedCoder);
        }
        TreeMap<byte[], Object> exclusionContainers = this.inclusionContainers.isEmpty() ? new TreeMap(Base64Order.enhancedCoder) : base.searchConjunction(excludeHashes, urlselection);
        this.joinResult = ReferenceContainer.joinExcludeContainers(termFactory, this.inclusionContainers.values(), exclusionContainers.values(), maxDistance);
    }

    public ReferenceContainer<ReferenceType> joined() {
        return this.joinResult;
    }

    public TreeMap<byte[], ReferenceContainer<ReferenceType>> inclusion() {
        return this.inclusionContainers;
    }
}

