/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.rwi;

import java.io.IOException;
import java.util.TreeSet;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.Order;
import net.yacy.kelondro.rwi.AbstractIndex;
import net.yacy.kelondro.rwi.BufferedIndex;
import net.yacy.kelondro.rwi.IndexCell;
import net.yacy.kelondro.rwi.Reference;
import net.yacy.kelondro.rwi.ReferenceContainer;
import net.yacy.kelondro.rwi.ReferenceContainerOrder;
import net.yacy.kelondro.rwi.ReferenceFactory;

public abstract class AbstractBufferedIndex<ReferenceType extends Reference>
extends AbstractIndex<ReferenceType>
implements BufferedIndex<ReferenceType> {
    public AbstractBufferedIndex(ReferenceFactory<ReferenceType> factory) {
        super(factory);
    }

    @Override
    public synchronized TreeSet<ReferenceContainer<ReferenceType>> referenceContainer(byte[] startHash, boolean rot, boolean excludePrivate, int count, boolean ram) throws IOException {
        ReferenceContainerOrder containerOrder = new ReferenceContainerOrder(this.factory, (Order<byte[]>)this.termKeyOrdering().clone());
        if (startHash != null && startHash.length == 0) {
            startHash = null;
        }
        ReferenceContainer emptyContainer = ReferenceContainer.emptyContainer(this.factory, startHash);
        containerOrder.rotate(emptyContainer);
        TreeSet<ReferenceContainer<ReferenceType>> containers = new TreeSet<ReferenceContainer<ReferenceType>>(containerOrder);
        CloneableIterator i = this.referenceContainerIterator(startHash, rot, excludePrivate, ram);
        if (ram) {
            int n = count = this instanceof IndexCell ? count : Math.min(this.size(), count);
        }
        while (count > 0 && i.hasNext()) {
            ReferenceContainer container = (ReferenceContainer)i.next();
            if (container != null && !container.isEmpty()) {
                containers.add(container);
            }
            --count;
        }
        return containers;
    }
}

