/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.order.CloneableIterator;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.Index;
import net.yacy.kelondro.index.Row;
import net.yacy.kelondro.index.RowCollection;
import net.yacy.kelondro.util.MemoryControl;

public class RowSet
extends RowCollection
implements Index,
Iterable<Row.Entry>,
Serializable {
    private static final long serialVersionUID = -6036029762440788566L;

    public RowSet(RowSet rs) {
        super(rs);
    }

    public RowSet(Row rowdef, int objectCount, byte[] cache, int sortBound) {
        super(rowdef, objectCount, cache, sortBound);
        assert (rowdef.objectOrder != null);
    }

    public RowSet(Row rowdef, int objectCount) throws SpaceExceededException {
        super(rowdef, objectCount);
        assert (rowdef.objectOrder != null);
    }

    public RowSet(Row rowdef) {
        super(rowdef);
        assert (rowdef.objectOrder != null);
    }

    public RowSet(Row rowdef, Row.Entry exportedCollectionRowEnvironment) {
        super(rowdef, exportedCollectionRowEnvironment);
        assert (rowdef.objectOrder != null);
    }

    public static final RowSet importRowSet(byte[] b, Row rowdef) throws SpaceExceededException {
        byte[] chunkcache;
        assert ((long)b.length >= 14L) : "b.length = " + b.length;
        if ((long)b.length < 14L) {
            return new RowSet(rowdef, 0);
        }
        int size = (int)NaturalOrder.decodeLong(b, 0, 4);
        assert (size >= 0) : "size = " + size;
        if (size < 0) {
            return new RowSet(rowdef, 0);
        }
        int orderbound = (int)NaturalOrder.decodeLong(b, 10, 4);
        assert (orderbound >= 0) : "orderbound = " + orderbound;
        if (orderbound < 0) {
            return new RowSet(rowdef, 0);
        }
        long alloc = (long)size * (long)rowdef.objectsize;
        assert (alloc <= Integer.MAX_VALUE) : "alloc = " + alloc;
        if (alloc > Integer.MAX_VALUE) {
            throw new SpaceExceededException((int)alloc, "importRowSet: alloc > Integer.MAX_VALUE");
        }
        assert (alloc == (long)b.length - 14L);
        if (alloc != (long)b.length - 14L) {
            throw new SpaceExceededException((int)alloc, "importRowSet: alloc != b.length - exportOverheadSize");
        }
        MemoryControl.request((int)alloc, true);
        try {
            chunkcache = new byte[(int)alloc];
        }
        catch (OutOfMemoryError e) {
            throw new SpaceExceededException((int)alloc, "importRowSet: OutOfMemoryError");
        }
        if ((long)b.length - 14L != alloc) {
            ConcurrentLog.severe("KELONDRO", "RowSet: exportOverheadSize wrong: b.length = " + b.length + ", size * rowdef.objectsize = " + size * rowdef.objectsize);
            return new RowSet(rowdef, 0);
        }
        System.arraycopy(b, 14, chunkcache, 0, chunkcache.length);
        return new RowSet(rowdef, size, chunkcache, orderbound);
    }

    public static final int importRowCount(long blength, Row rowdef) {
        assert (blength >= 14L) : "blength = " + blength;
        if (blength < 14L) {
            return 0;
        }
        int c = (int)((blength - 14L) / (long)rowdef.objectsize);
        assert (c >= 0);
        return c;
    }

    private RowSet(Row rowdef, byte[] chunkcache, int chunkcount, int sortBound, long lastTimeWrote) {
        super(rowdef, chunkcache, chunkcount, sortBound, lastTimeWrote);
    }

    @Override
    public RowSet clone() {
        return new RowSet(this.rowdef, this.chunkcache, this.chunkcount, this.sortBound, this.lastTimeWrote);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public final synchronized boolean has(byte[] key) {
        assert (key.length == this.rowdef.primaryKeyLength);
        if (key == null || key.length != this.rowdef.primaryKeyLength) {
            throw new IllegalArgumentException("key length " + (key == null ? 0 : key.length) + " != primaryKeyLength " + this.rowdef.primaryKeyLength);
        }
        int index2 = this.find(key, 0);
        return index2 >= 0;
    }

    @Override
    public final synchronized Row.Entry get(byte[] key, boolean forcecopy) {
        assert (key.length == this.rowdef.primaryKeyLength);
        if (key == null || key.length != this.rowdef.primaryKeyLength) {
            throw new IllegalArgumentException("key length " + (key == null ? 0 : key.length) + " != primaryKeyLength " + this.rowdef.primaryKeyLength);
        }
        int index2 = this.find(key, 0);
        if (index2 < 0) {
            return null;
        }
        return this.get(index2, forcecopy);
    }

    @Override
    public Map<byte[], Row.Entry> getMap(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        TreeMap<byte[], Row.Entry> map = new TreeMap<byte[], Row.Entry>(this.row().objectOrder);
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            map.put(key, entry2);
        }
        return map;
    }

    @Override
    public List<Row.Entry> getList(Collection<byte[]> keys, boolean forcecopy) throws IOException, InterruptedException {
        ArrayList<Row.Entry> list2 = new ArrayList<Row.Entry>(keys.size());
        for (byte[] key : keys) {
            Row.Entry entry2 = this.get(key, forcecopy);
            if (entry2 == null) continue;
            list2.add(entry2);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(Row.Entry entry2) throws SpaceExceededException {
        assert (entry2 != null);
        byte[] key = entry2.getPrimaryKeyBytes();
        assert (key != null);
        byte[] entrybytes = entry2.bytes();
        assert (entrybytes.length >= this.rowdef.primaryKeyLength);
        RowSet rowSet = this;
        synchronized (rowSet) {
            int index2 = this.find(key, 0);
            if (index2 < 0) {
                super.addUnique(entry2);
                return true;
            }
            int sb = this.sortBound;
            this.set(index2, entry2);
            this.sortBound = sb;
            return false;
        }
    }

    private final int collectionReSortLimit() {
        return Math.min(3000, Math.max(100, this.chunkcount / 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Row.Entry replace(Row.Entry entry2) throws SpaceExceededException {
        assert (entry2 != null);
        byte[] key = entry2.getPrimaryKeyBytes();
        assert (key != null);
        byte[] entrybytes = entry2.bytes();
        assert (entrybytes.length >= this.rowdef.primaryKeyLength);
        RowSet rowSet = this;
        synchronized (rowSet) {
            int index2 = -1;
            Row.Entry oldentry = null;
            if (this.chunkcount - this.sortBound > this.collectionReSortLimit()) {
                this.sort();
            }
            if ((index2 = this.find(key, 0)) < 0) {
                super.addUnique(entry2);
            } else {
                oldentry = this.get(index2, true);
                int sb = this.sortBound;
                this.set(index2, entry2);
                this.sortBound = sb;
            }
            return oldentry;
        }
    }

    public final synchronized long inc(byte[] key, int col, long add, Row.Entry initrow) throws SpaceExceededException {
        assert (key.length == this.rowdef.primaryKeyLength);
        int index2 = this.find(key, 0);
        if (index2 >= 0) {
            Row.Entry entry2 = this.get(index2, false);
            long l = entry2.incCol(col, add);
            this.set(index2, entry2);
            return l;
        }
        if (initrow != null) {
            super.addUnique(initrow);
            return initrow.getColLong(col);
        }
        return Long.MIN_VALUE;
    }

    @Override
    public final synchronized boolean delete(byte[] a) {
        boolean exists = false;
        assert (a.length == this.rowdef.primaryKeyLength);
        if (a == null || a.length != this.rowdef.primaryKeyLength) {
            throw new IllegalArgumentException("key length " + (a == null ? 0 : a.length) + " != primaryKeyLength " + this.rowdef.primaryKeyLength);
        }
        int index2;
        while ((index2 = this.find(a, 0)) >= 0) {
            exists = true;
            super.removeRow(index2, true);
        }
        return exists;
    }

    public final synchronized void delete(List<byte[]> keys) {
        int i;
        int[] indexes = new int[keys.size()];
        for (i = 0; i < keys.size(); ++i) {
            indexes[i] = this.find(keys.get(i), 0);
        }
        Arrays.sort(indexes);
        for (i = indexes.length - 1; i >= 0 && indexes[i] >= 0; --i) {
            super.removeRow(indexes[i], false);
        }
    }

    @Override
    public final synchronized Row.Entry remove(byte[] a) {
        Row.Entry entry2 = null;
        assert (a.length == this.rowdef.primaryKeyLength);
        int index2;
        while ((index2 = this.find(a, 0)) >= 0) {
            entry2 = super.get(index2, true);
            super.removeRow(index2, true);
        }
        return entry2;
    }

    private final int find(byte[] a, int astart) {
        if (this.rowdef.objectOrder == null) {
            return this.iterativeSearch(a, astart, 0, this.chunkcount);
        }
        if (this.chunkcount - this.sortBound > this.collectionReSortLimit()) {
            this.sort();
        }
        if (this.rowdef.objectOrder != null && this.rowdef.objectOrder instanceof Base64Order) assert (this.rowdef.objectOrder.wellformed(a, astart, this.rowdef.primaryKeyLength)) : "not wellformed: " + ASCII.String(a, astart, this.rowdef.primaryKeyLength);
        int p = this.binarySearch(a, astart);
        if (p >= 0) {
            return p;
        }
        return this.iterativeSearch(a, astart, this.sortBound, this.chunkcount);
    }

    private final int iterativeSearch(byte[] key, int astart, int leftBorder, int rightBound) {
        for (int i = leftBorder; i < rightBound; ++i) {
            assert (key.length - astart >= this.rowdef.primaryKeyLength);
            if (!this.match(key, astart, i)) continue;
            return i;
        }
        return -1;
    }

    private final int binarySearch(byte[] key, int astart) {
        assert (this.rowdef.objectOrder != null);
        int l = 0;
        int rbound = this.sortBound;
        int p = 0;
        while (l < rbound) {
            p = l + rbound >> 1;
            assert (key.length - astart >= this.rowdef.primaryKeyLength);
            int d = this.compare(key, astart, p);
            if (d == 0) {
                return p;
            }
            if (d < 0) {
                rbound = p;
                continue;
            }
            l = p + 1;
        }
        return -1;
    }

    protected final int binaryPosition(byte[] key, int astart) {
        assert (this.rowdef.objectOrder != null);
        int l = 0;
        int rbound = this.sortBound;
        int p = 0;
        while (l < rbound) {
            p = l + rbound >> 1;
            assert (key.length - astart >= this.rowdef.primaryKeyLength);
            int d = this.compare(key, astart, p);
            if (d == 0) {
                return p;
            }
            if (d < 0) {
                rbound = p;
                continue;
            }
            l = p + 1;
        }
        return l;
    }

    public final synchronized Iterator<byte[]> keys() {
        this.sort();
        return super.keys(true);
    }

    @Override
    public final synchronized CloneableIterator<byte[]> keys(boolean up, byte[] firstKey) {
        this.sort();
        return new keyIterator(up, firstKey);
    }

    @Override
    public final synchronized Iterator<Row.Entry> iterator() {
        this.sort();
        return super.iterator();
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows(boolean up, byte[] firstKey) {
        return new rowIterator(up, firstKey);
    }

    @Override
    public final synchronized CloneableIterator<Row.Entry> rows() {
        return new rowIterator(true, null);
    }

    public final RowSet merge(RowSet c) throws SpaceExceededException {
        assert (c != null);
        return RowSet.mergeEnum(this, c);
    }

    protected static final RowSet mergeEnum(RowCollection c0, RowCollection c1) throws SpaceExceededException {
        assert (c0.rowdef == c1.rowdef) : c0.rowdef.toString() + " != " + c1.rowdef.toString();
        RowSet r = new RowSet(c0.rowdef, c0.size() + c1.size());
        try {
            c0.sort();
        }
        catch (Throwable e) {
            ConcurrentLog.severe("KELONDRO", "RowSet: collection corrupted. cleaned. " + e.getMessage(), e);
            c0.clear();
        }
        try {
            c1.sort();
        }
        catch (Throwable e) {
            ConcurrentLog.severe("KELONDRO", "RowSet: collection corrupted. cleaned. " + e.getMessage(), e);
            c1.clear();
        }
        int c0i = 0;
        int c1i = 0;
        int objectsize = c0.rowdef.objectsize;
        int c0s = c0.size();
        int c1s = c1.size();
        while (c0i < c0s && c1i < c1s) {
            int c0p = c0i * objectsize;
            int c1p = c1i * objectsize;
            int o = c0.rowdef.objectOrder.compare(c0.chunkcache, c0p, c1.chunkcache, c1p, c0.rowdef.primaryKeyLength);
            if (o == 0) {
                r.addSorted(c0.chunkcache, c0p, objectsize);
                ++c0i;
                ++c1i;
                continue;
            }
            if (o < 0) {
                r.addSorted(c0.chunkcache, c0p, objectsize);
                ++c0i;
                continue;
            }
            if (o <= 0) continue;
            r.addSorted(c1.chunkcache, c1p, objectsize);
            ++c1i;
        }
        while (c0i < c0.size()) {
            r.addSorted(c0.chunkcache, c0i * objectsize, objectsize);
            ++c0i;
        }
        while (c1i < c1.size()) {
            r.addSorted(c1.chunkcache, c1i * objectsize, objectsize);
            ++c1i;
        }
        return r;
    }

    public static void main(String[] args) {
        int i;
        String[] test2 = new String[]{"eins......xxxx", "zwei......xxxx", "drei......xxxx", "vier......xxxx", "fuenf.....xxxx", "sechs.....xxxx", "sieben....xxxx", "acht......xxxx", "neun......xxxx", "zehn......xxxx"};
        RowSet d = new RowSet(new Row("byte[] key-10, Cardinal x-4 {b256}", NaturalOrder.naturalOrder));
        for (String element : test2) {
            try {
                d.add(element.getBytes());
            }
            catch (SpaceExceededException e) {
                e.printStackTrace();
            }
        }
        for (String element : test2) {
            try {
                d.add(element.getBytes());
            }
            catch (SpaceExceededException e) {
                e.printStackTrace();
            }
        }
        d.sort();
        d.delete("fuenf.....".getBytes());
        Iterator<Row.Entry> ii = d.iterator();
        System.out.print("INPUT-ITERATOR: ");
        while (ii.hasNext()) {
            Row.Entry entry2 = ii.next();
            String s = entry2.getPrimaryKeyASCII().trim();
            System.out.print(s + ", ");
            if (!s.equals("drei")) continue;
            ii.remove();
        }
        System.out.println("");
        System.out.println("INPUT-TOSTRING: " + d.toString());
        d.sort();
        System.out.println("SORTED        : " + d.toString());
        d.uniq();
        System.out.println("UNIQ          : " + d.toString());
        d.trim();
        System.out.println("TRIM          : " + d.toString());
        Row row = new Row("byte[] key-10, Cardinal x-3 {b256}", NaturalOrder.naturalOrder);
        RowSet c = new RowSet(row);
        Random rand = new Random(0L);
        long start = System.currentTimeMillis();
        for (long k = 1L; k <= 200000L; ++k) {
            long t = System.currentTimeMillis();
            String w = "a" + Long.toString(rand.nextLong());
            try {
                c.put(row.newEntry(new byte[][]{w.getBytes(), "000".getBytes()}));
            }
            catch (SpaceExceededException e) {
                e.printStackTrace();
            }
            if (k % 10000L != 0L) continue;
            System.out.println("added " + k + " entries in " + (t - start) + " milliseconds, " + (t - start > 1000L ? k / ((t - start) / 1000L) : k) + " entries/second, size = " + c.size());
        }
        System.out.println("bevore sort: " + (System.currentTimeMillis() - start) + " milliseconds, size: " + c.size());
        c.sort();
        System.out.println("after sort: " + (System.currentTimeMillis() - start) + " milliseconds, size: " + c.size());
        c.uniq();
        System.out.println("after uniq: " + (System.currentTimeMillis() - start) + " milliseconds, size: " + c.size());
        System.out.println();
        start = System.currentTimeMillis();
        c = new RowSet(new Row("byte[] a-12, byte[] b-12", (ByteOrder)Base64Order.enhancedCoder));
        int testsize = 5000;
        byte[][] delkeys = new byte[1000][];
        Random random = new Random(0L);
        for (i = 0; i < 5000; ++i) {
            byte[] key = RowSet.randomHash(random);
            if (i % 5 != 0) continue;
            delkeys[i / 5] = key;
        }
        random = new Random(0L);
        for (i = 0; i < 5000; ++i) {
            byte[] key = RowSet.randomHash(random);
            try {
                c.put(c.rowdef.newEntry(new byte[][]{key, key}));
            }
            catch (SpaceExceededException e) {
                e.printStackTrace();
            }
            if (i % 1000 != 0) continue;
            byte[][] byArrayArray = delkeys;
            int n = byArrayArray.length;
            for (int j = 0; j < n; ++j) {
                byte[] delkey = byArrayArray[j];
                c.delete(delkey);
            }
            c.sort();
        }
        for (byte[] delkey : delkeys) {
            c.delete(delkey);
        }
        c.sort();
        random = new Random(0L);
        for (int i2 = 0; i2 < 5000; ++i2) {
            byte[] key = RowSet.randomHash(random);
            if (i2 % 5 == 0 || c.get(key, true) != null) continue;
            System.out.println("missing entry " + UTF8.String(key));
        }
        c.sort();
        System.out.println("RESULT SIZE: " + c.size());
        System.out.println("Time: " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        System.exit(0);
    }

    public static byte[] randomHash(long r0, long r1) {
        return ASCII.getBytes(Base64Order.enhancedCoder.encodeLongSB(Math.abs(r0), 11).substring(5) + Base64Order.enhancedCoder.encodeLongSB(Math.abs(r1), 11).substring(5));
    }

    public static byte[] randomHash(Random r) {
        return RowSet.randomHash(r.nextLong(), r.nextLong());
    }

    @Override
    public String filename() {
        return null;
    }

    @Override
    public void deleteOnExit() {
    }

    public final class keyIterator
    implements CloneableIterator<byte[]> {
        private final boolean up;
        private final byte[] first;
        private int p;
        final int bound;

        public keyIterator(boolean up, byte[] firstKey) {
            RowSet.this.sort();
            this.up = up;
            if (firstKey != null && firstKey.length == 0) {
                firstKey = null;
            }
            this.first = firstKey;
            this.bound = RowSet.this.sortBound;
            if (this.first == null) {
                this.p = up ? 0 : this.bound - 1;
            } else {
                assert (this.first.length == RowSet.this.rowdef.primaryKeyLength) : "first.length = " + this.first.length + ", rowdef.primaryKeyLength = " + this$0.rowdef.primaryKeyLength;
                this.p = up ? RowSet.this.binaryPosition(this.first, 0) : this.bound - 1;
            }
        }

        public final keyIterator clone(Object second) {
            return new keyIterator(this.up, (byte[])second);
        }

        @Override
        public final boolean hasNext() {
            if (this.p < 0) {
                return false;
            }
            if (this.p >= RowSet.this.size()) {
                return false;
            }
            return this.up ? this.p < this.bound : this.p >= 0;
        }

        @Override
        public final byte[] next() {
            byte[] key = RowSet.this.getKey(this.p);
            this.p = this.up ? ++this.p : --this.p;
            return key;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }

    public final class rowIterator
    implements CloneableIterator<Row.Entry> {
        private final boolean up;
        private final byte[] first;
        private int p;
        final int bound;

        public rowIterator(boolean up, byte[] firstKey) {
            RowSet.this.sort();
            this.up = up;
            this.first = firstKey;
            this.bound = RowSet.this.sortBound;
            if (this.first == null) {
                this.p = 0;
            } else {
                assert (this.first.length == RowSet.this.rowdef.primaryKeyLength);
                this.p = RowSet.this.binaryPosition(this.first, 0);
            }
        }

        public final rowIterator clone(Object second) {
            return new rowIterator(this.up, (byte[])second);
        }

        @Override
        public final boolean hasNext() {
            if (this.p < 0) {
                return false;
            }
            if (this.p >= RowSet.this.size()) {
                return false;
            }
            return this.up ? this.p < this.bound : this.p >= 0;
        }

        @Override
        public final Row.Entry next() {
            Row.Entry entry2 = RowSet.this.get(this.p, true);
            this.p = this.up ? ++this.p : --this.p;
            return entry2;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
        }
    }
}

