/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.index;

import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.order.Base64Order;
import net.yacy.cora.util.ByteArray;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.index.RowHandleMap;
import net.yacy.kelondro.util.MemoryControl;

public class IndexTest {
    public static final long mb = 0x100000L;

    public static byte[] randomHash(long r0, long r1) {
        String s = Base64Order.enhancedCoder.encodeLongSB(Math.abs(r0), 6).toString() + Base64Order.enhancedCoder.encodeLongSB(Math.abs(r1), 6).toString();
        return ASCII.getBytes(s);
    }

    public static byte[] randomHash(Random r) {
        return IndexTest.randomHash(r.nextLong(), r.nextLong());
    }

    public static void main(String[] args) {
        int count = args.length == 0 ? 1000000 : Integer.parseInt(args[0]);
        byte[][] tests = new byte[count][];
        Random r = new Random(0L);
        for (int i = 0; i < count; ++i) {
            tests[i] = IndexTest.randomHash(r);
        }
        System.out.println("generated " + count + " test data entries \n");
        System.out.println("\nSTANDARD JAVA CLASS MAPS \n");
        long t1 = System.currentTimeMillis();
        System.out.println("sorted map");
        Runtime.getRuntime().gc();
        long freeStartTree = MemoryControl.free();
        TreeMap<byte[], Integer> tm = new TreeMap<byte[], Integer>(Base64Order.enhancedCoder);
        for (int i = 0; i < count; ++i) {
            tm.put(tests[i], 1);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("time   for TreeMap<byte[]> generation: " + (t2 - t1));
        int bugs = 0;
        for (int i = 0; i < count; ++i) {
            if (tm.get(tests[i]) != null) continue;
            ++bugs;
        }
        Runtime.getRuntime().gc();
        long freeEndTree = MemoryControl.available();
        tm.clear();
        tm = null;
        long t3 = System.currentTimeMillis();
        System.out.println("time   for TreeMap<byte[]> test: " + (t3 - t2) + ", " + bugs + " bugs");
        System.out.println("memory for TreeMap<byte[]>: " + (freeStartTree - freeEndTree) / 0x100000L + " MB\n");
        System.out.println("unsorted map");
        Runtime.getRuntime().gc();
        long freeStartHash = MemoryControl.available();
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        for (int i = 0; i < count; ++i) {
            hm.put(UTF8.String(tests[i]), 1);
        }
        long t4 = System.currentTimeMillis();
        System.out.println("time   for HashMap<String> generation: " + (t4 - t3));
        bugs = 0;
        for (int i = 0; i < count; ++i) {
            if (hm.get(UTF8.String(tests[i])) != null) continue;
            ++bugs;
        }
        Runtime.getRuntime().gc();
        long freeEndHash = MemoryControl.available();
        hm.clear();
        hm = null;
        long t5 = System.currentTimeMillis();
        System.out.println("time   for HashMap<String> test: " + (t5 - t4) + ", " + bugs + " bugs");
        System.out.println("memory for HashMap<String>: " + (freeStartHash - freeEndHash) / 0x100000L + " MB\n");
        System.out.println("\nKELONDRO-ENHANCED MAPS \n");
        System.out.println("sorted map");
        Runtime.getRuntime().gc();
        long freeStartKelondro = MemoryControl.available();
        RowHandleMap ii = null;
        ii = new RowHandleMap(12, Base64Order.enhancedCoder, 4, count, "test");
        for (int i = 0; i < count; ++i) {
            try {
                ii.putUnique(tests[i], 1L);
                continue;
            }
            catch (SpaceExceededException e) {
                e.printStackTrace();
            }
        }
        ii.get(IndexTest.randomHash(r));
        long t6 = System.currentTimeMillis();
        System.out.println("time   for HandleMap<byte[]> generation: " + (t6 - t5));
        bugs = 0;
        for (int i = 0; i < count; ++i) {
            if (ii.get(tests[i]) == 1L) continue;
            ++bugs;
        }
        Runtime.getRuntime().gc();
        long freeEndKelondro = MemoryControl.available();
        ii.clear();
        ii.close();
        ii = null;
        long t7 = System.currentTimeMillis();
        System.out.println("time   for HandleMap<byte[]> test: " + (t7 - t6) + ", " + bugs + " bugs");
        System.out.println("memory for HandleMap<byte[]>: " + (freeStartKelondro - freeEndKelondro) / 0x100000L + " MB\n");
        System.out.println("unsorted map");
        Runtime.getRuntime().gc();
        long freeStartBA = MemoryControl.available();
        HashMap<ByteArray, Integer> bm = new HashMap<ByteArray, Integer>();
        for (int i = 0; i < count; ++i) {
            bm.put(new ByteArray(tests[i]), 1);
        }
        long t8 = System.currentTimeMillis();
        System.out.println("time   for HashMap<ByteArray> generation: " + (t8 - t7));
        bugs = 0;
        for (int i = 0; i < count; ++i) {
            if (bm.get(new ByteArray(tests[i])) != null) continue;
            ++bugs;
        }
        Runtime.getRuntime().gc();
        long freeEndBA = MemoryControl.available();
        bm.clear();
        bm = null;
        long t9 = System.currentTimeMillis();
        System.out.println("time   for HashMap<ByteArray> test: " + (t9 - t8) + ", " + bugs + " bugs");
        System.out.println("memory for HashMap<ByteArray>: " + (freeStartBA - freeEndBA) / 0x100000L + " MB\n");
        System.exit(0);
    }
}

