/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.kelondro.blob;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.yacy.cora.order.NaturalOrder;
import net.yacy.kelondro.blob.TablesColumnIndex;

public class TablesColumnRAMIndex
extends TablesColumnIndex {
    private final Map<String, Map<String, TreeSet<byte[]>>> index = new ConcurrentHashMap<String, Map<String, TreeSet<byte[]>>>();
    private static final Comparator<byte[]> NATURALORDER = new NaturalOrder(true);

    public TablesColumnRAMIndex() {
        super(TablesColumnIndex.INDEXTYPE.RAM);
    }

    @Override
    public void deleteIndex(String columnName) {
        this.index.remove(columnName);
    }

    @Override
    protected void insertPK(String columnName, String columnValue, byte[] pk) {
        TreeSet<byte[]> PKset;
        Map<Object, Object> valueIdxMap;
        if (this.index.containsKey(columnName)) {
            valueIdxMap = this.index.get(columnName);
        } else {
            valueIdxMap = new ConcurrentHashMap();
            this.index.put(columnName, valueIdxMap);
        }
        if (valueIdxMap.containsKey(columnValue)) {
            PKset = (TreeSet<byte[]>)valueIdxMap.get(columnValue);
        } else {
            PKset = new TreeSet<byte[]>(NATURALORDER);
            valueIdxMap.put(columnValue, PKset);
        }
        PKset.add(pk);
    }

    @Override
    protected synchronized void removePK(byte[] pk) {
        for (Map.Entry<String, Map<String, TreeSet<byte[]>>> columnName : this.index.entrySet()) {
            Iterator<Map.Entry<String, TreeSet<byte[]>>> viter = columnName.getValue().entrySet().iterator();
            while (viter.hasNext()) {
                Map.Entry<String, TreeSet<byte[]>> columnValue = viter.next();
                columnValue.getValue().remove(pk);
                if (!columnValue.getValue().isEmpty()) continue;
                viter.remove();
            }
        }
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public Collection<String> columns() {
        return this.index.keySet();
    }

    @Override
    public Set<String> keySet(String columnName) {
        if (this.index.containsKey(columnName)) {
            return new TreeSet<String>(this.index.get(columnName).keySet());
        }
        return new TreeSet<String>();
    }

    @Override
    public boolean containsKey(String columnName, String columnValue) {
        if (this.index.containsKey(columnName)) {
            return this.index.get(columnName).containsKey(columnValue);
        }
        return false;
    }

    @Override
    public boolean hasIndex(String columnName) {
        return this.index.containsKey(columnName);
    }

    @Override
    public Collection<byte[]> get(String columnName, String key) {
        return this.index.get(columnName).get(key);
    }

    @Override
    public int size(String columnName) {
        if (this.index.containsKey(columnName)) {
            return this.index.get(columnName).size();
        }
        return -1;
    }

    @Override
    public int size() {
        return this.index.size();
    }
}

