/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import net.yacy.cora.protocol.RequestHeader;
import net.yacy.http.servlets.TemplateMissingParameterException;
import net.yacy.search.Switchboard;
import net.yacy.search.query.QueryParams;
import net.yacy.search.query.SearchEvent;
import net.yacy.search.query.SearchEventCache;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class yacysearchpagination {
    private static final int MAX_PAGINATION_LINKS = 10;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        if (post == null) {
            throw new TemplateMissingParameterException("The eventID parameter is required");
        }
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        String eventID = post.get("eventID");
        if (eventID == null) {
            throw new TemplateMissingParameterException("The eventID parameter is required");
        }
        boolean jsResort = post.getBoolean("jsResort");
        boolean authFeatures = post.containsKey("auth");
        int defaultItemsPerPage = sb.getConfigInt("search.items", 10);
        int itemsPerPage = Math.max(1, post.getInt("maximumRecords", defaultItemsPerPage));
        SearchEvent theSearch = SearchEventCache.getEvent(eventID);
        if (theSearch == null) {
            prop.put("pagination", false);
        } else {
            prop.put("pagination", true);
            RequestHeader.FileType fileType = header.fileType();
            if (jsResort) {
                prop.put("pagination_hidePagination", true);
                prop.put("pagination_prevDisabled", true);
                prop.put("pagination_pages", 0L);
                prop.put("pagination_nextDisabled", true);
            } else {
                int startRecord = post.getInt("offset", 0);
                int totalCount = theSearch.getResultCount();
                int activePage = (int)Math.floor((double)startRecord / (double)itemsPerPage);
                int firstLinkedPage = activePage - activePage % 10;
                int totalPagesNb = (int)Math.floor(1.0 + (double)(totalCount - 1) / (double)itemsPerPage);
                int displayedPagesNb = Math.min(10, totalPagesNb - firstLinkedPage);
                prop.put("pagination_prevDisabled", activePage == 0);
                prop.putUrlEncoded(fileType, "pagination_prevDisabled_prevHref", QueryParams.navurl(fileType, Math.max(activePage - 1, 0), theSearch.query, null, false, authFeatures).toString());
                prop.put("pagination_hidePagination", totalPagesNb <= 1 || displayedPagesNb < 1);
                for (int i = 0; i < displayedPagesNb; ++i) {
                    if (activePage == firstLinkedPage + i) {
                        prop.put("pagination_pages_" + i + "_active", true);
                    } else {
                        prop.put("pagination_pages_" + i + "_active", false);
                        prop.put("pagination_pages_" + i + "_active_pageIndex", firstLinkedPage + i);
                        prop.putUrlEncoded(fileType, "pagination_pages_" + i + "_active_href", QueryParams.navurl(fileType, firstLinkedPage + i, theSearch.query, null, false, authFeatures).toString());
                    }
                    prop.put("pagination_pages_" + i + "_pageNum", (long)(firstLinkedPage + i) + 1L);
                }
                prop.put("pagination_pages", displayedPagesNb);
                boolean localQuery = theSearch.query.isLocal();
                if (localQuery && activePage >= totalPagesNb - 1 || !localQuery && activePage >= displayedPagesNb - 1) {
                    prop.put("pagination_nextDisabled", true);
                } else {
                    prop.put("pagination_nextDisabled", false);
                    prop.putUrlEncoded(fileType, "pagination_nextDisabled_nextHref", QueryParams.navurl(fileType, activePage + 1, theSearch.query, null, false, authFeatures).toString());
                }
            }
        }
        return prop;
    }
}

