/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.yacy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.feed.RSSMessage;
import net.yacy.cora.federate.yacy.Distribution;
import net.yacy.cora.order.ByteOrder;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.Memory;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.data.word.Word;
import net.yacy.kelondro.data.word.WordReferenceRow;
import net.yacy.kelondro.index.RowHandleSet;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.kelondro.util.MemoryControl;
import net.yacy.peers.EventChannel;
import net.yacy.peers.Network;
import net.yacy.peers.Protocol;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public final class transferRWI {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        float maxload;
        Switchboard sb = (Switchboard)env;
        String clientip = header.getRemoteAddr();
        String userAgent = header.get("User-Agent", "<unknown>");
        if (clientip != null) {
            sb.peers.peerActions.setUserAgent(clientip, userAgent);
        }
        serverObjects prop = new serverObjects();
        String contentType = header.getContentType();
        prop.put("unknownURL", "");
        prop.put("pause", 60000L);
        String result = "";
        if (post == null || env == null) {
            result = "post or env is null!";
            transferRWI.logWarning(contentType, result);
            prop.put("result", result);
            return prop;
        }
        if (!Protocol.authentifyRequest(post, env)) {
            result = "not authentified";
            prop.put("result", result);
            return prop;
        }
        if (!post.containsKey("wordc")) {
            result = "missing wordc";
            prop.put("result", result);
            return prop;
        }
        if (!post.containsKey("entryc")) {
            result = "missing entryc";
            prop.put("result", result);
            return prop;
        }
        if (!post.containsKey("indexes")) {
            result = "missing indexes";
            prop.put("result", result);
            return prop;
        }
        float maxReceiveLoad = sb.getConfigFloat("20_dhtreceive_loadprereq", 2.0f);
        if (Memory.getSystemLoadAverage() > (double)maxReceiveLoad || MemoryControl.shortStatus()) {
            result = "too high load";
            prop.put("result", result);
            return prop;
        }
        String iam = post.get("iam", "");
        String youare = post.get("youare", "");
        int wordc = post.getInt("wordc", 0);
        int entryc = post.getInt("entryc", 0);
        byte[] indexes = post.get("indexes", "").getBytes();
        boolean granted = sb.getConfigBool("allowReceiveIndex", false);
        boolean blockBlacklist = sb.getConfigBool("indexReceiveBlockBlacklist", false);
        long cachelimit = sb.getConfigLong("wordCacheMaxCount", 100000L);
        Seed otherPeer = sb.peers.get(iam);
        String otherPeerName = iam + ":" + (String)(otherPeer == null ? "NULL" : otherPeer.getName() + "/" + otherPeer.getVersion());
        int pause = 0;
        result = "ok";
        StringBuilder unknownURLs = new StringBuilder(6000);
        double load = Memory.getSystemLoadAverage();
        if (load > (double)(maxload = sb.getConfigFloat("20_dhtdistribution_loadprereq", 2.0f))) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ", system has too high load = " + load + ", maxload = " + maxload);
            result = "not_granted";
            pause = (int)(load * 20000.0);
        } else if (youare == null || !youare.equals(sb.peers.mySeed().hash)) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". Wrong target. Wanted peer=" + youare + ", iam=" + sb.peers.mySeed().hash);
            result = "wrong_target";
            pause = 0;
        } else if (otherPeer == null) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". Not granted. Other Peer is unknown");
            result = "not_granted";
            pause = 60000;
        } else if (!granted) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". Granted is false");
            result = "not_granted";
            pause = 60000;
        } else if (sb.isRobinsonMode()) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". Not granted. This peer is in robinson mode");
            result = "not_granted";
            pause = 60000;
        } else if ((long)sb.index.RWIBufferCount() > cachelimit) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". We are too busy (buffersize=" + sb.index.RWIBufferCount() + ").");
            granted = false;
            result = "busy";
            pause = 60000;
        } else if (otherPeer.getVersion() < 0.75005845 && otherPeer.getVersion() >= 0.75005821) {
            sb.getLog().info("Rejecting RWIs from peer " + otherPeerName + ". Bad version.");
            result = "not_granted";
            pause = 1800000;
        } else {
            if (sb.getLog().isFine()) {
                sb.getLog().fine("Processing " + indexes.length + " bytes / " + wordc + " words / " + entryc + " entries from " + otherPeerName);
            }
            long startProcess = System.currentTimeMillis();
            Iterator<String> it = FileUtils.strings(indexes);
            indexes = null;
            RowHandleSet unknownURL = new RowHandleSet(12, (ByteOrder)Word.commonHashOrder, 0);
            ArrayList<String> wordhashes = new ArrayList<String>();
            int received = 0;
            int blocked = 0;
            int count = 0;
            HashSet<String> testids = new HashSet<String>();
            while (it.hasNext()) {
                String estring = it.next();
                if (++count > 1000) break;
                int p = estring.indexOf(123, 0);
                if (p < 0 || estring.indexOf("x=", 0) < 0 || estring.indexOf("[B@", 0) >= 0) {
                    ++blocked;
                    continue;
                }
                String wordHash = estring.substring(0, p);
                wordhashes.add(wordHash);
                WordReferenceRow iEntry = new WordReferenceRow(estring.substring(p));
                byte[] urlHash = iEntry.urlhash();
                if (blockBlacklist && Switchboard.urlBlacklist.hashInBlacklistedCache(Blacklist.BlacklistType.DHT, urlHash)) {
                    Network.log.fine("transferRWI: blocked blacklisted URLHash '" + ASCII.String(urlHash) + "' from peer " + otherPeerName);
                    ++blocked;
                    continue;
                }
                String urlRejectReason = sb.crawlStacker.urlInAcceptedDomainHash(urlHash);
                if (urlRejectReason != null) {
                    Network.log.warn("transferRWI: blocked URL hash '" + ASCII.String(urlHash) + "' (" + (String)urlRejectReason + ") from peer " + otherPeerName + "; peer is suspected to be a spam-peer (or something is wrong)");
                    ++blocked;
                    continue;
                }
                try {
                    sb.index.storeRWI(ASCII.getBytes(wordHash), iEntry);
                }
                catch (Exception e) {
                    ConcurrentLog.logException(e);
                }
                testids.add(ASCII.String(urlHash));
                ++received;
            }
            for (String id : testids) {
                try {
                    if (sb.index.fulltext().exists(id)) continue;
                    unknownURL.put(ASCII.getBytes(id));
                }
                catch (SpaceExceededException e) {
                    sb.getLog().warn("transferRWI: DB-Error while trying to determine if URL with hash '" + id + "' is known.", e);
                }
            }
            sb.peers.mySeed().incRI(received);
            Iterator<byte[]> bit = unknownURL.iterator();
            unknownURLs.ensureCapacity(unknownURL.size() * 25);
            while (bit.hasNext()) {
                unknownURLs.append(UTF8.String(bit.next())).append(',');
            }
            if (unknownURLs.length() > 0) {
                unknownURLs.setLength(unknownURLs.length() - 1);
            }
            if (wordhashes.isEmpty() || received == 0) {
                sb.getLog().info("Received 0 RWIs from " + otherPeerName + ", processed in " + (System.currentTimeMillis() - startProcess) + " milliseconds, requesting " + unknownURL.size() + " URLs, blocked " + blocked + " RWIs");
            } else {
                String firstHash = (String)wordhashes.get(0);
                String lastHash = (String)wordhashes.get(wordhashes.size() - 1);
                long avdist = (Distribution.horizontalDHTDistance(firstHash.getBytes(), ASCII.getBytes(sb.peers.mySeed().hash)) + Distribution.horizontalDHTDistance(lastHash.getBytes(), ASCII.getBytes(sb.peers.mySeed().hash))) / 2L;
                sb.getLog().info("Received " + received + " RWIs, " + wordc + " Words [" + firstHash + " .. " + lastHash + "], processed in " + (System.currentTimeMillis() - startProcess) + " milliseconds, " + avdist + ", blocked " + blocked + ", requesting " + unknownURL.size() + "/" + received + " URLs from " + otherPeerName);
                EventChannel.channels(EventChannel.DHTRECEIVE).addMessage(new RSSMessage("Received " + received + " RWIs, " + wordc + " Words [" + firstHash + " .. " + lastHash + "], processed in " + (System.currentTimeMillis() - startProcess) + " milliseconds, " + avdist + ", blocked " + blocked + ", requesting " + unknownURL.size() + "/" + received + " URLs from " + otherPeerName, "", otherPeer.hash));
            }
            result = "ok";
            pause = (int)((long)(sb.index.RWIBufferCount() * 20000) / sb.getConfigLong("wordCacheMaxCount", 100000L));
        }
        prop.put("unknownURL", unknownURLs.toString());
        prop.put("result", result);
        prop.put("pause", pause);
        return prop;
    }

    private static void logWarning(String requestIdentifier, String msg) {
        ConcurrentLog.warn("transferRWI", requestIdentifier + " " + msg);
    }
}

