/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot.api.bookmarks.tags;

import java.util.Iterator;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.data.BookmarksDB;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class getTag {
    static final int SORT_ALPHA = 1;
    static final int SORT_SIZE = 2;
    static final int SHOW_ALL = -1;

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard switchboard = (Switchboard)env;
        boolean isAdmin = switchboard.verifyAuthentication(header);
        serverObjects prop = new serverObjects();
        Iterator<BookmarksDB.Tag> it = null;
        String tagName = "";
        int top = -1;
        int comp = 1;
        if (post != null) {
            if (!isAdmin && post.containsKey("login")) {
                prop.authenticationRequired();
            }
            if (post.containsKey("top")) {
                top = post.getInt("top", -1);
            }
            if (post.containsKey("sort") && "size".equals(post.get("sort"))) {
                comp = 2;
            }
        }
        if (post != null && post.containsKey("tag")) {
            tagName = post.get("tag");
            if (!tagName.isEmpty()) {
                it = switchboard.bookmarksDB.getTagIterator(tagName, isAdmin, comp, top);
            }
        } else {
            it = switchboard.bookmarksDB.getTagIterator(isAdmin, comp, top);
        }
        int count = 0;
        if (it != null) {
            while (it.hasNext()) {
                BookmarksDB.Tag tag = it.next();
                if (tag.getTagName().startsWith("/")) continue;
                prop.putXML("tags_" + count + "_name", tag.getTagName());
                prop.put("tags_" + count + "_count", tag.size());
                ++count;
            }
        }
        prop.put("tags", count);
        return prop;
    }
}

