/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.kelondro.logging.GuiHandler;
import net.yacy.kelondro.logging.LogalizerHandler;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class ViewLog_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        String[] log = new String[]{};
        boolean reversed = true;
        boolean json = false;
        int maxlines = 10000;
        int lines = 10000;
        String filter = ".*.*";
        if (post != null) {
            reversed = post.containsKey("mode") && "reversed".equals(post.get("mode"));
            json = post.containsKey("json");
            if (post.containsKey("lines")) {
                lines = post.getInt("lines", lines);
            }
            if (post.containsKey("filter")) {
                filter = post.get("filter");
            }
        }
        Logger logger = Logger.getLogger("");
        Handler[] handlers = logger.getHandlers();
        boolean displaySubmenu = false;
        for (Handler handler : handlers) {
            if (handler instanceof GuiHandler) {
                maxlines = ((GuiHandler)handler).getSize();
                if (lines > maxlines) {
                    lines = maxlines;
                }
                log = ((GuiHandler)handler).getLogLines(reversed, lines);
                continue;
            }
            if (!(handler instanceof LogalizerHandler)) continue;
            displaySubmenu = true;
        }
        prop.put("submenu", displaySubmenu ? "1" : "0");
        prop.put("reverseChecked", reversed ? "1" : "0");
        prop.put("lines", lines);
        prop.put("maxlines", maxlines);
        prop.putHTML("filter", filter);
        Matcher filterMatcher = null;
        try {
            Pattern filterPattern = Pattern.compile(filter, 8);
            filterMatcher = filterPattern.matcher("");
        }
        catch (PatternSyntaxException e) {
            ConcurrentLog.logException(e);
        }
        int level = 0;
        int lc = 0;
        for (String logLine : log) {
            if (logLine == null) break;
            String nextLogLine = logLine.trim();
            if (filterMatcher != null) {
                filterMatcher.reset(nextLogLine);
                if (!filterMatcher.find()) continue;
            }
            if (nextLogLine.startsWith("E ")) {
                level = 4;
            } else if (nextLogLine.startsWith("W ")) {
                level = 3;
            } else if (nextLogLine.startsWith("S ")) {
                level = 2;
            } else if (nextLogLine.startsWith("I ")) {
                level = 1;
            } else if (nextLogLine.startsWith("D ")) {
                level = 0;
            }
            prop.put("log_" + lc + "_level", level);
            if (json) {
                prop.putJSON("log_" + lc + "_line", nextLogLine);
            } else {
                prop.putHTML("log_" + lc + "_line", nextLogLine);
            }
            ++lc;
        }
        prop.put("log", lc);
        return prop;
    }
}

