/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.cora.util.SpaceExceededException;
import net.yacy.kelondro.blob.Tables;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class Tables_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        String table;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String ext = header.get("EXT", "");
        boolean xml = ext.equals("xml");
        prop.put("showtable", 0L);
        prop.put("showedit", 0L);
        prop.put("showselection", 0L);
        String string = table = post == null ? null : post.get("table", "");
        if (table != null && table.length() > 0 && !sb.tables.hasHeap(table)) {
            table = null;
        }
        int count = 0;
        Iterator<String> ti = sb.tables.iterator();
        prop.put("showselection", 1L);
        while (ti.hasNext()) {
            String tablename = ti.next();
            prop.put("showselection_tables_" + count + "_name", tablename);
            prop.put("showselection_tables_" + count + "_selected", table != null && table.length() > 0 && table.equals(tablename) ? 1L : 0L);
            ++count;
        }
        prop.put("showselection_tables", count);
        prop.put("showselection_pattern", "");
        prop.put("showselection_reverse", 1L);
        if (post == null) {
            return prop;
        }
        String counts = post.get("count", "");
        int maxcount = counts == null || counts.length() == 0 || counts.equals("all") ? Integer.MAX_VALUE : post.getInt("count", 10);
        boolean reverse = post.containsKey("reverse") ? post.getBoolean("reverse") : false;
        prop.put("showselection_reverse", reverse ? 1L : 0L);
        String pattern = post.get("search", "");
        Pattern matcher = pattern.isEmpty() || pattern.equals(".*") ? null : Pattern.compile(".*" + pattern + ".*");
        prop.put("pattern", pattern);
        if (post.get("deletetable", "").length() > 0) {
            sb.tables.clear(table);
        }
        if (post.get("deleterows", "").length() > 0) {
            for (Map.Entry<String, String> entry2 : post.entrySet()) {
                if (!entry2.getValue().startsWith("pk_")) continue;
                try {
                    sb.tables.delete(table, entry2.getValue().substring(3).getBytes());
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
            }
        }
        if (post.get("commitrow", "").length() > 0) {
            String pk = post.get("pk");
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            for (Map.Entry<String, String> entry3 : post.entrySet()) {
                if (!entry3.getKey().startsWith("col_")) continue;
                map.put(entry3.getKey().substring(4), entry3.getValue().getBytes());
            }
            try {
                sb.tables.update(table, pk.getBytes(), map);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
        }
        prop.put("showtable", 0L);
        prop.put("showedit", 0L);
        if (table != null) {
            String pk;
            ArrayList<String> columns = null;
            try {
                columns = sb.tables.columns(table);
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
                columns = new ArrayList();
            }
            if (post.containsKey("editrow")) {
                pk = null;
                for (Map.Entry<String, String> entry3 : post.entrySet()) {
                    if (!entry3.getValue().startsWith("pk_")) continue;
                    pk = entry3.getValue().substring(3);
                    break;
                }
                try {
                    if (pk != null && sb.tables.has(table, pk.getBytes())) {
                        Tables_p.setEdit(sb, prop, table, pk, columns);
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            } else if (post.containsKey("addrow")) {
                try {
                    pk = UTF8.String(sb.tables.createRow(table));
                    Tables_p.setEdit(sb, prop, table, pk, columns);
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                catch (SpaceExceededException e) {
                    ConcurrentLog.logException(e);
                }
            } else {
                prop.put("showtable", 1L);
                prop.put("showtable_table", table);
                for (int i = 0; i < columns.size(); ++i) {
                    prop.putHTML("showtable_columns_" + i + "_header", (String)columns.get(i));
                }
                prop.put("showtable_columns", columns.size());
                try {
                    maxcount = Math.min(maxcount, sb.tables.size(table));
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                    maxcount = 0;
                }
                count = 0;
                try {
                    Iterator<Tables.Row> plainIterator = sb.tables.iterator(table, matcher, !reverse);
                    boolean dark = true;
                    prop.putXML("showtable_" + count + "_table", table);
                    while (plainIterator.hasNext() && count < maxcount) {
                        byte[] cell;
                        String col;
                        int i;
                        Tables.Row row = plainIterator.next();
                        if (row == null) continue;
                        prop.put("showtable_list_" + count + "_dark", dark ? 1 : 0);
                        dark = !dark;
                        prop.put("showtable_list_" + count + "_pk", UTF8.String(row.getPK()));
                        prop.put("showtable_list_" + count + "_count", count);
                        prop.put("showtable_list_" + count + "_table", table);
                        if (xml) {
                            for (i = 0; i < columns.size(); ++i) {
                                col = (String)columns.get(i);
                                cell = (byte[])row.get(col);
                                prop.putXML("showtable_list_" + count + "_columns_" + i + "_cell", cell == null ? "" : UTF8.String(cell));
                                prop.putXML("showtable_list_" + count + "_columns_" + i + "_col", col);
                            }
                        } else {
                            for (i = 0; i < columns.size(); ++i) {
                                col = (String)columns.get(i);
                                cell = (byte[])row.get(col);
                                prop.putHTML("showtable_list_" + count + "_columns_" + i + "_cell", cell == null ? "" : UTF8.String(cell));
                            }
                        }
                        prop.put("showtable_list_" + count + "_columns", columns.size());
                        ++count;
                    }
                }
                catch (IOException e) {
                    ConcurrentLog.logException(e);
                }
                prop.put("showtable_list", count);
                prop.put("showtable_num", count);
            }
        }
        return prop;
    }

    private static void setEdit(Switchboard sb, serverObjects prop, String table, String pk, List<String> columns) throws IOException, SpaceExceededException {
        prop.put("showedit", 1L);
        prop.put("showedit_table", table);
        prop.put("showedit_pk", pk);
        Tables.Row row = sb.tables.select(table, pk.getBytes());
        if (row == null) {
            return;
        }
        int count = 0;
        for (String col : columns) {
            byte[] cell = (byte[])row.get(col);
            prop.put("showedit_list_" + count + "_key", col);
            prop.put("showedit_list_" + count + "_value", cell == null ? "" : UTF8.String(cell));
            ++count;
        }
        prop.put("showedit_list", count);
    }
}

