/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.time.Instant;
import java.util.Date;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.HeaderFramework;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.protocol.http.HTTPClient;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.data.TransactionManager;
import net.yacy.data.WorkTables;
import net.yacy.document.importer.MediawikiImporter;
import net.yacy.kelondro.blob.Tables;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class IndexImportMediawiki_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        serverObjects prop = new serverObjects();
        Switchboard sb = (Switchboard)env;
        if (MediawikiImporter.job != null && (MediawikiImporter.job.isAlive() || post != null && post.containsKey("report"))) {
            prop.put("import", 1L);
            prop.put("refresh", MediawikiImporter.job.isAlive() ? 1L : 0L);
            String jobErrorMessage = MediawikiImporter.job.status();
            if (jobErrorMessage != null && !jobErrorMessage.isEmpty()) {
                prop.put("import_status", 1L);
                prop.put("import_status_message", jobErrorMessage);
            }
            prop.put("import_thread", MediawikiImporter.job.isAlive() ? 2L : 0L);
            prop.put("import_dump", MediawikiImporter.job.source());
            prop.put("import_count", MediawikiImporter.job.count());
            prop.put("import_speed", MediawikiImporter.job.speed());
            prop.put("import_runningHours", MediawikiImporter.job.runningTime() / 60L / 60L);
            prop.put("import_runningMinutes", MediawikiImporter.job.runningTime() / 60L % 60L);
            prop.put("import_remainingHours", MediawikiImporter.job.remainingTime() / 60L / 60L);
            prop.put("import_remainingMinutes", MediawikiImporter.job.remainingTime() / 60L % 60L);
        } else {
            prop.put("import", 0L);
            prop.put("refresh", 0L);
            prop.put("import_prevReport", MediawikiImporter.job != null ? 1L : 0L);
            if (post == null) {
                prop.put("import_status", 0L);
                String token = TransactionManager.getTransactionToken(header);
                prop.put("transactionToken", token);
                prop.put("import_transactionToken", token);
            } else if (post.containsKey("file")) {
                TransactionManager.checkPostTransaction(header, post);
                String file = post.get("file");
                MultiProtocolURL sourceURL = null;
                int status = 0;
                String sourceFilePath = "";
                Tables.Row lastExecutedCall = WorkTables.selectLastExecutedApiCall("IndexImportMediawiki_p.html", post, sb);
                Date lastExecutionDate = null;
                if (lastExecutedCall != null) {
                    lastExecutionDate = lastExecutedCall.get("date_last_exec", (Date)null);
                }
                try {
                    sourceURL = new MultiProtocolURL(file);
                    if (sourceURL.isFile()) {
                        File sourcefile = sourceURL.getFSFile();
                        sourceFilePath = sourcefile.getAbsolutePath();
                        if (!sourcefile.exists()) {
                            status = 2;
                        } else if (!sourcefile.canRead()) {
                            status = 3;
                        } else if (sourcefile.isDirectory()) {
                            status = 4;
                        }
                    }
                    if (status == 0 && post.getBoolean("iffresh")) {
                        long lastModified = IndexImportMediawiki_p.getLastModified(sourceURL);
                        if (lastExecutionDate != null && lastModified != 0L && Instant.ofEpochMilli(lastModified).isBefore(lastExecutionDate.toInstant())) {
                            status = 5;
                            prop.put("import_status_lastImportDate", GenericFormatter.formatSafely(lastExecutionDate.toInstant(), GenericFormatter.FORMAT_SIMPLE));
                            if (sb.tables != null) {
                                byte[] lastExecutedCallPk = lastExecutedCall.getPK();
                                if (lastExecutedCallPk != null && !post.containsKey("apicall_pk")) {
                                    post.add("apicall_pk", UTF8.String(lastExecutedCallPk));
                                }
                                sb.tables.recordAPICall(post, "IndexImportMediawiki_p.html", "dump", "MediaWiki Dump Import for " + String.valueOf(sourceURL));
                            }
                        }
                    }
                }
                catch (MalformedURLException e) {
                    status = 1;
                }
                if (status == 0) {
                    if (sb.tables != null) {
                        byte[] lastExecutedCallPk;
                        if (lastExecutedCall != null && !post.containsKey("apicall_pk") && (lastExecutedCallPk = lastExecutedCall.getPK()) != null) {
                            post.add("apicall_pk", UTF8.String(lastExecutedCallPk));
                        }
                        sb.tables.recordAPICall(post, "IndexImportMediawiki_p.html", "dump", "MediaWiki Dump Import for " + String.valueOf(sourceURL));
                    }
                    MediawikiImporter.job = new MediawikiImporter(sourceURL, sb.packsLoadPath);
                    MediawikiImporter.job.start();
                    prop.put("import_dump", MediawikiImporter.job.source());
                    prop.put("import_thread", 1L);
                    prop.put("import", 1L);
                    prop.put("refresh", 1L);
                } else {
                    prop.put("import_status", status);
                    prop.put("import_status_sourceFile", sourceFilePath);
                    String token = TransactionManager.getTransactionToken(header);
                    prop.put("transactionToken", token);
                    prop.put("import_transactionToken", token);
                }
                prop.put("import_count", 0L);
                prop.put("import_speed", 0L);
                prop.put("import_runningHours", 0L);
                prop.put("import_runningMinutes", 0L);
                prop.put("import_remainingHours", 0L);
                prop.put("import_remainingMinutes", 0L);
            }
        }
        return prop;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getLastModified(MultiProtocolURL fileURL) {
        try {
            if (!fileURL.isHTTP()) {
                if (!fileURL.isHTTPS()) return fileURL.lastModified();
            }
            try (HTTPClient httpClient = new HTTPClient(ClientIdentification.yacyInternetCrawlerAgent);){
                HttpResponse headResponse = httpClient.HEADResponse(fileURL, false);
                if (headResponse == null) return 0L;
                if (headResponse.getStatusLine() == null) return 0L;
                if (headResponse.getStatusLine().getStatusCode() != 200) return 0L;
                Header lastModifiedHeader = headResponse.getFirstHeader("Last-Modified");
                if (lastModifiedHeader == null) return 0L;
                Date lastModifiedDate = HeaderFramework.parseHTTPDate(lastModifiedHeader.getValue());
                if (lastModifiedDate == null) return 0L;
                long l = lastModifiedDate.getTime();
                return l;
            }
        }
        catch (IOException ignored) {
            ConcurrentLog.warn("IndexImportMediawiki_p", "Could not retrieve last modified date for dump file at " + String.valueOf(fileURL));
        }
        return 0L;
    }
}

