/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.document.id.MultiProtocolURL;
import net.yacy.cora.federate.yacy.CacheStrategy;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.sorting.ReversibleScoreMap;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.Cache;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.data.TransactionManager;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.search.Switchboard;
import net.yacy.search.index.Fulltext;
import net.yacy.search.index.Segment;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class IndexControlURLs_p {
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Object url;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        String nextTransactionToken = TransactionManager.getTransactionToken(header);
        prop.put("transactionToken", nextTransactionToken);
        Segment segment = sb.index;
        long ucount = segment.fulltext().collectionSize();
        prop.put("urlstring", "");
        prop.put("urlhash", "");
        prop.put("result", "");
        prop.put("otherHosts", "");
        prop.put("genUrlProfile", 0L);
        prop.put("statistics", 1L);
        prop.put("statistics_lines", 100L);
        prop.put("statisticslines", 0L);
        prop.put("reload", 0L);
        prop.put("reload", 0L);
        prop.put("dumprestore", 1L);
        prop.put("dumprestore_transactionToken", nextTransactionToken);
        List<File> dumpFiles = segment.fulltext().dumpFiles();
        prop.put("dumprestore_dumpfile", dumpFiles.size() == 0 ? "" : dumpFiles.get(dumpFiles.size() - 1).getAbsolutePath());
        prop.put("dumprestore_optimizemax", 10L);
        prop.put("dumprestore_rebootSolrEnabled", sb.getConfigBool("core.service.fulltext", true) && !sb.getConfigBool("federated.service.solr.indexing.enabled", false));
        prop.put("cleanup", ucount == 0L ? 0L : 1L);
        prop.put("cleanupsolr", segment.fulltext().connectedRemoteSolr() ? 1L : 0L);
        prop.put("cleanuprwi", segment.termIndex() != null && !segment.termIndex().isEmpty() ? 1L : 0L);
        prop.put("cleanupcitation", segment.connectedCitation() && !segment.urlCitation().isEmpty() ? 1L : 0L);
        if (post == null || env == null) {
            prop.putNum("ucount", ucount);
            return prop;
        }
        Object urlstring = post.get("urlstring", "").trim();
        String urlhash = post.get("urlhash", "").trim();
        if (urlhash.isEmpty() && ((String)urlstring).length() > 0) {
            try {
                urlhash = ASCII.String(new DigestURL((String)urlstring).hash());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!(((String)urlstring).startsWith("http://") || ((String)urlstring).startsWith("https://") || ((String)urlstring).startsWith("ftp://") || ((String)urlstring).startsWith("smb://") || ((String)urlstring).startsWith("file://"))) {
            urlstring = "http://" + (String)urlstring;
        }
        prop.putHTML("urlstring", (String)urlstring);
        prop.putHTML("urlhash", urlhash);
        prop.put("result", " ");
        if (post.containsKey("deletecomplete")) {
            TransactionManager.checkPostTransaction(header, post);
            if (post.get("deleteIndex", "").equals("on")) {
                try {
                    segment.fulltext().clearLocalSolr();
                    segment.loadTimeIndex().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (post.get("deleteRemoteSolr", "").equals("on")) {
                try {
                    segment.fulltext().clearRemoteSolr();
                    segment.loadTimeIndex().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (post.get("deleteRWI", "").equals("on") && segment.termIndex() != null) {
                try {
                    segment.termIndex().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (post.get("deleteCitation", "").equals("on") && segment.connectedCitation()) {
                try {
                    segment.urlCitation().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (post.get("deleteFirstSeen", "").equals("on")) {
                try {
                    segment.firstSeenIndex().clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (post.get("deleteCrawlQueues", "").equals("on")) {
                sb.crawlQueues.clear();
                sb.crawlStacker.clear();
                ResultURLs.clearStacks();
            }
            if (post.get("deleteCache", "").equals("on")) {
                Cache.clear();
            }
            if (post.get("deleteRobots", "").equals("on")) {
                try {
                    sb.robots.clear();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            post.remove("deletecomplete");
        }
        if (post.containsKey("urlhashdeleteall")) {
            TransactionManager.checkPostTransaction(header, post);
            ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
            int i = segment.removeAllUrlReferences(urlhash.getBytes(), sb.loader, agent, CacheStrategy.IFEXIST);
            try {
                segment.loadTimeIndex().remove(urlhash.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            prop.put("result", "Deleted URL and " + i + " references from " + i + " word indexes.");
        }
        if (post.containsKey("urlhashdelete")) {
            TransactionManager.checkPostTransaction(header, post);
            try {
                url = segment.fulltext().getURL(urlhash);
                if (url == null) {
                    prop.putHTML("result", "No Entry for URL hash " + urlhash + "; nothing deleted.");
                } else {
                    prop.put("urlstring", "");
                    sb.urlRemove(segment, urlhash.getBytes());
                    prop.putHTML("result", "Removed URL " + (String)url);
                }
                segment.loadTimeIndex().remove(urlhash.getBytes());
            }
            catch (IOException e) {
                prop.putHTML("result", "Error when querying the url hash " + urlhash + ":" + e.getMessage());
            }
        }
        if (post.containsKey("urldelete")) {
            TransactionManager.checkPostTransaction(header, post);
            try {
                urlhash = ASCII.String(new DigestURL((String)urlstring).hash());
            }
            catch (MalformedURLException e) {
                urlhash = null;
            }
            if (urlhash == null || urlstring == null) {
                prop.put("result", "No input given; nothing deleted.");
            } else {
                sb.urlRemove(segment, urlhash.getBytes());
                try {
                    segment.loadTimeIndex().remove(urlhash.getBytes());
                }
                catch (IOException e) {
                    // empty catch block
                }
                prop.putHTML("result", "Removed URL " + (String)urlstring);
            }
        }
        if (post.containsKey("urlstringsearch")) {
            try {
                url = new DigestURL((String)urlstring);
                urlhash = ASCII.String(((DigestURL)url).hash());
                prop.put("urlhash", urlhash);
                URIMetadataNode entry2 = segment.fulltext().getMetadata(ASCII.getBytes(urlhash));
                if (entry2 == null) {
                    prop.putHTML("result", "No Entry for URL " + ((MultiProtocolURL)url).toNormalform(true));
                    prop.putHTML("urlstring", (String)urlstring);
                    prop.put("urlhash", "");
                } else {
                    prop.putAll(IndexControlURLs_p.genUrlProfile(segment, entry2, urlhash, nextTransactionToken));
                    prop.put("statistics", 0L);
                }
            }
            catch (MalformedURLException e) {
                prop.putHTML("result", "bad url: " + (String)urlstring);
                prop.put("urlhash", "");
            }
        }
        if (post.containsKey("urlhashsearch")) {
            URIMetadataNode entry3 = segment.fulltext().getMetadata(ASCII.getBytes(urlhash));
            if (entry3 == null) {
                prop.putHTML("result", "No Entry for URL hash " + urlhash);
            } else {
                prop.putHTML("urlstring", entry3.url().toNormalform(true));
                prop.putAll(IndexControlURLs_p.genUrlProfile(segment, entry3, urlhash, nextTransactionToken));
                prop.put("statistics", 0L);
            }
        }
        if (post.containsKey("optimizesolr")) {
            TransactionManager.checkPostTransaction(header, post);
            int size = post.getInt("optimizemax", 10);
            segment.fulltext().optimize(size);
            sb.tables.recordAPICall(post, "IndexControlURLs_p.html", "steering", "solr optimize " + size);
        }
        if (post.containsKey("rebootsolr")) {
            TransactionManager.checkPostTransaction(header, post);
            if (sb.getConfigBool("core.service.fulltext", true) && !sb.getConfigBool("federated.service.solr.indexing.enabled", false)) {
                segment.fulltext().rebootEmbeddedLocalSolr();
                sb.tables.recordAPICall(post, "IndexControlURLs_p.html", "steering", "solr reboot");
            }
        }
        if (post.containsKey("deletedomain")) {
            TransactionManager.checkPostTransaction(header, post);
            String domain = post.get("domain");
            HashSet<String> hostnames = new HashSet<String>();
            hostnames.add(domain);
            segment.fulltext().deleteStaleDomainNames(hostnames, null);
            try {
                segment.loadTimeIndex().clear();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            post.put("statistics", "");
        }
        if (post.containsKey("statistics")) {
            int cnt;
            int count = post.getInt("lines", 100);
            prop.put("statistics_lines", count);
            try {
                Fulltext metadata = segment.fulltext();
                LinkedHashMap<String, ReversibleScoreMap<String>> scores = metadata.getDefaultConnector().getFacets(CollectionSchema.httpstatus_i.getSolrFieldName() + ":200", count, CollectionSchema.host_s.getSolrFieldName());
                ReversibleScoreMap stats = (ReversibleScoreMap)scores.get(CollectionSchema.host_s.getSolrFieldName());
                Iterator statsiter = stats.keys(false);
                boolean dark = true;
                prop.put("statisticslines_domains_" + cnt + "lines", count);
                for (cnt = 0; statsiter.hasNext() && cnt < count; ++cnt) {
                    String hostname = (String)statsiter.next();
                    prop.put("statisticslines_domains_" + cnt + "_transactionToken", nextTransactionToken);
                    prop.put("statisticslines_domains_" + cnt + "_dark", dark ? "1" : "0");
                    prop.put("statisticslines_domains_" + cnt + "_domain", hostname);
                    prop.put("statisticslines_domains_" + cnt + "_count", stats.get(hostname));
                    dark = !dark;
                }
            }
            catch (IOException e) {
                ConcurrentLog.logException(e);
            }
            prop.put("statisticslines_domains", cnt);
            prop.put("statisticslines", 1L);
        }
        prop.putNum("ucount", ucount);
        return prop;
    }

    private static serverObjects genUrlProfile(Segment segment, URIMetadataNode entry2, String urlhash, String nextTransactionToken) {
        URIMetadataNode le;
        serverObjects prop = new serverObjects();
        if (entry2 == null) {
            prop.put("genUrlProfile", "1");
            prop.put("genUrlProfile_urlhash", urlhash);
            return prop;
        }
        URIMetadataNode uRIMetadataNode = le = entry2.referrerHash() == null || entry2.referrerHash().length != 12 ? null : segment.fulltext().getMetadata(entry2.referrerHash());
        if (entry2.url() == null) {
            prop.put("genUrlProfile", "1");
            prop.put("genUrlProfile_urlhash", urlhash);
            return prop;
        }
        prop.put("genUrlProfile", "2");
        prop.put("genUrlProfile_transactionToken", nextTransactionToken);
        prop.putHTML("genUrlProfile_urlNormalform", entry2.url().toNormalform(true));
        prop.put("genUrlProfile_urlhash", urlhash);
        prop.put("genUrlProfile_urlDescr", entry2.dc_title());
        prop.put("genUrlProfile_moddate", entry2.moddate().toString());
        prop.put("genUrlProfile_loaddate", entry2.loaddate().toString());
        prop.put("genUrlProfile_referrer", le == null ? 0L : 1L);
        prop.putHTML("genUrlProfile_referrer_url", le == null ? "<unknown>" : le.url().toNormalform(true));
        prop.put("genUrlProfile_referrer_hash", le == null ? "" : ASCII.String(le.hash()));
        prop.put("genUrlProfile_doctype", String.valueOf(entry2.doctype()));
        prop.put("genUrlProfile_language", entry2.language());
        prop.put("genUrlProfile_size", entry2.size());
        prop.put("genUrlProfile_wordCount", entry2.wordCount());
        return prop;
    }
}

