/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.yacy.cora.date.GenericFormatter;
import net.yacy.cora.document.encoding.ASCII;
import net.yacy.cora.document.encoding.UTF8;
import net.yacy.cora.document.id.Punycode;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.data.ResultURLs;
import net.yacy.data.ListManager;
import net.yacy.kelondro.data.meta.URIMetadataNode;
import net.yacy.kelondro.util.FileUtils;
import net.yacy.peers.Seed;
import net.yacy.repository.Blacklist;
import net.yacy.search.Switchboard;
import net.yacy.search.schema.CollectionSchema;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;
import net.yacy.utils.nxTools;

public class CrawlResults {
    private static final String APP_NAME = "PLASMA";
    private static final int DEFAULT_MAXIMUM_LINES = 500;
    private static final DateTimeFormatter DAY_FORMATTER = DateTimeFormatter.ofPattern("uuuu/MM/dd", Locale.US).withZone(ZoneId.systemDefault());

    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        ResultURLs.EventOrigin tabletype;
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        int lines = 500;
        boolean showCollection = sb.index.fulltext().getDefaultConfiguration().isEmpty() || sb.index.fulltext().getDefaultConfiguration().contains(CollectionSchema.collection_sxt);
        boolean showInit = env.getConfigBool("IndexMonitorInit", false);
        boolean showExec = env.getConfigBool("IndexMonitorExec", false);
        boolean showDate = env.getConfigBool("IndexMonitorDate", true);
        boolean showWords = env.getConfigBool("IndexMonitorWords", true);
        boolean showTitle = env.getConfigBool("IndexMonitorTitle", true);
        boolean showCountry = env.getConfigBool("IndexMonitorCountry", false);
        boolean showIP = env.getConfigBool("IndexMonitorIP", false);
        boolean showURL = env.getConfigBool("IndexMonitorURL", true);
        if (post == null) {
            post = new serverObjects();
            post.put("process", "0");
        }
        try {
            tabletype = ResultURLs.EventOrigin.getEvent(post.getInt("process", 0));
        }
        catch (NumberFormatException e) {
            tabletype = ResultURLs.EventOrigin.UNKNOWN;
        }
        if (post != null && post.containsKey("autoforward") && tabletype == ResultURLs.EventOrigin.LOCAL_CRAWLING && ResultURLs.getStackSize(ResultURLs.EventOrigin.LOCAL_CRAWLING) == 0) {
            ResultURLs.EventOrigin eventOrigin = tabletype = ResultURLs.getStackSize(ResultURLs.EventOrigin.PACKS) == 0 ? ResultURLs.EventOrigin.UNKNOWN : ResultURLs.EventOrigin.PACKS;
        }
        if (tabletype != ResultURLs.EventOrigin.UNKNOWN || post != null && (post.containsKey("clearlist") || post.containsKey("deleteentry"))) {
            String authorization = header.get("Authorization", "xxxxxx");
            if (authorization.length() != 0) {
                if (!sb.verifyAuthentication(header)) {
                    prop.authenticationRequired();
                    return prop;
                }
            } else {
                prop.authenticationRequired();
                return prop;
            }
        }
        String selectedblacklist = post.get("selectedblacklist", Blacklist.defaultBlacklist(ListManager.listsPath));
        if (post != null) {
            String domain;
            byte[] hash;
            if (post.containsKey("count")) {
                lines = post.getInt("count", 500);
            }
            if (post.containsKey("clearlist")) {
                ResultURLs.clearStack(tabletype);
            }
            if (post.containsKey("deleteentry") && (hash = post.getBytes("hash")) != null) {
                sb.index.fulltext().remove(hash);
            }
            if ((post.containsKey("deletedomain") || post.containsKey("delandaddtoblacklist")) && (domain = post.get("domain", "")) != null && domain.length() > 0) {
                selectedblacklist = post.get("blacklistname");
                HashSet<String> hostnames = new HashSet<String>();
                hostnames.add(domain);
                sb.index.fulltext().deleteStaleDomainNames(hostnames, null);
                ResultURLs.deleteDomain(tabletype, domain);
                if (post.containsKey("delandaddtoblacklist")) {
                    try {
                        Switchboard.urlBlacklist.add(selectedblacklist, domain, ".*");
                    }
                    catch (Punycode.PunycodeException e) {
                        ConcurrentLog.warn(APP_NAME, "Unable to add blacklist entry to blacklist " + selectedblacklist, e);
                    }
                }
            }
            if (post.containsKey("moreIndexed")) {
                lines = post.getInt("showIndexed", 500);
            }
            if (post.get("si") != null) {
                boolean bl = showInit = !"0".equals(post.get("si"));
            }
            if (post.get("se") != null) {
                boolean bl = showExec = !"0".equals(post.get("se"));
            }
            if (post.get("sd") != null) {
                boolean bl = showDate = !"0".equals(post.get("sd"));
            }
            if (post.get("sw") != null) {
                boolean bl = showWords = !"0".equals(post.get("sw"));
            }
            if (post.get("st") != null) {
                boolean bl = showTitle = !"0".equals(post.get("st"));
            }
            if (post.get("sc") != null) {
                boolean bl = showCountry = !"0".equals(post.get("sc"));
            }
            if (post.get("sp") != null) {
                boolean bl = showIP = !"0".equals(post.get("sp"));
            }
            if (post.get("su") != null) {
                boolean bl = showURL = !"0".equals(post.get("su"));
            }
        }
        if (tabletype == ResultURLs.EventOrigin.UNKNOWN) {
            prop.put("table", "2");
        } else if (ResultURLs.getStackSize(tabletype) == 0 && ResultURLs.getDomainListSize(tabletype) == 0) {
            prop.put("table", "0");
        } else {
            String domain;
            prop.put("table", "1");
            if (lines > ResultURLs.getStackSize(tabletype)) {
                lines = ResultURLs.getStackSize(tabletype);
            }
            if (lines == ResultURLs.getStackSize(tabletype)) {
                prop.put("table_size", "0");
            } else {
                prop.put("table_size", "1");
                prop.put("table_size_count", lines);
                prop.put("table_size_tabletype", tabletype.getCode());
            }
            prop.put("table_size_all", ResultURLs.getStackSize(tabletype));
            prop.putHTML("table_feedbackpage", "CrawlResults.html");
            prop.put("table_tabletype", tabletype.getCode());
            prop.put("table_showCollection", showCollection ? "1" : "0");
            prop.put("table_showInit", showInit ? "1" : "0");
            prop.put("table_showExec", showExec ? "1" : "0");
            prop.put("table_showDate", showDate ? "1" : "0");
            prop.put("table_showWords", showWords ? "1" : "0");
            prop.put("table_showTitle", showTitle ? "1" : "0");
            prop.put("table_showCountry", showCountry ? "1" : "0");
            prop.put("table_showIP", showIP ? "1" : "0");
            prop.put("table_showURL", showURL ? "1" : "0");
            boolean dark = true;
            int cnt = 0;
            Iterator<Map.Entry<String, ResultURLs.InitExecEntry>> i = ResultURLs.results(tabletype);
            while (i.hasNext() && cnt < lines) {
                Map.Entry<String, ResultURLs.InitExecEntry> entry2 = i.next();
                try {
                    String urltxt;
                    String urlstr;
                    byte[] urlhash = UTF8.getBytes(entry2.getKey());
                    URIMetadataNode urle = sb.index.fulltext().getMetadata(urlhash);
                    if (urle == null) {
                        sb.index.fulltext().commit(true);
                        urle = sb.index.fulltext().getMetadata(urlhash);
                    }
                    if (urle == null) {
                        ConcurrentLog.warn(APP_NAME, "CrawlResults: URL not in index with url hash " + entry2.getKey());
                        urlstr = null;
                        urltxt = null;
                        continue;
                    }
                    urlstr = urle.url().toNormalform(true);
                    urltxt = nxTools.shortenURLString(urlstr, 72);
                    Seed initiatorSeed = entry2.getValue() == null || entry2.getValue().initiatorHash == null ? null : sb.peers.getConnected(ASCII.String(entry2.getValue().initiatorHash));
                    Seed executorSeed = entry2.getValue() == null || entry2.getValue().executorHash == null ? null : sb.peers.getConnected(ASCII.String(entry2.getValue().executorHash));
                    prop.put("table_indexed_" + cnt + "_dark", dark ? "1" : "0");
                    prop.put("table_indexed_" + cnt + "_feedbackpage", "CrawlResults.html");
                    prop.put("table_indexed_" + cnt + "_tabletype", tabletype.getCode());
                    prop.put("table_indexed_" + cnt + "_urlhash", entry2.getKey());
                    if (showCollection) {
                        prop.put("table_indexed_" + cnt + "_showCollection", "1");
                        prop.put("table_indexed_" + cnt + "_showCollection_collection", Arrays.toString(urle.collections()));
                    } else {
                        prop.put("table_indexed_" + cnt + "_showCollection", "0");
                    }
                    if (showInit) {
                        prop.put("table_indexed_" + cnt + "_showInit", "1");
                        prop.put("table_indexed_" + cnt + "_showInit_initiatorSeed", initiatorSeed == null ? "unknown" : initiatorSeed.getName());
                    } else {
                        prop.put("table_indexed_" + cnt + "_showInit", "0");
                    }
                    if (showExec) {
                        prop.put("table_indexed_" + cnt + "_showExec", "1");
                        prop.put("table_indexed_" + cnt + "_showExec_executorSeed", executorSeed == null ? "unknown" : executorSeed.getName());
                    } else {
                        prop.put("table_indexed_" + cnt + "_showExec", "0");
                    }
                    if (showDate && urle != null) {
                        prop.put("table_indexed_" + cnt + "_showDate", "1");
                        prop.put("table_indexed_" + cnt + "_showDate_modified", CrawlResults.daydate(urle.moddate()));
                    } else {
                        prop.put("table_indexed_" + cnt + "_showDate", "0");
                    }
                    if (showWords && urle != null) {
                        prop.put("table_indexed_" + cnt + "_showWords", "1");
                        prop.put("table_indexed_" + cnt + "_showWords_count", urle.wordCount());
                    } else {
                        prop.put("table_indexed_" + cnt + "_showWords", "0");
                    }
                    if (showTitle) {
                        prop.put("table_indexed_" + cnt + "_showTitle", showTitle ? "1" : "0");
                        prop.put("table_indexed_" + cnt + "_showTitle_available", "1");
                        if (urle.dc_title() == null || urle.dc_title().trim().isEmpty()) {
                            prop.put("table_indexed_" + cnt + "_showTitle_available_nodescr", "0");
                        } else {
                            prop.put("table_indexed_" + cnt + "_showTitle_available_nodescr", "1");
                            prop.putHTML("table_indexed_" + cnt + "_showTitle_available_nodescr_urldescr", urle.dc_title());
                        }
                        prop.put("table_indexed_" + cnt + "_showTitle_available_urlHash", entry2.getKey());
                        prop.putHTML("table_indexed_" + cnt + "_showTitle_available_urltitle", urlstr);
                    } else {
                        prop.put("table_indexed_" + cnt + "_showTitle", "0");
                    }
                    if (showCountry && urle != null) {
                        prop.put("table_indexed_" + cnt + "_showCountry", "1");
                        prop.put("table_indexed_" + cnt + "_showCountry_country", urle.url().getLocale().getCountry());
                    } else {
                        prop.put("table_indexed_" + cnt + "_showCountry", "0");
                    }
                    if (showIP && urle != null) {
                        prop.put("table_indexed_" + cnt + "_showIP", "1");
                        prop.put("table_indexed_" + cnt + "_showIP_ip", urle.url().getHost() == null ? "" : urle.url().getInetAddress().getHostAddress());
                    } else {
                        prop.put("table_indexed_" + cnt + "_showIP", "0");
                    }
                    if (showURL) {
                        prop.put("table_indexed_" + cnt + "_showURL", "1");
                        prop.put("table_indexed_" + cnt + "_showURL_available", "1");
                        prop.put("table_indexed_" + cnt + "_showURL_available_urlHash", entry2.getKey());
                        prop.putHTML("table_indexed_" + cnt + "_showURL_available_urltitle", urlstr);
                        prop.put("table_indexed_" + cnt + "_showURL_available_url", urltxt);
                    } else {
                        prop.put("table_indexed_" + cnt + "_showURL", "0");
                    }
                    dark = !dark;
                    ++cnt;
                }
                catch (Exception e) {
                    ConcurrentLog.severe(APP_NAME, "genTableProps", e);
                }
            }
            prop.put("table_indexed", cnt);
            dark = true;
            Iterator<String> j = ResultURLs.domains(tabletype);
            for (cnt = 0; j.hasNext() && cnt < 100 && (domain = j.next()) != null; ++cnt) {
                prop.put("table_domains_" + cnt + "_dark", dark ? "1" : "0");
                prop.put("table_domains_" + cnt + "_feedbackpage", "CrawlResults.html");
                prop.put("table_domains_" + cnt + "_tabletype", tabletype.getCode());
                prop.put("table_domains_" + cnt + "_domain", domain);
                prop.put("table_domains_" + cnt + "_count", ResultURLs.domainCount(tabletype, domain));
                prop.put("table_domains_" + cnt + "_blacklistname", selectedblacklist);
                dark = !dark;
            }
            prop.put("table_domains", cnt);
            List<String> dirlist = FileUtils.getDirListing(ListManager.listsPath, "^.*\\.black$");
            int blacklistCount = 0;
            if (dirlist != null) {
                for (String element : dirlist) {
                    if (element.equals(selectedblacklist)) {
                        prop.put("table_blacklists_" + blacklistCount + "_selected", "selected");
                    } else {
                        prop.put("table_blacklists_" + blacklistCount + "_selected", "");
                    }
                    prop.putXML("table_blacklists_" + blacklistCount + "_name", element);
                    ++blacklistCount;
                }
                prop.put("table_blacklists", blacklistCount);
            }
        }
        prop.put("process", tabletype.getCode());
        prop.put("process_remoteCrawlerDisabled", !sb.getConfigBool("crawlResponse", false));
        return prop;
    }

    private static String daydate(Date date) {
        if (date == null) {
            return "";
        }
        return GenericFormatter.formatSafely(date.toInstant(), DAY_FORMATTER);
    }
}

