/*
 * Decompiled with CFR 0.152.
 */
package net.yacy.htroot;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import net.yacy.cora.document.id.DigestURL;
import net.yacy.cora.protocol.ClientIdentification;
import net.yacy.cora.protocol.RequestHeader;
import net.yacy.cora.util.ConcurrentLog;
import net.yacy.crawler.robots.RobotsTxt;
import net.yacy.search.Switchboard;
import net.yacy.server.serverObjects;
import net.yacy.server.serverSwitch;

public class CrawlCheck_p {
    /*
     * WARNING - void declaration
     */
    public static serverObjects respond(RequestHeader header, serverObjects post, serverSwitch env) {
        Switchboard sb = (Switchboard)env;
        serverObjects prop = new serverObjects();
        prop.put("starturls", "");
        if (post == null) {
            return prop;
        }
        if (post.containsKey("crawlcheck")) {
            String[] rootURLs0;
            LinkedHashSet<DigestURL> rootURLs = new LinkedHashSet<DigestURL>();
            String crawlingStart0 = post.get("crawlingURLs", "").trim();
            for (String string : rootURLs0 = crawlingStart0.indexOf(10) > 0 || crawlingStart0.indexOf(13) > 0 ? crawlingStart0.split("[\\r\\n]+") : crawlingStart0.split(Pattern.quote("|"))) {
                if (string == null || string.length() == 0) continue;
                int pos = string.indexOf("://", 0);
                if (pos == -1) {
                    void var11_16;
                    if (string.startsWith("www")) {
                        String string2 = "http://" + string;
                    }
                    if (var11_16.startsWith("ftp")) {
                        String string3 = "ftp://" + (String)var11_16;
                    }
                }
                try {
                    void var11_13;
                    DigestURL crawlingStartURL = new DigestURL((String)var11_13);
                    rootURLs.add(crawlingStartURL);
                }
                catch (MalformedURLException e) {
                    ConcurrentLog.logException(e);
                }
            }
            if (rootURLs.size() == 0) {
                prop.put("table", 0L);
            } else {
                void var11_19;
                prop.put("table", 1L);
                ClientIdentification.Agent agent = ClientIdentification.getAgent(post.get("agentName", "YaCy Internet (cautious)"));
                Collection<RobotsTxt.CheckEntry> out = sb.robots.massCrawlCheck(rootURLs, agent);
                StringBuilder s = new StringBuilder(300);
                boolean bl = false;
                for (RobotsTxt.CheckEntry entry2 : out) {
                    String u = entry2.digestURL.toNormalform(true);
                    s.append(u).append('\n');
                    prop.put("table_list_" + (int)var11_19 + "_url", u);
                    boolean robotsAllowed = true;
                    if (entry2.robotsTxtEntry == null) {
                        prop.put("table_list_" + (int)var11_19 + "_robots", "no robots");
                        prop.put("table_list_" + (int)var11_19 + "_crawldelay", agent.minimumDelta() + " ms");
                        prop.put("table_list_" + (int)var11_19 + "_sitemap", "");
                    } else {
                        robotsAllowed = !entry2.robotsTxtEntry.isDisallowed(entry2.digestURL);
                        prop.put("table_list_" + (int)var11_19 + "_robots", "robots exist: " + (robotsAllowed ? "crawl allowed" : "url disallowed"));
                        prop.put("table_list_" + (int)var11_19 + "_crawldelay", Math.max(agent.minimumDelta(), entry2.robotsTxtEntry.getCrawlDelayMillis()) + " ms");
                        prop.put("table_list_" + (int)var11_19 + "_sitemap", entry2.robotsTxtEntry.getSitemaps().toString());
                    }
                    if (robotsAllowed) {
                        if (entry2.response == null) {
                            prop.put("table_list_" + (int)var11_19 + "_access", entry2.error == null ? "no response" : entry2.error);
                        } else if (entry2.response.getResponseHeader().getStatusCode() == 200) {
                            prop.put("table_list_" + (int)var11_19 + "_access", "200 ok, last-modified = " + String.valueOf(entry2.response.lastModified()));
                        } else {
                            prop.put("table_list_" + (int)var11_19 + "_access", entry2.response.getResponseHeader().getStatusCode() + " - load failed");
                        }
                    } else {
                        prop.put("table_list_" + (int)var11_19 + "_access", "not loaded - prevented by robots.txt");
                    }
                    ++var11_19;
                }
                prop.put("table_list", (long)var11_19);
                prop.put("starturls", s.toString());
            }
        }
        return prop;
    }
}

